/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.request.context.predicate.RegexpLikePredicate;
import org.apache.pinot.common.utils.RegexpPatternConverterUtils;
import org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.TextIndexReader;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class FSTBasedRegexpPredicateEvaluatorFactory {
    private FSTBasedRegexpPredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newFSTBasedEvaluator(RegexpLikePredicate regexpLikePredicate, TextIndexReader fstIndexReader, Dictionary dictionary) {
        return new FSTBasedRegexpPredicateEvaluator(regexpLikePredicate, fstIndexReader, dictionary);
    }

    private static class FSTBasedRegexpPredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final Dictionary _dictionary;
        final ImmutableRoaringBitmap _dictIds;

        public FSTBasedRegexpPredicateEvaluator(RegexpLikePredicate regexpLikePredicate, TextIndexReader fstIndexReader, Dictionary dictionary) {
            super((Predicate)regexpLikePredicate);
            this._dictionary = dictionary;
            String searchQuery = RegexpPatternConverterUtils.regexpLikeToLuceneRegExp((String)regexpLikePredicate.getValue());
            this._dictIds = fstIndexReader.getDictIds(searchQuery);
        }

        @Override
        public boolean isAlwaysFalse() {
            return this._dictIds.isEmpty();
        }

        @Override
        public boolean isAlwaysTrue() {
            return this._dictIds.getCardinality() == this._dictionary.length();
        }

        @Override
        public boolean applySV(int dictId) {
            return this._dictIds.contains(dictId);
        }

        @Override
        public int[] getMatchingDictIds() {
            return this._dictIds.toArray();
        }
    }
}

