/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BooleanUtils;
import org.apache.pinot.spi.utils.TimestampUtils;

public class PredicateUtils {
    private PredicateUtils() {
    }

    public static String getStoredValue(String value, FieldSpec.DataType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return PredicateUtils.getStoredBooleanValue(value);
            }
            case TIMESTAMP: {
                return PredicateUtils.getStoredTimestampValue(value);
            }
        }
        return value;
    }

    public static String getStoredBooleanValue(String booleanValue) {
        return Integer.toString(BooleanUtils.toInt((String)booleanValue));
    }

    public static String getStoredTimestampValue(String timestampValue) {
        return Long.toString(TimestampUtils.toMillisSinceEpoch((String)timestampValue));
    }
}

