/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import it.unimi.dsi.fastutil.ints.IntSet;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.request.context.predicate.RangePredicate;
import org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.BaseRawValueBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateUtils;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BooleanUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.pinot.spi.utils.TimestampUtils;

public class RangePredicateEvaluatorFactory {
    private RangePredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newDictionaryBasedEvaluator(RangePredicate rangePredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
        if (dictionary.isSorted()) {
            return new SortedDictionaryBasedRangePredicateEvaluator(rangePredicate, dictionary, dataType);
        }
        return new UnsortedDictionaryBasedRangePredicateEvaluator(rangePredicate, dictionary, dataType);
    }

    public static BaseRawValueBasedPredicateEvaluator newRawValueBasedEvaluator(RangePredicate rangePredicate, FieldSpec.DataType dataType) {
        String lowerBound = rangePredicate.getLowerBound();
        String upperBound = rangePredicate.getUpperBound();
        boolean lowerUnbounded = lowerBound.equals("*");
        boolean upperUnbounded = upperBound.equals("*");
        boolean lowerInclusive = lowerUnbounded || rangePredicate.isLowerInclusive();
        boolean upperInclusive = upperUnbounded || rangePredicate.isUpperInclusive();
        switch (dataType) {
            case INT: {
                return new IntRawValueBasedRangePredicateEvaluator(rangePredicate, lowerUnbounded ? Integer.MIN_VALUE : Integer.parseInt(lowerBound), upperUnbounded ? Integer.MAX_VALUE : Integer.parseInt(upperBound), lowerInclusive, upperInclusive);
            }
            case LONG: {
                return new LongRawValueBasedRangePredicateEvaluator(rangePredicate, lowerUnbounded ? Long.MIN_VALUE : Long.parseLong(lowerBound), upperUnbounded ? Long.MAX_VALUE : Long.parseLong(upperBound), lowerInclusive, upperInclusive);
            }
            case FLOAT: {
                return new FloatRawValueBasedRangePredicateEvaluator(rangePredicate, lowerUnbounded ? Float.NEGATIVE_INFINITY : Float.parseFloat(lowerBound), upperUnbounded ? Float.POSITIVE_INFINITY : Float.parseFloat(upperBound), lowerInclusive, upperInclusive);
            }
            case DOUBLE: {
                return new DoubleRawValueBasedRangePredicateEvaluator(rangePredicate, lowerUnbounded ? Double.NEGATIVE_INFINITY : Double.parseDouble(lowerBound), upperUnbounded ? Double.POSITIVE_INFINITY : Double.parseDouble(upperBound), lowerInclusive, upperInclusive);
            }
            case BOOLEAN: {
                return new IntRawValueBasedRangePredicateEvaluator(rangePredicate, lowerUnbounded ? Integer.MIN_VALUE : BooleanUtils.toInt((String)lowerBound), upperUnbounded ? Integer.MAX_VALUE : BooleanUtils.toInt((String)upperBound), lowerInclusive, upperInclusive);
            }
            case TIMESTAMP: {
                return new LongRawValueBasedRangePredicateEvaluator(rangePredicate, lowerUnbounded ? Long.MIN_VALUE : TimestampUtils.toMillisSinceEpoch((String)lowerBound), upperUnbounded ? Long.MAX_VALUE : TimestampUtils.toMillisSinceEpoch((String)upperBound), lowerInclusive, upperInclusive);
            }
            case STRING: {
                return new StringRawValueBasedRangePredicateEvaluator(rangePredicate, lowerUnbounded ? null : lowerBound, upperUnbounded ? null : upperBound, lowerInclusive, upperInclusive);
            }
            case BYTES: {
                return new BytesRawValueBasedRangePredicateEvaluator(rangePredicate, lowerUnbounded ? null : BytesUtils.toBytes((String)lowerBound), upperUnbounded ? null : BytesUtils.toBytes((String)upperBound), lowerInclusive, upperInclusive);
            }
        }
        throw new IllegalStateException("Unsupported data type: " + dataType);
    }

    private static final class BytesRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final byte[] _lowerBound;
        final byte[] _upperBound;
        final boolean _lowerInclusive;
        final boolean _upperInclusive;

        BytesRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate, byte[] lowerBound, byte[] upperBound, boolean lowerInclusive, boolean upperInclusive) {
            super((Predicate)rangePredicate);
            this._lowerBound = lowerBound;
            this._upperBound = upperBound;
            this._lowerInclusive = lowerInclusive;
            this._upperInclusive = upperInclusive;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.BYTES;
        }

        @Override
        public boolean applySV(byte[] value) {
            boolean result = true;
            if (this._lowerBound != null) {
                if (this._lowerInclusive) {
                    result = ByteArray.compare((byte[])this._lowerBound, (byte[])value) <= 0;
                } else {
                    boolean bl = result = ByteArray.compare((byte[])this._lowerBound, (byte[])value) < 0;
                }
            }
            if (this._upperBound != null) {
                result = this._upperInclusive ? (result &= ByteArray.compare((byte[])this._upperBound, (byte[])value) >= 0) : (result &= ByteArray.compare((byte[])this._upperBound, (byte[])value) > 0);
            }
            return result;
        }
    }

    private static final class StringRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final String _lowerBound;
        final String _upperBound;
        final boolean _lowerInclusive;
        final boolean _upperInclusive;

        StringRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate, String lowerBound, String upperBound, boolean lowerInclusive, boolean upperInclusive) {
            super((Predicate)rangePredicate);
            this._lowerBound = lowerBound;
            this._upperBound = upperBound;
            this._lowerInclusive = lowerInclusive;
            this._upperInclusive = upperInclusive;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.STRING;
        }

        @Override
        public boolean applySV(String value) {
            boolean result = true;
            if (this._lowerBound != null) {
                if (this._lowerInclusive) {
                    result = this._lowerBound.compareTo(value) <= 0;
                } else {
                    boolean bl = result = this._lowerBound.compareTo(value) < 0;
                }
            }
            if (this._upperBound != null) {
                result = this._upperInclusive ? (result &= this._upperBound.compareTo(value) >= 0) : (result &= this._upperBound.compareTo(value) > 0);
            }
            return result;
        }
    }

    public static final class DoubleRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final double _lowerBound;
        final double _upperBound;
        final boolean _lowerInclusive;
        final boolean _upperInclusive;

        DoubleRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate, double lowerBound, double upperBound, boolean lowerInclusive, boolean upperInclusive) {
            super((Predicate)rangePredicate);
            this._lowerBound = lowerBound;
            this._upperBound = upperBound;
            this._lowerInclusive = lowerInclusive;
            this._upperInclusive = upperInclusive;
        }

        public double geLowerBound() {
            return this._lowerBound;
        }

        public double getUpperBound() {
            return this._upperBound;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.DOUBLE;
        }

        @Override
        public boolean applySV(double value) {
            boolean result;
            if (this._lowerInclusive) {
                result = this._lowerBound <= value;
            } else {
                boolean bl = result = this._lowerBound < value;
            }
            result = this._upperInclusive ? (result &= this._upperBound >= value) : (result &= this._upperBound > value);
            return result;
        }
    }

    public static final class FloatRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final float _lowerBound;
        final float _upperBound;
        final boolean _lowerInclusive;
        final boolean _upperInclusive;

        FloatRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate, float lowerBound, float upperBound, boolean lowerInclusive, boolean upperInclusive) {
            super((Predicate)rangePredicate);
            this._lowerBound = lowerBound;
            this._upperBound = upperBound;
            this._lowerInclusive = lowerInclusive;
            this._upperInclusive = upperInclusive;
        }

        public float geLowerBound() {
            return this._lowerBound;
        }

        public float getUpperBound() {
            return this._upperBound;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.FLOAT;
        }

        @Override
        public boolean applySV(float value) {
            boolean result;
            if (this._lowerInclusive) {
                result = this._lowerBound <= value;
            } else {
                boolean bl = result = this._lowerBound < value;
            }
            result = this._upperInclusive ? (result &= this._upperBound >= value) : (result &= this._upperBound > value);
            return result;
        }
    }

    public static final class LongRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final long _lowerBound;
        final long _upperBound;
        final boolean _lowerInclusive;
        final boolean _upperInclusive;

        LongRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate, long lowerBound, long upperBound, boolean lowerInclusive, boolean upperInclusive) {
            super((Predicate)rangePredicate);
            this._lowerBound = lowerBound;
            this._upperBound = upperBound;
            this._lowerInclusive = lowerInclusive;
            this._upperInclusive = upperInclusive;
        }

        public long geLowerBound() {
            return this._lowerBound;
        }

        public long getUpperBound() {
            return this._upperBound;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.LONG;
        }

        @Override
        public boolean applySV(long value) {
            boolean result;
            if (this._lowerInclusive) {
                result = this._lowerBound <= value;
            } else {
                boolean bl = result = this._lowerBound < value;
            }
            result = this._upperInclusive ? (result &= this._upperBound >= value) : (result &= this._upperBound > value);
            return result;
        }
    }

    public static final class IntRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final int _lowerBound;
        final int _upperBound;
        final boolean _lowerInclusive;
        final boolean _upperInclusive;

        IntRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate, int lowerBound, int upperBound, boolean lowerInclusive, boolean upperInclusive) {
            super((Predicate)rangePredicate);
            this._lowerBound = lowerBound;
            this._upperBound = upperBound;
            this._lowerInclusive = lowerInclusive;
            this._upperInclusive = upperInclusive;
        }

        public int geLowerBound() {
            return this._lowerBound;
        }

        public int getUpperBound() {
            return this._upperBound;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.INT;
        }

        @Override
        public boolean applySV(int value) {
            boolean result;
            if (this._lowerInclusive) {
                result = this._lowerBound <= value;
            } else {
                boolean bl = result = this._lowerBound < value;
            }
            result = this._upperInclusive ? (result &= this._upperBound >= value) : (result &= this._upperBound > value);
            return result;
        }
    }

    private static final class UnsortedDictionaryBasedRangePredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        private static final int DICT_ID_SET_BASED_CARDINALITY_THRESHOLD = 1000;
        final Dictionary _dictionary;
        final boolean _dictIdSetBased;
        final IntSet _matchingDictIdSet;
        final BaseRawValueBasedPredicateEvaluator _rawValueBasedEvaluator;

        UnsortedDictionaryBasedRangePredicateEvaluator(RangePredicate rangePredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
            super((Predicate)rangePredicate);
            this._dictionary = dictionary;
            int cardinality = dictionary.length();
            if (cardinality < 1000) {
                String upperBound;
                this._dictIdSetBased = true;
                this._rawValueBasedEvaluator = null;
                String lowerBound = rangePredicate.getLowerBound();
                if (!lowerBound.equals("*")) {
                    lowerBound = PredicateUtils.getStoredValue(lowerBound, dataType);
                }
                if (!(upperBound = rangePredicate.getUpperBound()).equals("*")) {
                    upperBound = PredicateUtils.getStoredValue(upperBound, dataType);
                }
                this._matchingDictIdSet = dictionary.getDictIdsInRange(lowerBound, upperBound, rangePredicate.isLowerInclusive(), rangePredicate.isUpperInclusive());
                int numMatchingDictIds = this._matchingDictIdSet.size();
                if (numMatchingDictIds == 0) {
                    this._alwaysFalse = true;
                } else if (numMatchingDictIds == cardinality) {
                    this._alwaysTrue = true;
                }
            } else {
                this._dictIdSetBased = false;
                this._matchingDictIdSet = null;
                this._rawValueBasedEvaluator = RangePredicateEvaluatorFactory.newRawValueBasedEvaluator(rangePredicate, dataType);
            }
        }

        @Override
        public boolean applySV(int dictId) {
            if (this._dictIdSetBased) {
                return this._matchingDictIdSet.contains(dictId);
            }
            switch (this._dictionary.getValueType()) {
                case INT: {
                    return this._rawValueBasedEvaluator.applySV(this._dictionary.getIntValue(dictId));
                }
                case LONG: {
                    return this._rawValueBasedEvaluator.applySV(this._dictionary.getLongValue(dictId));
                }
                case FLOAT: {
                    return this._rawValueBasedEvaluator.applySV(this._dictionary.getFloatValue(dictId));
                }
                case DOUBLE: {
                    return this._rawValueBasedEvaluator.applySV(this._dictionary.getDoubleValue(dictId));
                }
                case STRING: {
                    return this._rawValueBasedEvaluator.applySV(this._dictionary.getStringValue(dictId));
                }
                case BYTES: {
                    return this._rawValueBasedEvaluator.applySV(this._dictionary.getBytesValue(dictId));
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public int[] getMatchingDictIds() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class SortedDictionaryBasedRangePredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final int _startDictId;
        final int _endDictId;
        final int _numMatchingDictIds;
        int[] _matchingDictIds;

        SortedDictionaryBasedRangePredicateEvaluator(RangePredicate rangePredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
            super((Predicate)rangePredicate);
            int insertionIndex;
            String lowerBound = rangePredicate.getLowerBound();
            String upperBound = rangePredicate.getUpperBound();
            boolean lowerInclusive = rangePredicate.isLowerInclusive();
            boolean upperInclusive = rangePredicate.isUpperInclusive();
            this._startDictId = lowerBound.equals("*") ? 0 : ((insertionIndex = dictionary.insertionIndexOf(PredicateUtils.getStoredValue(lowerBound, dataType))) < 0 ? -(insertionIndex + 1) : (lowerInclusive ? insertionIndex : insertionIndex + 1));
            this._endDictId = upperBound.equals("*") ? dictionary.length() : ((insertionIndex = dictionary.insertionIndexOf(PredicateUtils.getStoredValue(upperBound, dataType))) < 0 ? -(insertionIndex + 1) : (upperInclusive ? insertionIndex + 1 : insertionIndex));
            this._numMatchingDictIds = this._endDictId - this._startDictId;
            if (this._numMatchingDictIds <= 0) {
                this._alwaysFalse = true;
            } else if (dictionary.length() == this._numMatchingDictIds) {
                this._alwaysTrue = true;
            }
        }

        public int getStartDictId() {
            return this._startDictId;
        }

        public int getEndDictId() {
            return this._endDictId;
        }

        @Override
        public boolean applySV(int dictId) {
            return this._startDictId <= dictId && this._endDictId > dictId;
        }

        @Override
        public int getNumMatchingDictIds() {
            return this._numMatchingDictIds;
        }

        @Override
        public int[] getMatchingDictIds() {
            if (this._matchingDictIds == null) {
                if (this._numMatchingDictIds <= 0) {
                    this._matchingDictIds = new int[0];
                } else {
                    this._matchingDictIds = new int[this._numMatchingDictIds];
                    for (int i = 0; i < this._numMatchingDictIds; ++i) {
                        this._matchingDictIds[i] = this._startDictId + i;
                    }
                }
            }
            return this._matchingDictIds;
        }
    }
}

