/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.DefaultGroupByExecutor;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.startree.executor.StarTreeGroupByExecutor;

public class AggregationGroupByOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String OPERATOR_NAME = "AggregationGroupByOperator";
    private static final String EXPLAIN_NAME = "AGGREGATE_GROUPBY";
    private final QueryContext _queryContext;
    private final ExpressionContext[] _groupByExpressions;
    private final TransformOperator _transformOperator;
    private final long _numTotalDocs;
    private final boolean _useStarTree;
    private int _numDocsScanned = 0;

    public AggregationGroupByOperator(QueryContext queryContext, ExpressionContext[] groupByExpressions, TransformOperator transformOperator, long numTotalDocs, boolean useStarTree) {
        this._queryContext = queryContext;
        this._groupByExpressions = groupByExpressions;
        this._transformOperator = transformOperator;
        this._numTotalDocs = numTotalDocs;
        this._useStarTree = useStarTree;
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        TransformBlock transformBlock;
        DefaultGroupByExecutor groupByExecutor = this._useStarTree ? new StarTreeGroupByExecutor(this._queryContext, this._groupByExpressions, this._transformOperator) : new DefaultGroupByExecutor(this._queryContext, this._groupByExpressions, this._transformOperator);
        while ((transformBlock = (TransformBlock)this._transformOperator.nextBlock()) != null) {
            this._numDocsScanned += transformBlock.getNumDocs();
            groupByExecutor.process(transformBlock);
        }
        return new IntermediateResultsBlock(this._queryContext.getAggregationFunctions(), groupByExecutor.getResult());
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.singletonList(this._transformOperator);
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._transformOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        long numEntriesScannedPostFilter = (long)this._numDocsScanned * (long)this._transformOperator.getNumColumnsProjected();
        return new ExecutionStatistics(this._numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, this._numTotalDocs);
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(groupKeys:");
        if (this._groupByExpressions.length > 0) {
            stringBuilder.append(this._groupByExpressions[0].toString());
            for (int i = 0; i < this._groupByExpressions.length; ++i) {
                stringBuilder.append(", ").append(this._groupByExpressions[i].toString());
            }
        }
        stringBuilder.append("aggregations:");
        AggregationFunction[] aggregationFunctions = this._queryContext.getAggregationFunctions();
        if (aggregationFunctions.length > 0) {
            stringBuilder.append(aggregationFunctions[0].toExplainString());
            for (int i = 1; i < aggregationFunctions.length; ++i) {
                stringBuilder.append(", ").append(aggregationFunctions[i].toExplainString());
            }
        }
        return stringBuilder.append(')').toString();
    }
}

