/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountSmartHLLAggregationFunction;
import org.apache.pinot.segment.local.customobject.MinMaxRangePair;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.utils.ByteArray;

public class DictionaryBasedAggregationOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String OPERATOR_NAME = "DictionaryBasedAggregationOperator";
    private static final String EXPLAIN_NAME = "AGGREGATE_DICTIONARY";
    private final AggregationFunction[] _aggregationFunctions;
    private final Map<String, Dictionary> _dictionaryMap;
    private final int _numTotalDocs;

    public DictionaryBasedAggregationOperator(AggregationFunction[] aggregationFunctions, Map<String, Dictionary> dictionaryMap, int numTotalDocs) {
        this._aggregationFunctions = aggregationFunctions;
        this._dictionaryMap = dictionaryMap;
        this._numTotalDocs = numTotalDocs;
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        ArrayList<Object> aggregationResults = new ArrayList<Object>(this._aggregationFunctions.length);
        block8: for (AggregationFunction aggregationFunction : this._aggregationFunctions) {
            String column = aggregationFunction.getInputExpressions().get(0).getIdentifier();
            Dictionary dictionary = this._dictionaryMap.get(column);
            int dictionarySize = dictionary.length();
            switch (aggregationFunction.getType()) {
                case MIN: {
                    aggregationResults.add(this.toDouble(dictionary.getMinVal()));
                    continue block8;
                }
                case MAX: {
                    aggregationResults.add(this.toDouble(dictionary.getMaxVal()));
                    continue block8;
                }
                case MINMAXRANGE: {
                    aggregationResults.add(new MinMaxRangePair(this.toDouble(dictionary.getMinVal()), this.toDouble(dictionary.getMaxVal())));
                    continue block8;
                }
                case DISTINCTCOUNT: {
                    aggregationResults.add(this.getDistinctValueSet(dictionary));
                    continue block8;
                }
                case SEGMENTPARTITIONEDDISTINCTCOUNT: {
                    aggregationResults.add(Long.valueOf(dictionarySize));
                    continue block8;
                }
                case DISTINCTCOUNTSMARTHLL: {
                    DistinctCountSmartHLLAggregationFunction distinctCountSmartHLLAggregationFunction = (DistinctCountSmartHLLAggregationFunction)aggregationFunction;
                    if (dictionarySize > distinctCountSmartHLLAggregationFunction.getHllConversionThreshold()) {
                        HyperLogLog hll = new HyperLogLog(distinctCountSmartHLLAggregationFunction.getHllLog2m());
                        for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                            hll.offer(dictionary.get(dictId));
                        }
                        aggregationResults.add(hll);
                        continue block8;
                    }
                    aggregationResults.add(this.getDistinctValueSet(dictionary));
                    continue block8;
                }
                default: {
                    throw new IllegalStateException("Dictionary based aggregation operator does not support function type: " + aggregationFunction.getType());
                }
            }
        }
        return new IntermediateResultsBlock(this._aggregationFunctions, aggregationResults, false);
    }

    private double toDouble(Comparable value) {
        if (value instanceof Number) {
            return ((Number)((Object)value)).doubleValue();
        }
        return Double.parseDouble(value.toString());
    }

    private Set getDistinctValueSet(Dictionary dictionary) {
        int dictionarySize = dictionary.length();
        switch (dictionary.getValueType()) {
            case INT: {
                IntOpenHashSet intSet = new IntOpenHashSet(dictionarySize);
                for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                    intSet.add(dictionary.getIntValue(dictId));
                }
                return intSet;
            }
            case LONG: {
                LongOpenHashSet longSet = new LongOpenHashSet(dictionarySize);
                for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                    longSet.add(dictionary.getLongValue(dictId));
                }
                return longSet;
            }
            case FLOAT: {
                FloatOpenHashSet floatSet = new FloatOpenHashSet(dictionarySize);
                for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                    floatSet.add(dictionary.getFloatValue(dictId));
                }
                return floatSet;
            }
            case DOUBLE: {
                DoubleOpenHashSet doubleSet = new DoubleOpenHashSet(dictionarySize);
                for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                    doubleSet.add(dictionary.getDoubleValue(dictId));
                }
                return doubleSet;
            }
            case STRING: {
                ObjectOpenHashSet stringSet = new ObjectOpenHashSet(dictionarySize);
                for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                    stringSet.add((Object)dictionary.getStringValue(dictId));
                }
                return stringSet;
            }
            case BYTES: {
                ObjectOpenHashSet bytesSet = new ObjectOpenHashSet(dictionarySize);
                for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                    bytesSet.add((Object)new ByteArray(dictionary.getBytesValue(dictId)));
                }
                return bytesSet;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return new ExecutionStatistics(this._numTotalDocs, 0L, 0L, this._numTotalDocs);
    }
}

