/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.query.aggregation.DefaultAggregationExecutor;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;

public class FilteredAggregationOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String OPERATOR_NAME = "FilteredAggregationOperator";
    private static final String EXPLAIN_NAME = "AGGREGATE_FILTERED";
    private final AggregationFunction[] _aggregationFunctions;
    private final List<Pair<AggregationFunction[], TransformOperator>> _aggFunctionsWithTransformOperator;
    private final long _numTotalDocs;
    private long _numDocsScanned;
    private long _numEntriesScannedInFilter;
    private long _numEntriesScannedPostFilter;

    public FilteredAggregationOperator(AggregationFunction[] aggregationFunctions, List<Pair<AggregationFunction[], TransformOperator>> aggFunctionsWithTransformOperator, long numTotalDocs) {
        this._aggregationFunctions = aggregationFunctions;
        this._aggFunctionsWithTransformOperator = aggFunctionsWithTransformOperator;
        this._numTotalDocs = numTotalDocs;
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        int numAggregations = this._aggregationFunctions.length;
        Object[] result = new Object[numAggregations];
        IdentityHashMap<AggregationFunction, Integer> resultIndexMap = new IdentityHashMap<AggregationFunction, Integer>(numAggregations);
        for (int i = 0; i < numAggregations; ++i) {
            resultIndexMap.put(this._aggregationFunctions[i], i);
        }
        for (Pair<AggregationFunction[], TransformOperator> filteredAggregation : this._aggFunctionsWithTransformOperator) {
            TransformBlock transformBlock;
            AggregationFunction[] aggregationFunctions = (AggregationFunction[])filteredAggregation.getLeft();
            DefaultAggregationExecutor aggregationExecutor = new DefaultAggregationExecutor(aggregationFunctions);
            TransformOperator transformOperator = (TransformOperator)filteredAggregation.getRight();
            int numDocsScanned = 0;
            while ((transformBlock = (TransformBlock)transformOperator.nextBlock()) != null) {
                aggregationExecutor.aggregate(transformBlock);
                numDocsScanned += transformBlock.getNumDocs();
            }
            List<Object> filteredResult = aggregationExecutor.getResult();
            for (int i = 0; i < aggregationFunctions.length; ++i) {
                result[((Integer)resultIndexMap.get((Object)aggregationFunctions[i])).intValue()] = filteredResult.get(i);
            }
            this._numDocsScanned += (long)numDocsScanned;
            this._numEntriesScannedInFilter += transformOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
            this._numEntriesScannedPostFilter += (long)numDocsScanned * (long)transformOperator.getNumColumnsProjected();
        }
        return new IntermediateResultsBlock(this._aggregationFunctions, Arrays.asList(result), false);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return this._aggFunctionsWithTransformOperator.stream().map(Pair::getRight).collect(Collectors.toList());
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return new ExecutionStatistics(this._numDocsScanned, this._numEntriesScannedInFilter, this._numEntriesScannedPostFilter, this._numTotalDocs);
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }
}

