/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.ProjectionOperator;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunctionFactory;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.util.GapfillUtils;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.Dictionary;

public class TransformOperator
extends BaseOperator<TransformBlock> {
    private static final String OPERATOR_NAME = "TransformOperator";
    private static final String EXPLAIN_NAME = "TRANSFORM";
    protected final ProjectionOperator _projectionOperator;
    protected final Map<String, DataSource> _dataSourceMap;
    protected final Map<ExpressionContext, TransformFunction> _transformFunctionMap = new HashMap<ExpressionContext, TransformFunction>();

    public TransformOperator(@Nullable QueryContext queryContext, ProjectionOperator projectionOperator, Collection<ExpressionContext> expressions) {
        this._projectionOperator = projectionOperator;
        this._dataSourceMap = projectionOperator.getDataSourceMap();
        for (ExpressionContext expression : expressions) {
            TransformFunction transformFunction = TransformFunctionFactory.get(queryContext, GapfillUtils.stripGapfill(expression), this._dataSourceMap);
            this._transformFunctionMap.put(expression, transformFunction);
        }
    }

    public TransformOperator(ProjectionOperator projectionOperator, Collection<ExpressionContext> expressions) {
        this(null, projectionOperator, expressions);
    }

    public int getNumColumnsProjected() {
        return this._dataSourceMap.size();
    }

    public TransformResultMetadata getResultMetadata(ExpressionContext expression) {
        return this._transformFunctionMap.get(expression).getResultMetadata();
    }

    public Dictionary getDictionary(ExpressionContext expression) {
        return this._transformFunctionMap.get(expression).getDictionary();
    }

    @Override
    protected TransformBlock getNextBlock() {
        ProjectionBlock projectionBlock = (ProjectionBlock)this._projectionOperator.nextBlock();
        if (projectionBlock == null) {
            return null;
        }
        return new TransformBlock(projectionBlock, this._transformFunctionMap);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public String toExplainString() {
        return this.toExplainString(EXPLAIN_NAME);
    }

    public String toExplainString(String explainName) {
        ExpressionContext[] functions = this._transformFunctionMap.keySet().toArray(new ExpressionContext[0]);
        Arrays.sort(functions, Comparator.comparing(ExpressionContext::toString));
        StringBuilder stringBuilder = new StringBuilder(explainName).append("(");
        if (functions != null && functions.length > 0) {
            stringBuilder.append(functions[0].toString());
            for (int i = 1; i < functions.length; ++i) {
                stringBuilder.append(", ").append(functions[i].toString());
            }
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.singletonList(this._projectionOperator);
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return this._projectionOperator.getExecutionStatistics();
    }
}

