/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class ArrayLengthTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "arrayLength";
    private int[] _results;
    private TransformFunction _argument;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("Exactly 1 argument is required for ARRAYLENGTH transform function");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction || firstArgument.getResultMetadata().isSingleValue()) {
            throw new IllegalArgumentException("The argument of ARRAYLENGTH transform function must be a multi-valued column or a transform function");
        }
        this._argument = firstArgument;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return INT_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        if (this._results == null) {
            this._results = new int[10000];
        }
        int numDocs = projectionBlock.getNumDocs();
        switch (this._argument.getResultMetadata().getDataType().getStoredType()) {
            case INT: {
                int[][] intValuesMV = this._argument.transformToIntValuesMV(projectionBlock);
                for (int i = 0; i < numDocs; ++i) {
                    this._results[i] = intValuesMV[i].length;
                }
                break;
            }
            case LONG: {
                long[][] longValuesMV = this._argument.transformToLongValuesMV(projectionBlock);
                for (int i = 0; i < numDocs; ++i) {
                    this._results[i] = longValuesMV[i].length;
                }
                break;
            }
            case FLOAT: {
                float[][] floatValuesMV = this._argument.transformToFloatValuesMV(projectionBlock);
                for (int i = 0; i < numDocs; ++i) {
                    this._results[i] = floatValuesMV[i].length;
                }
                break;
            }
            case DOUBLE: {
                double[][] doubleValuesMV = this._argument.transformToDoubleValuesMV(projectionBlock);
                for (int i = 0; i < numDocs; ++i) {
                    this._results[i] = doubleValuesMV[i].length;
                }
                break;
            }
            case STRING: {
                String[][] stringValuesMV = this._argument.transformToStringValuesMV(projectionBlock);
                for (int i = 0; i < numDocs; ++i) {
                    this._results[i] = stringValuesMV[i].length;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this._results;
    }
}

