/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;

public class ArrayMinTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "arrayMin";
    private int[] _intValuesSV;
    private long[] _longValuesSV;
    private float[] _floatValuesSV;
    private double[] _doubleValuesSV;
    private String[] _stringValuesSV;
    private TransformFunction _argument;
    private TransformResultMetadata _resultMetadata;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("Exactly 1 argument is required for ArrayMin transform function");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction || firstArgument.getResultMetadata().isSingleValue()) {
            throw new IllegalArgumentException("The argument of ArrayMin transform function must be a multi-valued column or a transform function");
        }
        this._resultMetadata = new TransformResultMetadata(firstArgument.getResultMetadata().getDataType(), true, false);
        this._argument = firstArgument;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        if (this._argument.getResultMetadata().getDataType().getStoredType() != FieldSpec.DataType.INT) {
            return super.transformToIntValuesSV(projectionBlock);
        }
        if (this._intValuesSV == null) {
            this._intValuesSV = new int[10000];
        }
        int length = projectionBlock.getNumDocs();
        int[][] intValuesMV = this._argument.transformToIntValuesMV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            int minRes = Integer.MAX_VALUE;
            for (int value : intValuesMV[i]) {
                minRes = Math.min(minRes, value);
            }
            this._intValuesSV[i] = minRes;
        }
        return this._intValuesSV;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        if (this._argument.getResultMetadata().getDataType().getStoredType() != FieldSpec.DataType.LONG) {
            return super.transformToLongValuesSV(projectionBlock);
        }
        if (this._longValuesSV == null) {
            this._longValuesSV = new long[10000];
        }
        int length = projectionBlock.getNumDocs();
        long[][] longValuesMV = this._argument.transformToLongValuesMV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            long minRes = Long.MAX_VALUE;
            for (long value : longValuesMV[i]) {
                minRes = Math.min(minRes, value);
            }
            this._longValuesSV[i] = minRes;
        }
        return this._longValuesSV;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        if (this._argument.getResultMetadata().getDataType().getStoredType() != FieldSpec.DataType.FLOAT) {
            return super.transformToFloatValuesSV(projectionBlock);
        }
        if (this._floatValuesSV == null) {
            this._floatValuesSV = new float[10000];
        }
        int length = projectionBlock.getNumDocs();
        float[][] floatValuesMV = this._argument.transformToFloatValuesMV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            float minRes = Float.POSITIVE_INFINITY;
            for (float value : floatValuesMV[i]) {
                minRes = Math.min(minRes, value);
            }
            this._floatValuesSV[i] = minRes;
        }
        return this._floatValuesSV;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._argument.getResultMetadata().getDataType().getStoredType() != FieldSpec.DataType.DOUBLE) {
            return super.transformToDoubleValuesSV(projectionBlock);
        }
        if (this._doubleValuesSV == null) {
            this._doubleValuesSV = new double[10000];
        }
        int length = projectionBlock.getNumDocs();
        double[][] doubleValuesMV = this._argument.transformToDoubleValuesMV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            double minRes = Double.POSITIVE_INFINITY;
            for (double value : doubleValuesMV[i]) {
                minRes = Math.min(minRes, value);
            }
            this._doubleValuesSV[i] = minRes;
        }
        return this._doubleValuesSV;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        if (this._argument.getResultMetadata().getDataType().getStoredType() != FieldSpec.DataType.STRING) {
            return super.transformToStringValuesSV(projectionBlock);
        }
        if (this._stringValuesSV == null) {
            this._stringValuesSV = new String[10000];
        }
        int length = projectionBlock.getNumDocs();
        String[][] stringValuesMV = this._argument.transformToStringValuesMV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            String minRes = null;
            for (String value : stringValuesMV[i]) {
                if (StringUtils.compare(minRes, (String)value) <= 0) continue;
                minRes = value;
            }
            this._stringValuesSV[i] = minRes;
        }
        return this._stringValuesSV;
    }
}

