/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class ArraySumTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "arraySum";
    private double[] _results;
    private TransformFunction _argument;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("Exactly 1 argument is required for ArraySum transform function");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction || firstArgument.getResultMetadata().isSingleValue()) {
            throw new IllegalArgumentException("The argument of ArraySum transform function must be a multi-valued column or a transform function");
        }
        if (!firstArgument.getResultMetadata().getDataType().getStoredType().isNumeric()) {
            throw new IllegalArgumentException("The argument of ArraySum transform function must be numeric");
        }
        this._argument = firstArgument;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return DOUBLE_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._results == null) {
            this._results = new double[10000];
        }
        int length = projectionBlock.getNumDocs();
        double[][] doubleValuesMV = this._argument.transformToDoubleValuesMV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            double sumRes = 0.0;
            for (double value : doubleValuesMV[i]) {
                sumRes += value;
            }
            this._results[i] = sumRes;
        }
        return this._results;
    }
}

