/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;

public class CaseTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "case";
    private List<TransformFunction> _whenStatements = new ArrayList<TransformFunction>();
    private List<TransformFunction> _elseThenStatements = new ArrayList<TransformFunction>();
    private boolean[] _selections;
    private int _numSelections;
    private TransformResultMetadata _resultMetadata;
    private int[] _selectedResults;
    private int[] _intResults;
    private long[] _longResults;
    private float[] _floatResults;
    private double[] _doubleResults;
    private String[] _stringResults;
    private byte[][] _bytesResults;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        int i;
        if (arguments.size() % 2 != 1 || arguments.size() < 3) {
            throw new IllegalArgumentException("At least 3 odd number of arguments are required for CASE-WHEN-ELSE function");
        }
        int numWhenStatements = arguments.size() / 2;
        this._whenStatements = new ArrayList<TransformFunction>(numWhenStatements);
        for (i = 0; i < numWhenStatements; ++i) {
            this._whenStatements.add(arguments.get(i));
        }
        this._elseThenStatements = new ArrayList<TransformFunction>(numWhenStatements + 1);
        this._elseThenStatements.add(arguments.get(numWhenStatements * 2));
        for (i = numWhenStatements; i < numWhenStatements * 2; ++i) {
            this._elseThenStatements.add(arguments.get(i));
        }
        this._selections = new boolean[this._elseThenStatements.size()];
        this._resultMetadata = this.calculateResultMetadata();
    }

    private TransformResultMetadata calculateResultMetadata() {
        TransformFunction elseStatement = this._elseThenStatements.get(0);
        TransformResultMetadata elseStatementResultMetadata = elseStatement.getResultMetadata();
        FieldSpec.DataType dataType = elseStatementResultMetadata.getDataType();
        Preconditions.checkState((boolean)elseStatementResultMetadata.isSingleValue(), (Object)"Unsupported multi-value expression in the ELSE clause");
        int numThenStatements = this._elseThenStatements.size() - 1;
        block20: for (int i = 0; i < numThenStatements; ++i) {
            TransformFunction thenStatement = this._elseThenStatements.get(i + 1);
            TransformResultMetadata thenStatementResultMetadata = thenStatement.getResultMetadata();
            if (!thenStatementResultMetadata.isSingleValue()) {
                throw new IllegalStateException("Unsupported multi-value expression in the THEN clause of index: " + i);
            }
            FieldSpec.DataType thenStatementDataType = thenStatementResultMetadata.getDataType();
            if (thenStatementDataType == dataType) continue;
            switch (dataType) {
                case INT: {
                    switch (thenStatementDataType) {
                        case LONG: {
                            dataType = FieldSpec.DataType.LONG;
                            continue block20;
                        }
                        case FLOAT: 
                        case DOUBLE: {
                            dataType = FieldSpec.DataType.DOUBLE;
                            continue block20;
                        }
                    }
                    dataType = FieldSpec.DataType.STRING;
                    continue block20;
                }
                case LONG: {
                    switch (thenStatementDataType) {
                        case INT: {
                            continue block20;
                        }
                        case FLOAT: 
                        case DOUBLE: {
                            dataType = FieldSpec.DataType.DOUBLE;
                            continue block20;
                        }
                    }
                    dataType = FieldSpec.DataType.STRING;
                    continue block20;
                }
                case FLOAT: {
                    switch (thenStatementDataType) {
                        case LONG: 
                        case DOUBLE: 
                        case INT: {
                            dataType = FieldSpec.DataType.DOUBLE;
                            continue block20;
                        }
                    }
                    dataType = FieldSpec.DataType.STRING;
                    continue block20;
                }
                case DOUBLE: {
                    switch (thenStatementDataType) {
                        case LONG: 
                        case FLOAT: 
                        case INT: {
                            continue block20;
                        }
                    }
                    dataType = FieldSpec.DataType.STRING;
                    continue block20;
                }
                default: {
                    dataType = FieldSpec.DataType.STRING;
                }
            }
        }
        return new TransformResultMetadata(dataType, true, false);
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    private int[] getSelectedArray(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._selectedResults == null || this._selectedResults.length < numDocs) {
            this._selectedResults = new int[numDocs];
        } else {
            Arrays.fill(this._selectedResults, 0, numDocs, 0);
            Arrays.fill(this._selections, false);
        }
        int numWhenStatements = this._whenStatements.size();
        for (int i = numWhenStatements - 1; i >= 0; --i) {
            TransformFunction whenStatement = this._whenStatements.get(i);
            int[] conditions = whenStatement.transformToIntValuesSV(projectionBlock);
            int j = 0;
            while (j < numDocs & j < conditions.length) {
                this._selectedResults[j] = Math.max(conditions[j] * (i + 1), this._selectedResults[j]);
                this._selections[this._selectedResults[j]] = true;
                ++j;
            }
        }
        int numSelections = 0;
        for (boolean selection : this._selections) {
            if (!selection) continue;
            ++numSelections;
        }
        this._numSelections = numSelections;
        return this._selectedResults;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.INT) {
            return super.transformToIntValuesSV(projectionBlock);
        }
        int[] selected = this.getSelectedArray(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        if (this._intResults == null || this._intResults.length < numDocs) {
            this._intResults = new int[numDocs];
        }
        int numElseThenStatements = this._elseThenStatements.size();
        for (int i = 0; i < numElseThenStatements; ++i) {
            if (!this._selections[i]) continue;
            TransformFunction transformFunction = this._elseThenStatements.get(i);
            int[] intValues = transformFunction.transformToIntValuesSV(projectionBlock);
            if (this._numSelections == 1) {
                System.arraycopy(intValues, 0, this._intResults, 0, numDocs);
                continue;
            }
            for (int j = 0; j < numDocs; ++j) {
                if (selected[j] != i) continue;
                this._intResults[j] = intValues[j];
            }
        }
        return this._intResults;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.LONG) {
            return super.transformToLongValuesSV(projectionBlock);
        }
        int[] selected = this.getSelectedArray(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        if (this._longResults == null || this._longResults.length < numDocs) {
            this._longResults = new long[numDocs];
        }
        int numElseThenStatements = this._elseThenStatements.size();
        for (int i = 0; i < numElseThenStatements; ++i) {
            if (!this._selections[i]) continue;
            TransformFunction transformFunction = this._elseThenStatements.get(i);
            long[] longValues = transformFunction.transformToLongValuesSV(projectionBlock);
            if (this._numSelections == 1) {
                System.arraycopy(longValues, 0, this._longResults, 0, numDocs);
                continue;
            }
            for (int j = 0; j < numDocs; ++j) {
                if (selected[j] != i) continue;
                this._longResults[j] = longValues[j];
            }
        }
        return this._longResults;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.FLOAT) {
            return super.transformToFloatValuesSV(projectionBlock);
        }
        int[] selected = this.getSelectedArray(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        if (this._floatResults == null || this._floatResults.length < numDocs) {
            this._floatResults = new float[numDocs];
        }
        int numElseThenStatements = this._elseThenStatements.size();
        for (int i = 0; i < numElseThenStatements; ++i) {
            if (!this._selections[i]) continue;
            TransformFunction transformFunction = this._elseThenStatements.get(i);
            float[] floatValues = transformFunction.transformToFloatValuesSV(projectionBlock);
            if (this._numSelections == 1) {
                System.arraycopy(floatValues, 0, this._floatResults, 0, numDocs);
                continue;
            }
            for (int j = 0; j < numDocs; ++j) {
                if (selected[j] != i) continue;
                this._floatResults[j] = floatValues[j];
            }
        }
        return this._floatResults;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.DOUBLE) {
            return super.transformToDoubleValuesSV(projectionBlock);
        }
        int[] selected = this.getSelectedArray(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        if (this._doubleResults == null || this._doubleResults.length < numDocs) {
            this._doubleResults = new double[numDocs];
        }
        int numElseThenStatements = this._elseThenStatements.size();
        for (int i = 0; i < numElseThenStatements; ++i) {
            if (!this._selections[i]) continue;
            TransformFunction transformFunction = this._elseThenStatements.get(i);
            double[] doubleValues = transformFunction.transformToDoubleValuesSV(projectionBlock);
            if (this._numSelections == 1) {
                System.arraycopy(doubleValues, 0, this._doubleResults, 0, numDocs);
                continue;
            }
            for (int j = 0; j < numDocs; ++j) {
                if (selected[j] != i) continue;
                this._doubleResults[j] = doubleValues[j];
            }
        }
        return this._doubleResults;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.STRING) {
            return super.transformToStringValuesSV(projectionBlock);
        }
        int[] selected = this.getSelectedArray(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        if (this._stringResults == null || this._selectedResults.length < numDocs) {
            this._stringResults = new String[numDocs];
        }
        int numElseThenStatements = this._elseThenStatements.size();
        for (int i = 0; i < numElseThenStatements; ++i) {
            if (!this._selections[i]) continue;
            TransformFunction transformFunction = this._elseThenStatements.get(i);
            String[] stringValues = transformFunction.transformToStringValuesSV(projectionBlock);
            if (this._numSelections == 1) {
                System.arraycopy(stringValues, 0, this._stringResults, 0, numDocs);
                continue;
            }
            for (int j = 0; j < numDocs; ++j) {
                if (selected[j] != i) continue;
                this._stringResults[j] = stringValues[j];
            }
        }
        return this._stringResults;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.BYTES) {
            return super.transformToBytesValuesSV(projectionBlock);
        }
        int[] selected = this.getSelectedArray(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        if (this._bytesResults == null || this._bytesResults.length < numDocs) {
            this._bytesResults = new byte[numDocs][];
        }
        int numElseThenStatements = this._elseThenStatements.size();
        for (int i = 0; i < numElseThenStatements; ++i) {
            if (!this._selections[i]) continue;
            TransformFunction transformFunction = this._elseThenStatements.get(i);
            byte[][] bytesValues = transformFunction.transformToBytesValuesSV(projectionBlock);
            if (this._numSelections == 1) {
                System.arraycopy(bytesValues, 0, this._byteValuesSV, 0, numDocs);
                continue;
            }
            for (int j = 0; j < numDocs; ++j) {
                if (selected[j] != i) continue;
                this._bytesResults[j] = bytesValues[j];
            }
        }
        return this._bytesResults;
    }
}

