/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ArrayCopyUtils;

public class CastTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "cast";
    private TransformFunction _transformFunction;
    private TransformResultMetadata _resultMetadata;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        if (arguments.size() != 2) {
            throw new IllegalArgumentException("Exactly 2 arguments are required for CAST transform function");
        }
        this._transformFunction = arguments.get(0);
        TransformFunction castFormatTransformFunction = arguments.get(1);
        if (castFormatTransformFunction instanceof LiteralTransformFunction) {
            String targetType;
            switch (targetType = ((LiteralTransformFunction)castFormatTransformFunction).getLiteral().toUpperCase()) {
                case "INT": 
                case "INTEGER": {
                    this._resultMetadata = INT_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "LONG": {
                    this._resultMetadata = LONG_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "FLOAT": {
                    this._resultMetadata = FLOAT_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "DOUBLE": {
                    this._resultMetadata = DOUBLE_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "BOOLEAN": {
                    this._resultMetadata = BOOLEAN_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "TIMESTAMP": {
                    this._resultMetadata = TIMESTAMP_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "STRING": 
                case "VARCHAR": {
                    this._resultMetadata = STRING_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "JSON": {
                    this._resultMetadata = JSON_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unable to cast expression to type - " + targetType);
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid cast to type - " + castFormatTransformFunction.getName());
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        FieldSpec.DataType resultStoredType = this._resultMetadata.getDataType().getStoredType();
        if (resultStoredType == FieldSpec.DataType.INT) {
            return this._transformFunction.transformToIntValuesSV(projectionBlock);
        }
        if (this._intValuesSV == null) {
            this._intValuesSV = new int[10000];
        }
        int numDocs = projectionBlock.getNumDocs();
        switch (resultStoredType) {
            case LONG: {
                long[] longValues = this._transformFunction.transformToLongValuesSV(projectionBlock);
                ArrayCopyUtils.copy((long[])longValues, (int[])this._intValuesSV, (int)numDocs);
                break;
            }
            case FLOAT: {
                float[] floatValues = this._transformFunction.transformToFloatValuesSV(projectionBlock);
                ArrayCopyUtils.copy((float[])floatValues, (int[])this._intValuesSV, (int)numDocs);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = this._transformFunction.transformToDoubleValuesSV(projectionBlock);
                ArrayCopyUtils.copy((double[])doubleValues, (int[])this._intValuesSV, (int)numDocs);
                break;
            }
            case STRING: {
                String[] stringValues = this._transformFunction.transformToStringValuesSV(projectionBlock);
                ArrayCopyUtils.copy((String[])stringValues, (int[])this._intValuesSV, (int)numDocs);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this._intValuesSV;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        FieldSpec.DataType resultStoredType = this._resultMetadata.getDataType().getStoredType();
        if (resultStoredType == FieldSpec.DataType.LONG) {
            return this._transformFunction.transformToLongValuesSV(projectionBlock);
        }
        if (this._longValuesSV == null) {
            this._longValuesSV = new long[10000];
        }
        int numDocs = projectionBlock.getNumDocs();
        switch (resultStoredType) {
            case INT: {
                int[] intValues = this._transformFunction.transformToIntValuesSV(projectionBlock);
                ArrayCopyUtils.copy((int[])intValues, (long[])this._longValuesSV, (int)numDocs);
                break;
            }
            case FLOAT: {
                float[] floatValues = this._transformFunction.transformToFloatValuesSV(projectionBlock);
                ArrayCopyUtils.copy((float[])floatValues, (long[])this._longValuesSV, (int)numDocs);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = this._transformFunction.transformToDoubleValuesSV(projectionBlock);
                ArrayCopyUtils.copy((double[])doubleValues, (long[])this._longValuesSV, (int)numDocs);
                break;
            }
            case STRING: {
                String[] stringValues = this._transformFunction.transformToStringValuesSV(projectionBlock);
                ArrayCopyUtils.copy((String[])stringValues, (long[])this._longValuesSV, (int)numDocs);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this._longValuesSV;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        FieldSpec.DataType resultStoredType = this._resultMetadata.getDataType().getStoredType();
        if (resultStoredType == FieldSpec.DataType.FLOAT) {
            return this._transformFunction.transformToFloatValuesSV(projectionBlock);
        }
        if (this._floatValuesSV == null) {
            this._floatValuesSV = new float[10000];
        }
        int numDocs = projectionBlock.getNumDocs();
        switch (resultStoredType) {
            case INT: {
                int[] intValues = this._transformFunction.transformToIntValuesSV(projectionBlock);
                ArrayCopyUtils.copy((int[])intValues, (float[])this._floatValuesSV, (int)numDocs);
                break;
            }
            case LONG: {
                long[] longValues = this._transformFunction.transformToLongValuesSV(projectionBlock);
                ArrayCopyUtils.copy((long[])longValues, (float[])this._floatValuesSV, (int)numDocs);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = this._transformFunction.transformToDoubleValuesSV(projectionBlock);
                ArrayCopyUtils.copy((double[])doubleValues, (float[])this._floatValuesSV, (int)numDocs);
                break;
            }
            case STRING: {
                String[] stringValues = this._transformFunction.transformToStringValuesSV(projectionBlock);
                ArrayCopyUtils.copy((String[])stringValues, (float[])this._floatValuesSV, (int)numDocs);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this._floatValuesSV;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        FieldSpec.DataType resultStoredType = this._resultMetadata.getDataType().getStoredType();
        if (resultStoredType == FieldSpec.DataType.DOUBLE) {
            return this._transformFunction.transformToDoubleValuesSV(projectionBlock);
        }
        if (this._doubleValuesSV == null) {
            this._doubleValuesSV = new double[10000];
        }
        int numDocs = projectionBlock.getNumDocs();
        switch (resultStoredType) {
            case INT: {
                int[] intValues = this._transformFunction.transformToIntValuesSV(projectionBlock);
                ArrayCopyUtils.copy((int[])intValues, (double[])this._doubleValuesSV, (int)numDocs);
                break;
            }
            case LONG: {
                long[] longValues = this._transformFunction.transformToLongValuesSV(projectionBlock);
                ArrayCopyUtils.copy((long[])longValues, (double[])this._doubleValuesSV, (int)numDocs);
                break;
            }
            case FLOAT: {
                float[] floatValues = this._transformFunction.transformToFloatValuesSV(projectionBlock);
                ArrayCopyUtils.copy((float[])floatValues, (double[])this._doubleValuesSV, (int)numDocs);
                break;
            }
            case STRING: {
                String[] stringValues = this._transformFunction.transformToStringValuesSV(projectionBlock);
                ArrayCopyUtils.copy((String[])stringValues, (double[])this._doubleValuesSV, (int)numDocs);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this._doubleValuesSV;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        FieldSpec.DataType resultDataType = this._resultMetadata.getDataType();
        FieldSpec.DataType resultStoredType = resultDataType.getStoredType();
        int numDocs = projectionBlock.getNumDocs();
        if (resultStoredType == FieldSpec.DataType.STRING) {
            FieldSpec.DataType inputDataType = this._transformFunction.getResultMetadata().getDataType();
            if (inputDataType.getStoredType() != inputDataType) {
                if (this._stringValuesSV == null) {
                    this._stringValuesSV = new String[10000];
                }
                if (inputDataType == FieldSpec.DataType.BOOLEAN) {
                    int[] intValues = this._transformFunction.transformToIntValuesSV(projectionBlock);
                    for (int i = 0; i < numDocs; ++i) {
                        this._stringValuesSV[i] = Boolean.toString(intValues[i] == 1);
                    }
                } else {
                    assert (inputDataType == FieldSpec.DataType.TIMESTAMP);
                    long[] longValues = this._transformFunction.transformToLongValuesSV(projectionBlock);
                    for (int i = 0; i < numDocs; ++i) {
                        this._stringValuesSV[i] = new Timestamp(longValues[i]).toString();
                    }
                }
                return this._stringValuesSV;
            }
            return this._transformFunction.transformToStringValuesSV(projectionBlock);
        }
        if (this._stringValuesSV == null) {
            this._stringValuesSV = new String[10000];
        }
        switch (resultDataType) {
            case INT: {
                int[] intValues = this._transformFunction.transformToIntValuesSV(projectionBlock);
                ArrayCopyUtils.copy((int[])intValues, (String[])this._stringValuesSV, (int)numDocs);
                break;
            }
            case LONG: {
                long[] longValues = this._transformFunction.transformToLongValuesSV(projectionBlock);
                ArrayCopyUtils.copy((long[])longValues, (String[])this._stringValuesSV, (int)numDocs);
                break;
            }
            case FLOAT: {
                float[] floatValues = this._transformFunction.transformToFloatValuesSV(projectionBlock);
                ArrayCopyUtils.copy((float[])floatValues, (String[])this._stringValuesSV, (int)numDocs);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = this._transformFunction.transformToDoubleValuesSV(projectionBlock);
                ArrayCopyUtils.copy((double[])doubleValues, (String[])this._stringValuesSV, (int)numDocs);
                break;
            }
            case BOOLEAN: {
                int[] intValues = this._transformFunction.transformToIntValuesSV(projectionBlock);
                for (int i = 0; i < numDocs; ++i) {
                    this._stringValuesSV[i] = Boolean.toString(intValues[i] == 1);
                }
                break;
            }
            case TIMESTAMP: {
                long[] longValues = this._transformFunction.transformToLongValuesSV(projectionBlock);
                for (int i = 0; i < numDocs; ++i) {
                    this._stringValuesSV[i] = new Timestamp(longValues[i]).toString();
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this._stringValuesSV;
    }
}

