/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.EnumUtils;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.local.function.GroovyFunctionEvaluator;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.JsonUtils;

public class GroovyTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "groovy";
    private static final String RETURN_TYPE_KEY = "returnType";
    private static final String IS_SINGLE_VALUE_KEY = "isSingleValue";
    private static final String ARGUMENT_PREFIX = "arg";
    private static final String GROOVY_TEMPLATE_WITH_ARGS = "Groovy({%s}, %s)";
    private static final String GROOVY_TEMPLATE_WITHOUT_ARGS = "Groovy({%s})";
    private static final String GROOVY_ARG_DELIMITER = ",";
    private int[] _intResultSV;
    private long[] _longResultSV;
    private double[] _doubleResultSV;
    private float[] _floatResultSV;
    private String[] _stringResultSV;
    private int[][] _intResultMV;
    private long[][] _longResultMV;
    private double[][] _doubleResultMV;
    private float[][] _floatResultMV;
    private String[][] _stringResultMV;
    private TransformResultMetadata _resultMetadata;
    private GroovyFunctionEvaluator _groovyFunctionEvaluator;
    private int _numGroovyArgs;
    private TransformFunction[] _groovyArguments;
    private boolean[] _isSourceSingleValue;
    private FieldSpec.DataType[] _sourceStoredTypes;
    private BiFunction<TransformFunction, ProjectionBlock, Object>[] _transformToValuesFunctions;
    private BiFunction<Object, Integer, Object>[] _fetchElementFunctions;
    private Object[] _sourceArrays;
    private Object[] _bindingValues;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        int numArgs = arguments.size();
        if (numArgs < 2) {
            throw new IllegalArgumentException("GROOVY transform function requires at least 2 arguments");
        }
        TransformFunction returnValueMetadata = arguments.get(0);
        Preconditions.checkState((boolean)(returnValueMetadata instanceof LiteralTransformFunction), (Object)"First argument of GROOVY transform function must be a literal, representing a json string");
        String returnValueMetadataStr = ((LiteralTransformFunction)returnValueMetadata).getLiteral();
        try {
            JsonNode returnValueMetadataJson = JsonUtils.stringToJsonNode((String)returnValueMetadataStr);
            Preconditions.checkState((boolean)returnValueMetadataJson.hasNonNull(RETURN_TYPE_KEY), (Object)"The json string in the first argument of GROOVY transform function must have non-null 'returnType'");
            Preconditions.checkState((boolean)returnValueMetadataJson.hasNonNull(IS_SINGLE_VALUE_KEY), (Object)"The json string in the first argument of GROOVY transform function must have non-null 'isSingleValue'");
            String returnTypeStr = returnValueMetadataJson.get(RETURN_TYPE_KEY).asText();
            Preconditions.checkState((boolean)EnumUtils.isValidEnum(FieldSpec.DataType.class, (String)returnTypeStr), (Object)"The 'returnType' in the json string which is the first argument of GROOVY transform function must be a valid FieldSpec.DataType enum value");
            this._resultMetadata = new TransformResultMetadata(FieldSpec.DataType.valueOf((String)returnTypeStr), returnValueMetadataJson.get(IS_SINGLE_VALUE_KEY).asBoolean(true), false);
        }
        catch (IOException e) {
            throw new IllegalStateException("Caught exception when converting json string '" + returnValueMetadataStr + "' to JsonNode", e);
        }
        TransformFunction groovyTransformFunction = arguments.get(1);
        Preconditions.checkState((boolean)(groovyTransformFunction instanceof LiteralTransformFunction), (Object)"Second argument of GROOVY transform function must be a literal string, representing the groovy expression");
        this._numGroovyArgs = numArgs - 2;
        if (this._numGroovyArgs > 0) {
            this._groovyArguments = new TransformFunction[this._numGroovyArgs];
            this._isSourceSingleValue = new boolean[this._numGroovyArgs];
            this._sourceStoredTypes = new FieldSpec.DataType[this._numGroovyArgs];
            int idx = 0;
            for (int i2 = 2; i2 < numArgs; ++i2) {
                TransformFunction argument = arguments.get(i2);
                Preconditions.checkState((!(argument instanceof LiteralTransformFunction) ? 1 : 0) != 0, (Object)"Third argument onwards, all arguments must be a column or other transform function");
                this._groovyArguments[idx] = argument;
                TransformResultMetadata resultMetadata = argument.getResultMetadata();
                this._isSourceSingleValue[idx] = resultMetadata.isSingleValue();
                this._sourceStoredTypes[idx++] = resultMetadata.getDataType().getStoredType();
            }
            String argumentsStr = IntStream.range(0, this._numGroovyArgs).mapToObj(i -> ARGUMENT_PREFIX + i).collect(Collectors.joining(GROOVY_ARG_DELIMITER));
            this._groovyFunctionEvaluator = new GroovyFunctionEvaluator(String.format(GROOVY_TEMPLATE_WITH_ARGS, ((LiteralTransformFunction)groovyTransformFunction).getLiteral(), argumentsStr));
            this._transformToValuesFunctions = new BiFunction[this._numGroovyArgs];
            this._fetchElementFunctions = new BiFunction[this._numGroovyArgs];
            this.initFunctions();
        } else {
            this._groovyFunctionEvaluator = new GroovyFunctionEvaluator(String.format(GROOVY_TEMPLATE_WITHOUT_ARGS, ((LiteralTransformFunction)groovyTransformFunction).getLiteral()));
        }
        this._sourceArrays = new Object[this._numGroovyArgs];
        this._bindingValues = new Object[this._numGroovyArgs];
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    private void initFunctions() {
        for (int i = 0; i < this._numGroovyArgs; ++i) {
            BiFunction<Object, Integer, Object> getElementFunction;
            BiFunction<TransformFunction, ProjectionBlock, Object> transformToValuesFunction;
            block16: {
                block15: {
                    if (!this._isSourceSingleValue[i]) break block15;
                    switch (this._sourceStoredTypes[i]) {
                        case INT: {
                            transformToValuesFunction = TransformFunction::transformToIntValuesSV;
                            getElementFunction = (sourceArray, position) -> ((int[])sourceArray)[position];
                            break block16;
                        }
                        case LONG: {
                            transformToValuesFunction = TransformFunction::transformToLongValuesSV;
                            getElementFunction = (sourceArray, position) -> ((long[])sourceArray)[position];
                            break block16;
                        }
                        case FLOAT: {
                            transformToValuesFunction = TransformFunction::transformToFloatValuesSV;
                            getElementFunction = (sourceArray, position) -> Float.valueOf(((float[])sourceArray)[position]);
                            break block16;
                        }
                        case DOUBLE: {
                            transformToValuesFunction = TransformFunction::transformToDoubleValuesSV;
                            getElementFunction = (sourceArray, position) -> ((double[])sourceArray)[position];
                            break block16;
                        }
                        case STRING: {
                            transformToValuesFunction = TransformFunction::transformToStringValuesSV;
                            getElementFunction = (sourceArray, position) -> ((String[])sourceArray)[position];
                            break block16;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported data type '" + this._sourceStoredTypes[i] + "' for GROOVY transform function");
                        }
                    }
                }
                switch (this._sourceStoredTypes[i]) {
                    case INT: {
                        transformToValuesFunction = TransformFunction::transformToIntValuesMV;
                        getElementFunction = (sourceArray, position) -> ((int[][])sourceArray)[position];
                        break;
                    }
                    case LONG: {
                        transformToValuesFunction = TransformFunction::transformToLongValuesMV;
                        getElementFunction = (sourceArray, position) -> ((long[][])sourceArray)[position];
                        break;
                    }
                    case FLOAT: {
                        transformToValuesFunction = TransformFunction::transformToFloatValuesMV;
                        getElementFunction = (sourceArray, position) -> ((float[][])sourceArray)[position];
                        break;
                    }
                    case DOUBLE: {
                        transformToValuesFunction = TransformFunction::transformToDoubleValuesMV;
                        getElementFunction = (sourceArray, position) -> ((double[][])sourceArray)[position];
                        break;
                    }
                    case STRING: {
                        transformToValuesFunction = TransformFunction::transformToStringValuesMV;
                        getElementFunction = (sourceArray, position) -> ((String[][])sourceArray)[position];
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported data type '" + this._sourceStoredTypes[i] + "' for GROOVY transform function");
                    }
                }
            }
            this._transformToValuesFunctions[i] = transformToValuesFunction;
            this._fetchElementFunctions[i] = getElementFunction;
        }
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        if (this._intResultSV == null) {
            this._intResultSV = new int[10000];
        }
        for (int i = 0; i < this._numGroovyArgs; ++i) {
            this._sourceArrays[i] = this._transformToValuesFunctions[i].apply(this._groovyArguments[i], projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numGroovyArgs; ++j) {
                this._bindingValues[j] = this._fetchElementFunctions[j].apply(this._sourceArrays[j], i);
            }
            this._intResultSV[i] = (Integer)this._groovyFunctionEvaluator.evaluate(this._bindingValues);
        }
        return this._intResultSV;
    }

    @Override
    public int[][] transformToIntValuesMV(ProjectionBlock projectionBlock) {
        if (this._intResultMV == null) {
            this._intResultMV = new int[10000][];
        }
        for (int i = 0; i < this._numGroovyArgs; ++i) {
            this._sourceArrays[i] = this._transformToValuesFunctions[i].apply(this._groovyArguments[i], projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numGroovyArgs; ++j) {
                this._bindingValues[j] = this._fetchElementFunctions[j].apply(this._sourceArrays[j], i);
            }
            Object result = this._groovyFunctionEvaluator.evaluate(this._bindingValues);
            if (result instanceof List) {
                this._intResultMV[i] = new IntArrayList((Collection)((List)result)).toIntArray();
                continue;
            }
            if (result instanceof int[]) {
                this._intResultMV[i] = (int[])result;
                continue;
            }
            throw new IllegalStateException("Unexpected result type '" + result.getClass() + "' for GROOVY function");
        }
        return this._intResultMV;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._doubleResultSV == null) {
            this._doubleResultSV = new double[10000];
        }
        for (int i = 0; i < this._numGroovyArgs; ++i) {
            this._sourceArrays[i] = this._transformToValuesFunctions[i].apply(this._groovyArguments[i], projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numGroovyArgs; ++j) {
                this._bindingValues[j] = this._fetchElementFunctions[j].apply(this._sourceArrays[j], i);
            }
            this._doubleResultSV[i] = (Double)this._groovyFunctionEvaluator.evaluate(this._bindingValues);
        }
        return this._doubleResultSV;
    }

    @Override
    public double[][] transformToDoubleValuesMV(ProjectionBlock projectionBlock) {
        if (this._doubleResultMV == null) {
            this._doubleResultMV = new double[10000][];
        }
        for (int i = 0; i < this._numGroovyArgs; ++i) {
            this._sourceArrays[i] = this._transformToValuesFunctions[i].apply(this._groovyArguments[i], projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numGroovyArgs; ++j) {
                this._bindingValues[j] = this._fetchElementFunctions[j].apply(this._sourceArrays[j], i);
            }
            Object result = this._groovyFunctionEvaluator.evaluate(this._bindingValues);
            if (result instanceof List) {
                this._doubleResultMV[i] = new DoubleArrayList((Collection)((List)result)).toDoubleArray();
                continue;
            }
            if (result instanceof double[]) {
                this._doubleResultMV[i] = (double[])result;
                continue;
            }
            throw new IllegalStateException("Unexpected result type '" + result.getClass() + "' for GROOVY function");
        }
        return this._doubleResultMV;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        if (this._longResultSV == null) {
            this._longResultSV = new long[10000];
        }
        for (int i = 0; i < this._numGroovyArgs; ++i) {
            this._sourceArrays[i] = this._transformToValuesFunctions[i].apply(this._groovyArguments[i], projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numGroovyArgs; ++j) {
                this._bindingValues[j] = this._fetchElementFunctions[j].apply(this._sourceArrays[j], i);
            }
            this._longResultSV[i] = (Long)this._groovyFunctionEvaluator.evaluate(this._bindingValues);
        }
        return this._longResultSV;
    }

    @Override
    public long[][] transformToLongValuesMV(ProjectionBlock projectionBlock) {
        if (this._longResultMV == null) {
            this._longResultMV = new long[10000][];
        }
        for (int i = 0; i < this._numGroovyArgs; ++i) {
            this._sourceArrays[i] = this._transformToValuesFunctions[i].apply(this._groovyArguments[i], projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numGroovyArgs; ++j) {
                this._bindingValues[j] = this._fetchElementFunctions[j].apply(this._sourceArrays[j], i);
            }
            Object result = this._groovyFunctionEvaluator.evaluate(this._bindingValues);
            if (result instanceof List) {
                this._longResultMV[i] = new LongArrayList((Collection)((List)result)).toLongArray();
                continue;
            }
            if (result instanceof long[]) {
                this._longResultMV[i] = (long[])result;
                continue;
            }
            throw new IllegalStateException("Unexpected result type '" + result.getClass() + "' for GROOVY function");
        }
        return this._longResultMV;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        if (this._floatResultSV == null) {
            this._floatResultSV = new float[10000];
        }
        for (int i = 0; i < this._numGroovyArgs; ++i) {
            this._sourceArrays[i] = this._transformToValuesFunctions[i].apply(this._groovyArguments[i], projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numGroovyArgs; ++j) {
                this._bindingValues[j] = this._fetchElementFunctions[j].apply(this._sourceArrays[j], i);
            }
            this._floatResultSV[i] = ((Float)this._groovyFunctionEvaluator.evaluate(this._bindingValues)).floatValue();
        }
        return this._floatResultSV;
    }

    @Override
    public float[][] transformToFloatValuesMV(ProjectionBlock projectionBlock) {
        if (this._floatResultMV == null) {
            this._floatResultMV = new float[10000][];
        }
        for (int i = 0; i < this._numGroovyArgs; ++i) {
            this._sourceArrays[i] = this._transformToValuesFunctions[i].apply(this._groovyArguments[i], projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numGroovyArgs; ++j) {
                this._bindingValues[j] = this._fetchElementFunctions[j].apply(this._sourceArrays[j], i);
            }
            Object result = this._groovyFunctionEvaluator.evaluate(this._bindingValues);
            if (result instanceof List) {
                this._floatResultMV[i] = new FloatArrayList((Collection)((List)result)).toFloatArray();
                continue;
            }
            if (result instanceof float[]) {
                this._floatResultMV[i] = (float[])result;
                continue;
            }
            throw new IllegalStateException("Unexpected result type '" + result.getClass() + "' for GROOVY function");
        }
        return this._floatResultMV;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        if (this._stringResultSV == null) {
            this._stringResultSV = new String[10000];
        }
        for (int i = 0; i < this._numGroovyArgs; ++i) {
            this._sourceArrays[i] = this._transformToValuesFunctions[i].apply(this._groovyArguments[i], projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numGroovyArgs; ++j) {
                this._bindingValues[j] = this._fetchElementFunctions[j].apply(this._sourceArrays[j], i);
            }
            this._stringResultSV[i] = (String)this._groovyFunctionEvaluator.evaluate(this._bindingValues);
        }
        return this._stringResultSV;
    }

    @Override
    public String[][] transformToStringValuesMV(ProjectionBlock projectionBlock) {
        if (this._stringResultMV == null) {
            this._stringResultMV = new String[10000][];
        }
        for (int i = 0; i < this._numGroovyArgs; ++i) {
            this._sourceArrays[i] = this._transformToValuesFunctions[i].apply(this._groovyArguments[i], projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numGroovyArgs; ++j) {
                this._bindingValues[j] = this._fetchElementFunctions[j].apply(this._sourceArrays[j], i);
            }
            Object result = this._groovyFunctionEvaluator.evaluate(this._bindingValues);
            if (result instanceof List) {
                this._stringResultMV[i] = ((List)result).toArray(new String[0]);
                continue;
            }
            if (result instanceof String[]) {
                this._stringResultMV[i] = (String[])result;
                continue;
            }
            throw new IllegalStateException("Unexpected result type '" + result.getClass() + "' for GROOVY function");
        }
        return this._stringResultMV;
    }
}

