/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;

public class InTransformFunction
extends BaseTransformFunction {
    private TransformFunction _mainFunction;
    private TransformFunction[] _valueFunctions;
    private Set _valueSet;

    @Override
    public String getName() {
        return TransformFunctionType.IN.getName();
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        TransformFunction valueFunction;
        int i;
        int numArguments = arguments.size();
        Preconditions.checkArgument((numArguments >= 2 ? 1 : 0) != 0, (Object)"At least 2 arguments are required for IN transform function: expression, values");
        this._mainFunction = arguments.get(0);
        boolean allLiteralValues = true;
        ObjectOpenHashSet stringValues = new ObjectOpenHashSet(numArguments - 1);
        for (i = 1; i < numArguments; ++i) {
            valueFunction = arguments.get(i);
            if (!(valueFunction instanceof LiteralTransformFunction)) {
                allLiteralValues = false;
                break;
            }
            stringValues.add((Object)((LiteralTransformFunction)valueFunction).getLiteral());
        }
        if (allLiteralValues) {
            int numValues = stringValues.size();
            FieldSpec.DataType storedType = this._mainFunction.getResultMetadata().getDataType().getStoredType();
            switch (storedType) {
                case INT: {
                    IntOpenHashSet intValues = new IntOpenHashSet(numValues);
                    for (String stringValue : stringValues) {
                        intValues.add(Integer.parseInt(stringValue));
                    }
                    this._valueSet = intValues;
                    break;
                }
                case LONG: {
                    LongOpenHashSet longValues = new LongOpenHashSet(numValues);
                    for (String stringValue : stringValues) {
                        longValues.add(Long.parseLong(stringValue));
                    }
                    this._valueSet = longValues;
                    break;
                }
                case FLOAT: {
                    FloatOpenHashSet floatValues = new FloatOpenHashSet(numValues);
                    for (String stringValue : stringValues) {
                        floatValues.add(Float.parseFloat(stringValue));
                    }
                    this._valueSet = floatValues;
                    break;
                }
                case DOUBLE: {
                    DoubleOpenHashSet doubleValues = new DoubleOpenHashSet(numValues);
                    for (String stringValue : stringValues) {
                        doubleValues.add(Double.parseDouble(stringValue));
                    }
                    this._valueSet = doubleValues;
                    break;
                }
                case STRING: {
                    this._valueSet = stringValues;
                    break;
                }
                case BYTES: {
                    ObjectOpenHashSet bytesValues = new ObjectOpenHashSet(numValues);
                    for (String stringValue : stringValues) {
                        bytesValues.add((Object)BytesUtils.toByteArray((String)stringValue));
                    }
                    this._valueSet = bytesValues;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } else {
            Preconditions.checkArgument((boolean)this._mainFunction.getResultMetadata().isSingleValue(), (Object)"The first argument for IN transform function must be single-valued when there are non-literal values");
            this._valueFunctions = new TransformFunction[numArguments - 1];
            for (i = 1; i < numArguments; ++i) {
                valueFunction = arguments.get(i);
                Preconditions.checkArgument((boolean)valueFunction.getResultMetadata().isSingleValue(), (Object)"The values for IN transform function must be single-valued");
                this._valueFunctions[i - 1] = valueFunction;
            }
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BOOLEAN_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        block61: {
            FieldSpec.DataType storedType;
            int length;
            block59: {
                block60: {
                    if (this._intValuesSV == null) {
                        this._intValuesSV = new int[10000];
                    } else {
                        Arrays.fill(this._intValuesSV, 0);
                    }
                    length = projectionBlock.getNumDocs();
                    TransformResultMetadata mainFunctionMetadata = this._mainFunction.getResultMetadata();
                    storedType = mainFunctionMetadata.getDataType().getStoredType();
                    if (this._valueSet == null) break block59;
                    if (!this._mainFunction.getResultMetadata().isSingleValue()) break block60;
                    switch (storedType) {
                        case INT: {
                            IntOpenHashSet inIntValues = (IntOpenHashSet)this._valueSet;
                            int[] intValues = this._mainFunction.transformToIntValuesSV(projectionBlock);
                            for (int i = 0; i < length; ++i) {
                                if (!inIntValues.contains(intValues[i])) continue;
                                this._intValuesSV[i] = 1;
                            }
                            break block61;
                        }
                        case LONG: {
                            LongOpenHashSet inLongValues = (LongOpenHashSet)this._valueSet;
                            long[] longValues = this._mainFunction.transformToLongValuesSV(projectionBlock);
                            for (int i = 0; i < length; ++i) {
                                if (!inLongValues.contains(longValues[i])) continue;
                                this._intValuesSV[i] = 1;
                            }
                            break block61;
                        }
                        case FLOAT: {
                            FloatOpenHashSet inFloatValues = (FloatOpenHashSet)this._valueSet;
                            float[] floatValues = this._mainFunction.transformToFloatValuesSV(projectionBlock);
                            for (int i = 0; i < length; ++i) {
                                if (!inFloatValues.contains(floatValues[i])) continue;
                                this._intValuesSV[i] = 1;
                            }
                            break block61;
                        }
                        case DOUBLE: {
                            DoubleOpenHashSet inDoubleValues = (DoubleOpenHashSet)this._valueSet;
                            double[] doubleValues = this._mainFunction.transformToDoubleValuesSV(projectionBlock);
                            for (int i = 0; i < length; ++i) {
                                if (!inDoubleValues.contains(doubleValues[i])) continue;
                                this._intValuesSV[i] = 1;
                            }
                            break block61;
                        }
                        case STRING: {
                            ObjectOpenHashSet inStringValues = (ObjectOpenHashSet)this._valueSet;
                            String[] stringValues = this._mainFunction.transformToStringValuesSV(projectionBlock);
                            for (int i = 0; i < length; ++i) {
                                if (!inStringValues.contains((Object)stringValues[i])) continue;
                                this._intValuesSV[i] = 1;
                            }
                            break block61;
                        }
                        case BYTES: {
                            ObjectOpenHashSet inBytesValues = (ObjectOpenHashSet)this._valueSet;
                            byte[][] bytesValues = this._mainFunction.transformToBytesValuesSV(projectionBlock);
                            for (int i = 0; i < length; ++i) {
                                if (!inBytesValues.contains((Object)new ByteArray(bytesValues[i]))) continue;
                                this._intValuesSV[i] = 1;
                            }
                            break block61;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                switch (storedType) {
                    case INT: {
                        IntOpenHashSet inIntValues = (IntOpenHashSet)this._valueSet;
                        int[][] intValues = this._mainFunction.transformToIntValuesMV(projectionBlock);
                        block29: for (int i = 0; i < length; ++i) {
                            for (int intValue : intValues[i]) {
                                if (!inIntValues.contains(intValue)) continue;
                                this._intValuesSV[i] = 1;
                                continue block29;
                            }
                        }
                        break block61;
                    }
                    case LONG: {
                        LongOpenHashSet inLongValues = (LongOpenHashSet)this._valueSet;
                        long[][] longValues = this._mainFunction.transformToLongValuesMV(projectionBlock);
                        block31: for (int i = 0; i < length; ++i) {
                            for (long longValue : longValues[i]) {
                                if (!inLongValues.contains(longValue)) continue;
                                this._intValuesSV[i] = 1;
                                continue block31;
                            }
                        }
                        break block61;
                    }
                    case FLOAT: {
                        FloatOpenHashSet inFloatValues = (FloatOpenHashSet)this._valueSet;
                        float[][] floatValues = this._mainFunction.transformToFloatValuesMV(projectionBlock);
                        block33: for (int i = 0; i < length; ++i) {
                            for (float floatValue : floatValues[i]) {
                                if (!inFloatValues.contains(floatValue)) continue;
                                this._intValuesSV[i] = 1;
                                continue block33;
                            }
                        }
                        break block61;
                    }
                    case DOUBLE: {
                        DoubleOpenHashSet inDoubleValues = (DoubleOpenHashSet)this._valueSet;
                        double[][] doubleValues = this._mainFunction.transformToDoubleValuesMV(projectionBlock);
                        block35: for (int i = 0; i < length; ++i) {
                            for (double doubleValue : doubleValues[i]) {
                                if (!inDoubleValues.contains(doubleValue)) continue;
                                this._intValuesSV[i] = 1;
                                continue block35;
                            }
                        }
                        break block61;
                    }
                    case STRING: {
                        ObjectOpenHashSet inStringValues = (ObjectOpenHashSet)this._valueSet;
                        String[][] stringValues = this._mainFunction.transformToStringValuesMV(projectionBlock);
                        block37: for (int i = 0; i < length; ++i) {
                            for (String stringValue : stringValues[i]) {
                                if (!inStringValues.contains((Object)stringValue)) continue;
                                this._intValuesSV[i] = 1;
                                continue block37;
                            }
                        }
                        break block61;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            int numValues = this._valueFunctions.length;
            switch (storedType) {
                case INT: {
                    int i;
                    int[] intValues = this._mainFunction.transformToIntValuesSV(projectionBlock);
                    int[][] inIntValues = new int[numValues][];
                    for (i = 0; i < numValues; ++i) {
                        inIntValues[i] = this._valueFunctions[i].transformToIntValuesSV(projectionBlock);
                    }
                    block40: for (i = 0; i < length; ++i) {
                        for (int[] inIntValue : inIntValues) {
                            if (intValues[i] != inIntValue[i]) continue;
                            this._intValuesSV[i] = 1;
                            continue block40;
                        }
                    }
                    break;
                }
                case LONG: {
                    int i;
                    long[] longValues = this._mainFunction.transformToLongValuesSV(projectionBlock);
                    long[][] inLongValues = new long[numValues][];
                    for (i = 0; i < numValues; ++i) {
                        inLongValues[i] = this._valueFunctions[i].transformToLongValuesSV(projectionBlock);
                    }
                    block43: for (i = 0; i < length; ++i) {
                        for (long[] inLongValue : inLongValues) {
                            if (longValues[i] != inLongValue[i]) continue;
                            this._intValuesSV[i] = 1;
                            continue block43;
                        }
                    }
                    break;
                }
                case FLOAT: {
                    int i;
                    float[] floatValues = this._mainFunction.transformToFloatValuesSV(projectionBlock);
                    float[][] inFloatValues = new float[numValues][];
                    for (i = 0; i < numValues; ++i) {
                        inFloatValues[i] = this._valueFunctions[i].transformToFloatValuesSV(projectionBlock);
                    }
                    block46: for (i = 0; i < length; ++i) {
                        int intBits = Float.floatToIntBits(floatValues[i]);
                        for (float[] inFloatValue : inFloatValues) {
                            if (intBits != Float.floatToIntBits(inFloatValue[i])) continue;
                            this._intValuesSV[i] = 1;
                            continue block46;
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    int i;
                    double[] doubleValues = this._mainFunction.transformToDoubleValuesSV(projectionBlock);
                    double[][] inDoubleValues = new double[numValues][];
                    for (i = 0; i < numValues; ++i) {
                        inDoubleValues[i] = this._valueFunctions[i].transformToDoubleValuesSV(projectionBlock);
                    }
                    block49: for (i = 0; i < length; ++i) {
                        long longBits = Double.doubleToLongBits(doubleValues[i]);
                        for (double[] inDoubleValue : inDoubleValues) {
                            if (longBits != Double.doubleToLongBits(inDoubleValue[i])) continue;
                            this._intValuesSV[i] = 1;
                            continue block49;
                        }
                    }
                    break;
                }
                case STRING: {
                    int i;
                    String[] stringValues = this._mainFunction.transformToStringValuesSV(projectionBlock);
                    String[][] inStringValues = new String[numValues][];
                    for (i = 0; i < numValues; ++i) {
                        inStringValues[i] = this._valueFunctions[i].transformToStringValuesSV(projectionBlock);
                    }
                    block52: for (i = 0; i < length; ++i) {
                        for (String[] inStringValue : inStringValues) {
                            if (!stringValues[i].equals(inStringValue[i])) continue;
                            this._intValuesSV[i] = 1;
                            continue block52;
                        }
                    }
                    break;
                }
                case BYTES: {
                    int i;
                    byte[][] bytesValues = this._mainFunction.transformToBytesValuesSV(projectionBlock);
                    byte[][][] inBytesValues = new byte[numValues][][];
                    for (i = 0; i < numValues; ++i) {
                        inBytesValues[i] = this._valueFunctions[i].transformToBytesValuesSV(projectionBlock);
                    }
                    block55: for (i = 0; i < length; ++i) {
                        for (byte[][] inBytesValue : inBytesValues) {
                            if (!Arrays.equals(bytesValues[i], inBytesValue[i])) continue;
                            this._intValuesSV[i] = 1;
                            continue block55;
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._intValuesSV;
    }
}

