/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;

public abstract class SelectTupleElementTransformFunction
extends BaseTransformFunction {
    private static final EnumSet<FieldSpec.DataType> SUPPORTED_DATATYPES = EnumSet.of(FieldSpec.DataType.INT, new FieldSpec.DataType[]{FieldSpec.DataType.LONG, FieldSpec.DataType.FLOAT, FieldSpec.DataType.DOUBLE, FieldSpec.DataType.TIMESTAMP, FieldSpec.DataType.STRING});
    private static final EnumMap<FieldSpec.DataType, EnumSet<FieldSpec.DataType>> ACCEPTABLE_COMBINATIONS = SelectTupleElementTransformFunction.createAcceptableCombinations();
    private final String _name;
    protected List<TransformFunction> _arguments;
    private TransformResultMetadata _resultMetadata;

    public SelectTupleElementTransformFunction(String name) {
        this._name = name;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        if (arguments.isEmpty()) {
            throw new IllegalArgumentException(this._name + " takes at least one argument");
        }
        FieldSpec.DataType dataType = null;
        for (int i = 0; i < arguments.size(); ++i) {
            TransformFunction argument = arguments.get(i);
            TransformResultMetadata metadata = argument.getResultMetadata();
            if (!metadata.isSingleValue()) {
                throw new IllegalArgumentException(argument.getName() + " at position " + i + " is not single value");
            }
            FieldSpec.DataType argumentType = metadata.getDataType();
            if (!SUPPORTED_DATATYPES.contains(argumentType)) {
                throw new IllegalArgumentException(argumentType + " not supported. Required one of " + SUPPORTED_DATATYPES);
            }
            if (dataType == null) {
                dataType = argumentType;
                continue;
            }
            if (ACCEPTABLE_COMBINATIONS.get(dataType).contains(argumentType)) {
                dataType = SelectTupleElementTransformFunction.getLowestCommonDenominatorType(dataType, argumentType);
                continue;
            }
            throw new IllegalArgumentException("combination " + argumentType + " not supported. Required one of " + ACCEPTABLE_COMBINATIONS.get(dataType));
        }
        this._resultMetadata = new TransformResultMetadata(dataType, true, false);
        this._arguments = arguments;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public String getName() {
        return this._name;
    }

    private static FieldSpec.DataType getLowestCommonDenominatorType(FieldSpec.DataType left, FieldSpec.DataType right) {
        if (left == null || left == right) {
            return right;
        }
        if (right == FieldSpec.DataType.INT && left == FieldSpec.DataType.LONG || left == FieldSpec.DataType.INT && right == FieldSpec.DataType.LONG) {
            return FieldSpec.DataType.LONG;
        }
        return FieldSpec.DataType.DOUBLE;
    }

    private static EnumMap<FieldSpec.DataType, EnumSet<FieldSpec.DataType>> createAcceptableCombinations() {
        EnumMap<FieldSpec.DataType, EnumSet<FieldSpec.DataType>> combinations = new EnumMap<FieldSpec.DataType, EnumSet<FieldSpec.DataType>>(FieldSpec.DataType.class);
        EnumSet<FieldSpec.DataType> numericTypes = EnumSet.of(FieldSpec.DataType.INT, FieldSpec.DataType.LONG, FieldSpec.DataType.FLOAT, FieldSpec.DataType.DOUBLE);
        for (FieldSpec.DataType numericType : numericTypes) {
            combinations.put(numericType, numericTypes);
        }
        combinations.put(FieldSpec.DataType.TIMESTAMP, EnumSet.of(FieldSpec.DataType.TIMESTAMP));
        combinations.put(FieldSpec.DataType.STRING, EnumSet.of(FieldSpec.DataType.STRING));
        return combinations;
    }
}

