/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;

public abstract class SingleParamMathTransformFunction
extends BaseTransformFunction {
    private TransformFunction _transformFunction;
    protected double[] _results;

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0, (String)"Exactly 1 argument is required for transform function: %s", (Object)this.getName());
        TransformFunction transformFunction = arguments.get(0);
        Preconditions.checkArgument((!(transformFunction instanceof LiteralTransformFunction) ? 1 : 0) != 0, (String)"Argument cannot be literal for transform function: %s", (Object)this.getName());
        Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"Argument must be single-valued for transform function: %s", (Object)this.getName());
        this._transformFunction = transformFunction;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return DOUBLE_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._results == null) {
            this._results = new double[10000];
        }
        double[] values = this._transformFunction.transformToDoubleValuesSV(projectionBlock);
        this.applyMathOperator(values, projectionBlock.getNumDocs());
        return this._results;
    }

    protected abstract void applyMathOperator(double[] var1, int var2);

    public static class SqrtTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "sqrt";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._results[i] = Math.sqrt(values[i]);
            }
        }
    }

    public static class LnTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "ln";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._results[i] = Math.log(values[i]);
            }
        }
    }

    public static class FloorTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "floor";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._results[i] = Math.floor(values[i]);
            }
        }
    }

    public static class ExpTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "exp";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._results[i] = Math.exp(values[i]);
            }
        }
    }

    public static class CeilTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "ceil";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._results[i] = Math.ceil(values[i]);
            }
        }
    }

    public static class AbsTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "abs";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._results[i] = Math.abs(values[i]);
            }
        }
    }
}

