/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.operator.transform.transformer.timeunit.TimeUnitTransformer;
import org.apache.pinot.core.operator.transform.transformer.timeunit.TimeUnitTransformerFactory;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class TimeConversionTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "timeConvert";
    private TransformFunction _mainTransformFunction;
    private TimeUnitTransformer _timeUnitTransformer;
    private long[] _outputTimes;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        if (arguments.size() != 3) {
            throw new IllegalArgumentException("Exactly 3 arguments are required for TIME_CONVERT transform function");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction || !firstArgument.getResultMetadata().isSingleValue()) {
            throw new IllegalArgumentException("The first argument of TIME_CONVERT transform function must be a single-valued column or a transform function");
        }
        this._mainTransformFunction = firstArgument;
        this._timeUnitTransformer = TimeUnitTransformerFactory.getTimeUnitTransformer(TimeUnit.valueOf(((LiteralTransformFunction)arguments.get(1)).getLiteral().toUpperCase()), ((LiteralTransformFunction)arguments.get(2)).getLiteral());
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return LONG_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        if (this._outputTimes == null) {
            this._outputTimes = new long[10000];
        }
        this._timeUnitTransformer.transform(this._mainTransformFunction.transformToLongValuesSV(projectionBlock), this._outputTimes, projectionBlock.getNumDocs());
        return this._outputTimes;
    }
}

