/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.FunctionRegistry;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.core.geospatial.transform.function.GeoToH3Function;
import org.apache.pinot.core.geospatial.transform.function.StAreaFunction;
import org.apache.pinot.core.geospatial.transform.function.StAsBinaryFunction;
import org.apache.pinot.core.geospatial.transform.function.StAsTextFunction;
import org.apache.pinot.core.geospatial.transform.function.StContainsFunction;
import org.apache.pinot.core.geospatial.transform.function.StDistanceFunction;
import org.apache.pinot.core.geospatial.transform.function.StEqualsFunction;
import org.apache.pinot.core.geospatial.transform.function.StGeogFromTextFunction;
import org.apache.pinot.core.geospatial.transform.function.StGeogFromWKBFunction;
import org.apache.pinot.core.geospatial.transform.function.StGeomFromTextFunction;
import org.apache.pinot.core.geospatial.transform.function.StGeomFromWKBFunction;
import org.apache.pinot.core.geospatial.transform.function.StGeometryTypeFunction;
import org.apache.pinot.core.geospatial.transform.function.StPointFunction;
import org.apache.pinot.core.geospatial.transform.function.StPolygonFunction;
import org.apache.pinot.core.geospatial.transform.function.StWithinFunction;
import org.apache.pinot.core.operator.transform.function.AdditionTransformFunction;
import org.apache.pinot.core.operator.transform.function.AndOperatorTransformFunction;
import org.apache.pinot.core.operator.transform.function.ArrayAverageTransformFunction;
import org.apache.pinot.core.operator.transform.function.ArrayLengthTransformFunction;
import org.apache.pinot.core.operator.transform.function.ArrayMaxTransformFunction;
import org.apache.pinot.core.operator.transform.function.ArrayMinTransformFunction;
import org.apache.pinot.core.operator.transform.function.ArraySumTransformFunction;
import org.apache.pinot.core.operator.transform.function.CaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.CastTransformFunction;
import org.apache.pinot.core.operator.transform.function.DateTimeConversionTransformFunction;
import org.apache.pinot.core.operator.transform.function.DateTruncTransformFunction;
import org.apache.pinot.core.operator.transform.function.DivisionTransformFunction;
import org.apache.pinot.core.operator.transform.function.EqualsTransformFunction;
import org.apache.pinot.core.operator.transform.function.GreaterThanOrEqualTransformFunction;
import org.apache.pinot.core.operator.transform.function.GreaterThanTransformFunction;
import org.apache.pinot.core.operator.transform.function.GreatestTransformFunction;
import org.apache.pinot.core.operator.transform.function.GroovyTransformFunction;
import org.apache.pinot.core.operator.transform.function.IdentifierTransformFunction;
import org.apache.pinot.core.operator.transform.function.InIdSetTransformFunction;
import org.apache.pinot.core.operator.transform.function.InTransformFunction;
import org.apache.pinot.core.operator.transform.function.JsonExtractKeyTransformFunction;
import org.apache.pinot.core.operator.transform.function.JsonExtractScalarTransformFunction;
import org.apache.pinot.core.operator.transform.function.LeastTransformFunction;
import org.apache.pinot.core.operator.transform.function.LessThanOrEqualTransformFunction;
import org.apache.pinot.core.operator.transform.function.LessThanTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.LookupTransformFunction;
import org.apache.pinot.core.operator.transform.function.MapValueTransformFunction;
import org.apache.pinot.core.operator.transform.function.ModuloTransformFunction;
import org.apache.pinot.core.operator.transform.function.MultiplicationTransformFunction;
import org.apache.pinot.core.operator.transform.function.NotEqualsTransformFunction;
import org.apache.pinot.core.operator.transform.function.OrOperatorTransformFunction;
import org.apache.pinot.core.operator.transform.function.RegexpExtractTransformFunction;
import org.apache.pinot.core.operator.transform.function.ScalarTransformFunctionWrapper;
import org.apache.pinot.core.operator.transform.function.SingleParamMathTransformFunction;
import org.apache.pinot.core.operator.transform.function.SubtractionTransformFunction;
import org.apache.pinot.core.operator.transform.function.TimeConversionTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.operator.transform.function.ValueInTransformFunction;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.exception.BadQueryRequestException;

public class TransformFunctionFactory {
    private static final Map<String, Class<? extends TransformFunction>> TRANSFORM_FUNCTION_MAP = new HashMap<String, Class<? extends TransformFunction>>(){
        {
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ADD.getName().toLowerCase()), AdditionTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.SUB.getName().toLowerCase()), SubtractionTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.MULT.getName().toLowerCase()), MultiplicationTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.DIV.getName().toLowerCase()), DivisionTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.MOD.getName().toLowerCase()), ModuloTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.PLUS.getName().toLowerCase()), AdditionTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.MINUS.getName().toLowerCase()), SubtractionTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.TIMES.getName().toLowerCase()), MultiplicationTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.DIVIDE.getName().toLowerCase()), DivisionTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ABS.getName().toLowerCase()), SingleParamMathTransformFunction.AbsTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.CEIL.getName().toLowerCase()), SingleParamMathTransformFunction.CeilTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.EXP.getName().toLowerCase()), SingleParamMathTransformFunction.ExpTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.FLOOR.getName().toLowerCase()), SingleParamMathTransformFunction.FloorTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.LN.getName().toLowerCase()), SingleParamMathTransformFunction.LnTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.SQRT.getName().toLowerCase()), SingleParamMathTransformFunction.SqrtTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.CAST.getName().toLowerCase()), CastTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.JSONEXTRACTSCALAR.getName().toLowerCase()), JsonExtractScalarTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.JSONEXTRACTKEY.getName().toLowerCase()), JsonExtractKeyTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.TIMECONVERT.getName().toLowerCase()), TimeConversionTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.DATETIMECONVERT.getName().toLowerCase()), DateTimeConversionTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.DATETRUNC.getName().toLowerCase()), DateTruncTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ARRAYLENGTH.getName().toLowerCase()), ArrayLengthTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.VALUEIN.getName().toLowerCase()), ValueInTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.MAPVALUE.getName().toLowerCase()), MapValueTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.INIDSET.getName().toLowerCase()), InIdSetTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.LOOKUP.getName().toLowerCase()), LookupTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.REGEXP_EXTRACT.getName().toLowerCase()), RegexpExtractTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ARRAYAVERAGE.getName().toLowerCase()), ArrayAverageTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ARRAYMAX.getName().toLowerCase()), ArrayMaxTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ARRAYMIN.getName().toLowerCase()), ArrayMinTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ARRAYSUM.getName().toLowerCase()), ArraySumTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.GROOVY.getName().toLowerCase()), GroovyTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.CASE.getName().toLowerCase()), CaseTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.EQUALS.getName().toLowerCase()), EqualsTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.NOT_EQUALS.getName().toLowerCase()), NotEqualsTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.GREATER_THAN.getName().toLowerCase()), GreaterThanTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.GREATER_THAN_OR_EQUAL.getName().toLowerCase()), GreaterThanOrEqualTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.LESS_THAN.getName().toLowerCase()), LessThanTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.LESS_THAN_OR_EQUAL.getName().toLowerCase()), LessThanOrEqualTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.IN.getName().toLowerCase()), InTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.AND.getName().toLowerCase()), AndOperatorTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.OR.getName().toLowerCase()), OrOperatorTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ST_GEOG_FROM_TEXT.getName().toLowerCase()), StGeogFromTextFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ST_GEOG_FROM_WKB.getName().toLowerCase()), StGeogFromWKBFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ST_GEOM_FROM_TEXT.getName().toLowerCase()), StGeomFromTextFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ST_GEOM_FROM_WKB.getName().toLowerCase()), StGeomFromWKBFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ST_POINT.getName().toLowerCase()), StPointFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ST_POLYGON.getName().toLowerCase()), StPolygonFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ST_AREA.getName().toLowerCase()), StAreaFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ST_DISTANCE.getName().toLowerCase()), StDistanceFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ST_GEOMETRY_TYPE.getName().toLowerCase()), StGeometryTypeFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ST_AS_BINARY.getName().toLowerCase()), StAsBinaryFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ST_AS_TEXT.getName().toLowerCase()), StAsTextFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ST_CONTAINS.getName().toLowerCase()), StContainsFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ST_EQUALS.getName().toLowerCase()), StEqualsFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.ST_WITHIN.getName().toLowerCase()), StWithinFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.GEOTOH3.getName().toLowerCase()), GeoToH3Function.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.LEAST.getName().toLowerCase()), LeastTransformFunction.class);
            this.put(TransformFunctionFactory.canonicalize(TransformFunctionType.GREATEST.getName().toLowerCase()), GreatestTransformFunction.class);
        }
    };

    private TransformFunctionFactory() {
    }

    public static void init(Set<Class<TransformFunction>> transformFunctionClasses) {
        for (Class<TransformFunction> transformFunctionClass : transformFunctionClasses) {
            TransformFunction transformFunction;
            try {
                transformFunction = transformFunctionClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Caught exception while instantiating transform function from class: " + transformFunctionClass.toString(), e);
            }
            String transformFunctionName = TransformFunctionFactory.canonicalize(transformFunction.getName());
            if (TRANSFORM_FUNCTION_MAP.containsKey(transformFunctionName)) {
                throw new IllegalArgumentException("Transform function: " + transformFunctionName + " already exists");
            }
            TRANSFORM_FUNCTION_MAP.put(transformFunctionName, transformFunctionClass);
        }
    }

    public static TransformFunction get(ExpressionContext expression, Map<String, DataSource> dataSourceMap) {
        return TransformFunctionFactory.get(null, expression, dataSourceMap);
    }

    public static TransformFunction get(@Nullable QueryContext queryContext, ExpressionContext expression, Map<String, DataSource> dataSourceMap) {
        switch (expression.getType()) {
            case FUNCTION: {
                TransformFunction transformFunction;
                FunctionContext function = expression.getFunction();
                String functionName = TransformFunctionFactory.canonicalize(function.getFunctionName());
                List arguments = function.getArguments();
                int numArguments = arguments.size();
                Class<? extends TransformFunction> transformFunctionClass = TRANSFORM_FUNCTION_MAP.get(functionName);
                if (transformFunctionClass != null) {
                    try {
                        transformFunction = transformFunctionClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Caught exception while constructing transform function: " + functionName, e);
                    }
                } else {
                    FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo((String)functionName, (int)numArguments);
                    if (functionInfo == null) {
                        if (FunctionRegistry.containsFunction((String)functionName)) {
                            throw new BadQueryRequestException(String.format("Unsupported function: %s with %d parameters", functionName, numArguments));
                        }
                        throw new BadQueryRequestException(String.format("Unsupported function: %s not found", functionName));
                    }
                    transformFunction = new ScalarTransformFunctionWrapper(functionInfo);
                }
                ArrayList<TransformFunction> transformFunctionArguments = new ArrayList<TransformFunction>(numArguments);
                for (ExpressionContext argument : arguments) {
                    transformFunctionArguments.add(TransformFunctionFactory.get(queryContext, argument, dataSourceMap));
                }
                try {
                    transformFunction.init(transformFunctionArguments, dataSourceMap);
                }
                catch (Exception e) {
                    throw new BadQueryRequestException("Caught exception while initializing transform function: " + functionName, (Throwable)e);
                }
                return transformFunction;
            }
            case IDENTIFIER: {
                String columnName = expression.getIdentifier();
                return new IdentifierTransformFunction(columnName, dataSourceMap.get(columnName));
            }
            case LITERAL: {
                return queryContext == null ? new LiteralTransformFunction(expression.getLiteral()) : (TransformFunction)queryContext.getOrComputeSharedValue(LiteralTransformFunction.class, expression.getLiteral(), LiteralTransformFunction::new);
            }
        }
        throw new IllegalStateException();
    }

    public static String canonicalize(String functionName) {
        return StringUtils.remove((String)functionName, (char)'_').toLowerCase();
    }
}

