/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.query.AggregationGroupByOrderByOperator;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.plan.FilterPlanNode;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.TransformPlanNode;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.startree.CompositePredicateEvaluator;
import org.apache.pinot.core.startree.StarTreeUtils;
import org.apache.pinot.core.startree.plan.StarTreeTransformPlanNode;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;

public class AggregationGroupByOrderByPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final QueryContext _queryContext;

    public AggregationGroupByOrderByPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        this._indexSegment = indexSegment;
        this._queryContext = queryContext;
    }

    public AggregationGroupByOrderByOperator run() {
        Map<String, List<CompositePredicateEvaluator>> predicateEvaluatorsMap;
        AggregationFunctionColumnPair[] aggregationFunctionColumnPairs;
        assert (this._queryContext.getAggregationFunctions() != null);
        assert (this._queryContext.getGroupByExpressions() != null);
        int numTotalDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        AggregationFunction[] aggregationFunctions = this._queryContext.getAggregationFunctions();
        ExpressionContext[] groupByExpressions = this._queryContext.getGroupByExpressions().toArray(new ExpressionContext[0]);
        FilterPlanNode filterPlanNode = new FilterPlanNode(this._indexSegment, this._queryContext);
        BaseFilterOperator filterOperator = filterPlanNode.run();
        List starTrees = this._indexSegment.getStarTrees();
        if (starTrees != null && !StarTreeUtils.isStarTreeDisabled(this._queryContext) && (aggregationFunctionColumnPairs = StarTreeUtils.extractAggregationFunctionPairs(aggregationFunctions)) != null && (predicateEvaluatorsMap = StarTreeUtils.extractPredicateEvaluatorsMap(this._indexSegment, this._queryContext.getFilter(), filterPlanNode.getPredicateEvaluatorMap())) != null) {
            for (StarTreeV2 starTreeV2 : starTrees) {
                if (!StarTreeUtils.isFitForStarTree(starTreeV2.getMetadata(), aggregationFunctionColumnPairs, groupByExpressions, predicateEvaluatorsMap.keySet())) continue;
                TransformOperator transformOperator = new StarTreeTransformPlanNode(starTreeV2, aggregationFunctionColumnPairs, groupByExpressions, predicateEvaluatorsMap, this._queryContext.getDebugOptions()).run();
                return new AggregationGroupByOrderByOperator(aggregationFunctions, groupByExpressions, transformOperator, numTotalDocs, this._queryContext, true);
            }
        }
        Set<ExpressionContext> expressionsToTransform = AggregationFunctionUtils.collectExpressionsToTransform(aggregationFunctions, groupByExpressions);
        TransformOperator transformPlanNode = new TransformPlanNode(this._indexSegment, this._queryContext, expressionsToTransform, 10000, filterOperator).run();
        return new AggregationGroupByOrderByOperator(aggregationFunctions, groupByExpressions, transformPlanNode, numTotalDocs, this._queryContext, false);
    }
}

