/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.combine.AggregationOnlyCombineOperator;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.operator.combine.CombineOperatorUtils;
import org.apache.pinot.core.operator.combine.DistinctCombineOperator;
import org.apache.pinot.core.operator.combine.GroupByCombineOperator;
import org.apache.pinot.core.operator.combine.GroupByOrderByCombineOperator;
import org.apache.pinot.core.operator.combine.SelectionOnlyCombineOperator;
import org.apache.pinot.core.operator.combine.SelectionOrderByCombineOperator;
import org.apache.pinot.core.operator.streaming.StreamingSelectionOnlyCombineOperator;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextUtils;
import org.apache.pinot.core.util.QueryOptionsUtils;
import org.apache.pinot.core.util.trace.TraceCallable;
import org.apache.pinot.spi.exception.BadQueryRequestException;

public class CombinePlanNode
implements PlanNode {
    private static final int TARGET_NUM_PLANS_PER_THREAD = 10;
    private final List<PlanNode> _planNodes;
    private final QueryContext _queryContext;
    private final ExecutorService _executorService;
    private final StreamObserver<Server.ServerResponse> _streamObserver;

    public CombinePlanNode(List<PlanNode> planNodes, QueryContext queryContext, ExecutorService executorService, @Nullable StreamObserver<Server.ServerResponse> streamObserver) {
        this._planNodes = planNodes;
        this._queryContext = queryContext;
        this._executorService = executorService;
        this._streamObserver = streamObserver;
    }

    public BaseCombineOperator run() {
        final int numPlanNodes = this._planNodes.size();
        ArrayList<Operator> operators = new ArrayList<Operator>(numPlanNodes);
        if (numPlanNodes <= 10) {
            for (PlanNode planNode : this._planNodes) {
                operators.add(planNode.run());
            }
        } else {
            int maxExecutionThreads = this._queryContext.getMaxExecutionThreads();
            if (maxExecutionThreads <= 0) {
                maxExecutionThreads = CombineOperatorUtils.MAX_NUM_THREADS_PER_QUERY;
            }
            final int numTasks = Math.min((numPlanNodes + 10 - 1) / 10, maxExecutionThreads);
            final Phaser phaser = new Phaser(1);
            Future[] futures = new Future[numTasks];
            for (int i = 0; i < numTasks; ++i) {
                final int index = i;
                futures[i] = this._executorService.submit(new TraceCallable<List<Operator>>(){

                    @Override
                    public List<Operator> callJob() {
                        try {
                            if (phaser.register() < 0) {
                                List<Operator> list = Collections.emptyList();
                                return list;
                            }
                            ArrayList<Operator> operators = new ArrayList<Operator>();
                            for (int i = index; i < numPlanNodes; i += numTasks) {
                                operators.add(((PlanNode)CombinePlanNode.this._planNodes.get(i)).run());
                            }
                            ArrayList<Operator> arrayList = operators;
                            return arrayList;
                        }
                        finally {
                            phaser.arriveAndDeregister();
                        }
                    }
                });
            }
            try {
                for (Future future : futures) {
                    List ops = (List)future.get(this._queryContext.getEndTimeMs() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                    operators.addAll(ops);
                }
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof BadQueryRequestException) {
                    throw (BadQueryRequestException)cause;
                }
                throw new RuntimeException("Caught exception while running CombinePlanNode.", e);
            }
            finally {
                for (Future future : futures) {
                    if (future.isDone()) continue;
                    future.cancel(true);
                }
                phaser.awaitAdvance(phaser.arriveAndDeregister());
            }
        }
        if (this._streamObserver != null && QueryContextUtils.isSelectionOnlyQuery(this._queryContext)) {
            return new StreamingSelectionOnlyCombineOperator(operators, this._queryContext, this._executorService, this._streamObserver);
        }
        if (QueryContextUtils.isAggregationQuery(this._queryContext)) {
            if (this._queryContext.getGroupByExpressions() == null) {
                return new AggregationOnlyCombineOperator(operators, this._queryContext, this._executorService);
            }
            if (QueryOptionsUtils.isGroupByModeSQL(this._queryContext.getQueryOptions())) {
                return new GroupByOrderByCombineOperator(operators, this._queryContext, this._executorService);
            }
            return new GroupByCombineOperator(operators, this._queryContext, this._executorService);
        }
        if (QueryContextUtils.isSelectionQuery(this._queryContext)) {
            if (this._queryContext.getLimit() == 0 || this._queryContext.getOrderByExpressions() == null) {
                return new SelectionOnlyCombineOperator(operators, this._queryContext, this._executorService);
            }
            return new SelectionOrderByCombineOperator(operators, this._queryContext, this._executorService);
        }
        assert (QueryContextUtils.isDistinctQuery(this._queryContext));
        return new DistinctCombineOperator(operators, this._queryContext, this._executorService);
    }
}

