/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import javax.annotation.Nullable;
import org.apache.pinot.core.operator.DocIdSetOperator;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.plan.FilterPlanNode;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;

public class DocIdSetPlanNode
implements PlanNode {
    public static final int MAX_DOC_PER_CALL = 10000;
    private final IndexSegment _indexSegment;
    private final QueryContext _queryContext;
    private final int _maxDocPerCall;
    private final BaseFilterOperator _filterOperator;

    public DocIdSetPlanNode(IndexSegment indexSegment, QueryContext queryContext, int maxDocPerCall, @Nullable BaseFilterOperator filterOperator) {
        assert (maxDocPerCall > 0 && maxDocPerCall <= 10000);
        this._indexSegment = indexSegment;
        this._queryContext = queryContext;
        this._maxDocPerCall = maxDocPerCall;
        this._filterOperator = filterOperator;
    }

    public DocIdSetOperator run() {
        return new DocIdSetOperator(this._filterOperator != null ? this._filterOperator : new FilterPlanNode(this._indexSegment, this._queryContext).run(), this._maxDocPerCall);
    }
}

