/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.query.EmptySelectionOperator;
import org.apache.pinot.core.operator.query.SelectionOnlyOperator;
import org.apache.pinot.core.operator.query.SelectionOrderByOperator;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.TransformPlanNode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.segment.spi.IndexSegment;

public class SelectionPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final QueryContext _queryContext;

    public SelectionPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        this._indexSegment = indexSegment;
        this._queryContext = queryContext;
    }

    public Operator<IntermediateResultsBlock> run() {
        List<ExpressionContext> expressions = SelectionOperatorUtils.extractExpressions(this._queryContext, this._indexSegment);
        int limit = this._queryContext.getLimit();
        if (limit > 0) {
            List<OrderByExpressionContext> orderByExpressions = this._queryContext.getOrderByExpressions();
            if (orderByExpressions == null) {
                TransformOperator transformOperator = new TransformPlanNode(this._indexSegment, this._queryContext, expressions, Math.min(limit, 10000)).run();
                return new SelectionOnlyOperator(this._indexSegment, this._queryContext, expressions, transformOperator);
            }
            if (this.isAllOrderByColumnsSorted(orderByExpressions)) {
                TransformOperator transformOperator = new TransformPlanNode(this._indexSegment, this._queryContext, expressions, Math.min(limit + this._queryContext.getOffset(), 10000)).run();
                return new SelectionOrderByOperator(this._indexSegment, this._queryContext, expressions, transformOperator, true);
            }
            if (orderByExpressions.size() == expressions.size()) {
                TransformOperator transformOperator = new TransformPlanNode(this._indexSegment, this._queryContext, expressions, 10000).run();
                return new SelectionOrderByOperator(this._indexSegment, this._queryContext, expressions, transformOperator, false);
            }
            ArrayList<ExpressionContext> expressionsToTransform = new ArrayList<ExpressionContext>(orderByExpressions.size());
            for (OrderByExpressionContext orderByExpression : orderByExpressions) {
                expressionsToTransform.add(orderByExpression.getExpression());
            }
            TransformOperator transformOperator = new TransformPlanNode(this._indexSegment, this._queryContext, expressionsToTransform, 10000).run();
            return new SelectionOrderByOperator(this._indexSegment, this._queryContext, expressions, transformOperator, false);
        }
        TransformOperator transformOperator = new TransformPlanNode(this._indexSegment, this._queryContext, expressions, 0).run();
        return new EmptySelectionOperator(this._indexSegment, expressions, transformOperator);
    }

    private boolean isAllOrderByColumnsSorted(List<OrderByExpressionContext> orderByExpressions) {
        for (OrderByExpressionContext orderByExpression : orderByExpressions) {
            if (orderByExpression.getExpression().getType() != ExpressionContext.Type.IDENTIFIER || !orderByExpression.isAsc()) {
                return false;
            }
            String column = orderByExpression.getExpression().getIdentifier();
            if (this._indexSegment.getDataSource(column).getDataSourceMetadata().isSorted()) continue;
            return false;
        }
        return true;
    }
}

