/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan.maker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.plan.AcquireReleaseColumnsSegmentPlanNode;
import org.apache.pinot.core.plan.AggregationGroupByOrderByPlanNode;
import org.apache.pinot.core.plan.AggregationGroupByPlanNode;
import org.apache.pinot.core.plan.AggregationPlanNode;
import org.apache.pinot.core.plan.CombinePlanNode;
import org.apache.pinot.core.plan.DistinctPlanNode;
import org.apache.pinot.core.plan.GlobalPlanImplV0;
import org.apache.pinot.core.plan.InstanceResponsePlanNode;
import org.apache.pinot.core.plan.Plan;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.SelectionPlanNode;
import org.apache.pinot.core.plan.StreamingInstanceResponsePlanNode;
import org.apache.pinot.core.plan.StreamingSelectionPlanNode;
import org.apache.pinot.core.plan.maker.PlanMaker;
import org.apache.pinot.core.query.config.QueryExecutorConfig;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextUtils;
import org.apache.pinot.core.util.QueryOptionsUtils;
import org.apache.pinot.segment.spi.FetchContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstancePlanMakerImplV2
implements PlanMaker {
    public static final String MAX_EXECUTION_THREADS_KEY = "max.execution.threads";
    public static final int DEFAULT_MAX_EXECUTION_THREADS = -1;
    public static final String MAX_INITIAL_RESULT_HOLDER_CAPACITY_KEY = "max.init.group.holder.capacity";
    public static final int DEFAULT_MAX_INITIAL_RESULT_HOLDER_CAPACITY = 10000;
    public static final String NUM_GROUPS_LIMIT_KEY = "num.groups.limit";
    public static final int DEFAULT_NUM_GROUPS_LIMIT = 100000;
    public static final String MIN_SEGMENT_GROUP_TRIM_SIZE_KEY = "min.segment.group.trim.size";
    public static final int DEFAULT_MIN_SEGMENT_GROUP_TRIM_SIZE = -1;
    public static final String MIN_SERVER_GROUP_TRIM_SIZE_KEY = "min.server.group.trim.size";
    public static final int DEFAULT_MIN_SERVER_GROUP_TRIM_SIZE = 5000;
    public static final String GROUPBY_TRIM_THRESHOLD_KEY = "groupby.trim.threshold";
    public static final int DEFAULT_GROUPBY_TRIM_THRESHOLD = 1000000;
    private static final Logger LOGGER = LoggerFactory.getLogger(InstancePlanMakerImplV2.class);
    private final int _maxExecutionThreads;
    private final int _maxInitialResultHolderCapacity;
    private final int _numGroupsLimit;
    private final int _minSegmentGroupTrimSize;
    private final int _minServerGroupTrimSize;
    private final int _groupByTrimThreshold;

    @VisibleForTesting
    public InstancePlanMakerImplV2() {
        this._maxExecutionThreads = -1;
        this._maxInitialResultHolderCapacity = 10000;
        this._numGroupsLimit = 100000;
        this._minSegmentGroupTrimSize = -1;
        this._minServerGroupTrimSize = 5000;
        this._groupByTrimThreshold = 1000000;
    }

    @VisibleForTesting
    public InstancePlanMakerImplV2(int maxInitialResultHolderCapacity, int numGroupsLimit, int minSegmentGroupTrimSize, int minServerGroupTrimSize, int groupByTrimThreshold) {
        this._maxExecutionThreads = -1;
        this._maxInitialResultHolderCapacity = maxInitialResultHolderCapacity;
        this._numGroupsLimit = numGroupsLimit;
        this._minSegmentGroupTrimSize = minSegmentGroupTrimSize;
        this._minServerGroupTrimSize = minServerGroupTrimSize;
        this._groupByTrimThreshold = groupByTrimThreshold;
    }

    public InstancePlanMakerImplV2(QueryExecutorConfig queryExecutorConfig) {
        PinotConfiguration config = queryExecutorConfig.getConfig();
        this._maxExecutionThreads = config.getProperty(MAX_EXECUTION_THREADS_KEY, -1);
        this._maxInitialResultHolderCapacity = config.getProperty(MAX_INITIAL_RESULT_HOLDER_CAPACITY_KEY, 10000);
        this._numGroupsLimit = config.getProperty(NUM_GROUPS_LIMIT_KEY, 100000);
        Preconditions.checkState((this._maxInitialResultHolderCapacity <= this._numGroupsLimit ? 1 : 0) != 0, (String)"Invalid configuration: maxInitialResultHolderCapacity: %d must be smaller or equal to numGroupsLimit: %d", (int)this._maxInitialResultHolderCapacity, (int)this._numGroupsLimit);
        this._minSegmentGroupTrimSize = config.getProperty(MIN_SEGMENT_GROUP_TRIM_SIZE_KEY, -1);
        this._minServerGroupTrimSize = config.getProperty(MIN_SERVER_GROUP_TRIM_SIZE_KEY, 5000);
        this._groupByTrimThreshold = config.getProperty(GROUPBY_TRIM_THRESHOLD_KEY, 1000000);
        Preconditions.checkState((this._groupByTrimThreshold > 0 ? 1 : 0) != 0, (String)"Invalid configurable: groupByTrimThreshold: %d must be positive", (int)this._groupByTrimThreshold);
        LOGGER.info("Initializing plan maker with maxInitialResultHolderCapacity: {}, numGroupsLimit: {}, minSegmentGroupTrimSize: {}, minServerGroupTrimSize: {}", new Object[]{this._maxInitialResultHolderCapacity, this._numGroupsLimit, this._minSegmentGroupTrimSize, this._minServerGroupTrimSize});
    }

    @Override
    public Plan makeInstancePlan(List<IndexSegment> indexSegments, QueryContext queryContext, ExecutorService executorService) {
        List<FetchContext> fetchContexts;
        this.applyQueryOptions(queryContext);
        int numSegments = indexSegments.size();
        ArrayList<PlanNode> planNodes = new ArrayList<PlanNode>(numSegments);
        if (queryContext.isEnablePrefetch()) {
            fetchContexts = new ArrayList(numSegments);
            List<ExpressionContext> selectExpressions = queryContext.getSelectExpressions();
            for (IndexSegment indexSegment : indexSegments) {
                Set columns = selectExpressions.size() == 1 && "*".equals(((ExpressionContext)selectExpressions.get(0)).getIdentifier()) ? indexSegment.getPhysicalColumnNames() : queryContext.getColumns();
                FetchContext fetchContext = new FetchContext(UUID.randomUUID(), indexSegment.getSegmentName(), columns);
                fetchContexts.add(fetchContext);
                planNodes.add(new AcquireReleaseColumnsSegmentPlanNode(this.makeSegmentPlanNode(indexSegment, queryContext), indexSegment, fetchContext));
            }
        } else {
            fetchContexts = Collections.emptyList();
            for (IndexSegment indexSegment : indexSegments) {
                planNodes.add(this.makeSegmentPlanNode(indexSegment, queryContext));
            }
        }
        CombinePlanNode combinePlanNode = new CombinePlanNode(planNodes, queryContext, executorService, null);
        return new GlobalPlanImplV0(new InstanceResponsePlanNode(combinePlanNode, indexSegments, fetchContexts));
    }

    private void applyQueryOptions(QueryContext queryContext) {
        Map<String, String> queryOptions = queryContext.getQueryOptions();
        Integer maxExecutionThreadsFromQuery = QueryOptionsUtils.getMaxExecutionThreads(queryOptions);
        int maxExecutionThreads = maxExecutionThreadsFromQuery != null && maxExecutionThreadsFromQuery > 0 ? (this._maxExecutionThreads > 0 ? Math.min(this._maxExecutionThreads, maxExecutionThreadsFromQuery) : maxExecutionThreadsFromQuery) : this._maxExecutionThreads;
        queryContext.setMaxExecutionThreads(maxExecutionThreads);
        if (QueryContextUtils.isAggregationQuery(queryContext) && queryContext.getGroupByExpressions() != null) {
            queryContext.setMaxInitialResultHolderCapacity(this._maxInitialResultHolderCapacity);
            queryContext.setNumGroupsLimit(this._numGroupsLimit);
            Integer minSegmentGroupTrimSizeFromQuery = QueryOptionsUtils.getMinSegmentGroupTrimSize(queryOptions);
            int minSegmentGroupTrimSize = minSegmentGroupTrimSizeFromQuery != null ? minSegmentGroupTrimSizeFromQuery : this._minSegmentGroupTrimSize;
            queryContext.setMinSegmentGroupTrimSize(minSegmentGroupTrimSize);
            Integer minServerGroupTrimSizeFromQuery = QueryOptionsUtils.getMinServerGroupTrimSize(queryOptions);
            int minServerGroupTrimSize = minServerGroupTrimSizeFromQuery != null ? minServerGroupTrimSizeFromQuery : this._minServerGroupTrimSize;
            queryContext.setMinServerGroupTrimSize(minServerGroupTrimSize);
            queryContext.setGroupTrimThreshold(this._groupByTrimThreshold);
        }
    }

    @Override
    public PlanNode makeSegmentPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        if (QueryContextUtils.isAggregationQuery(queryContext)) {
            List<ExpressionContext> groupByExpressions = queryContext.getGroupByExpressions();
            if (groupByExpressions != null) {
                if (QueryOptionsUtils.isGroupByModeSQL(queryContext.getQueryOptions())) {
                    return new AggregationGroupByOrderByPlanNode(indexSegment, queryContext);
                }
                return new AggregationGroupByPlanNode(indexSegment, queryContext);
            }
            return new AggregationPlanNode(indexSegment, queryContext);
        }
        if (QueryContextUtils.isSelectionQuery(queryContext)) {
            return new SelectionPlanNode(indexSegment, queryContext);
        }
        assert (QueryContextUtils.isDistinctQuery(queryContext));
        return new DistinctPlanNode(indexSegment, queryContext);
    }

    @Override
    public Plan makeStreamingInstancePlan(List<IndexSegment> indexSegments, QueryContext queryContext, ExecutorService executorService, StreamObserver<Server.ServerResponse> streamObserver) {
        this.applyQueryOptions(queryContext);
        ArrayList<PlanNode> planNodes = new ArrayList<PlanNode>(indexSegments.size());
        for (IndexSegment indexSegment : indexSegments) {
            planNodes.add(this.makeStreamingSegmentPlanNode(indexSegment, queryContext));
        }
        CombinePlanNode combinePlanNode = new CombinePlanNode(planNodes, queryContext, executorService, streamObserver);
        if (QueryContextUtils.isSelectionOnlyQuery(queryContext)) {
            return new GlobalPlanImplV0(new InstanceResponsePlanNode(combinePlanNode, indexSegments, Collections.emptyList()));
        }
        return new GlobalPlanImplV0(new StreamingInstanceResponsePlanNode(combinePlanNode, indexSegments, Collections.emptyList(), streamObserver));
    }

    @Override
    public PlanNode makeStreamingSegmentPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        if (!QueryContextUtils.isSelectionOnlyQuery(queryContext)) {
            return this.makeSegmentPlanNode(indexSegment, queryContext);
        }
        return new StreamingSelectionPlanNode(indexSegment, queryContext);
    }
}

