/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.local.customobject.AvgPair;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class AvgAggregationFunction
extends BaseSingleInputAggregationFunction<AvgPair, Double> {
    private static final double DEFAULT_FINAL_RESULT = Double.NEGATIVE_INFINITY;

    public AvgAggregationFunction(ExpressionContext expression) {
        super(expression);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.AVG;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (blockValSet.getValueType() != FieldSpec.DataType.BYTES) {
            double[] doubleValues = blockValSet.getDoubleValuesSV();
            double sum = 0.0;
            for (int i = 0; i < length; ++i) {
                sum += doubleValues[i];
            }
            this.setAggregationResult(aggregationResultHolder, sum, length);
        } else {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            double sum = 0.0;
            long count = 0L;
            for (int i = 0; i < length; ++i) {
                AvgPair value = ObjectSerDeUtils.AVG_PAIR_SER_DE.deserialize(bytesValues[i]);
                sum += value.getSum();
                count += value.getCount();
            }
            this.setAggregationResult(aggregationResultHolder, sum, count);
        }
    }

    protected void setAggregationResult(AggregationResultHolder aggregationResultHolder, double sum, long count) {
        AvgPair avgPair = (AvgPair)aggregationResultHolder.getResult();
        if (avgPair == null) {
            aggregationResultHolder.setValue(new AvgPair(sum, count));
        } else {
            avgPair.apply(sum, count);
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (blockValSet.getValueType() != FieldSpec.DataType.BYTES) {
            double[] doubleValues = blockValSet.getDoubleValuesSV();
            for (int i = 0; i < length; ++i) {
                this.setGroupByResult(groupKeyArray[i], groupByResultHolder, doubleValues[i], 1L);
            }
        } else {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            for (int i = 0; i < length; ++i) {
                AvgPair avgPair = ObjectSerDeUtils.AVG_PAIR_SER_DE.deserialize(bytesValues[i]);
                this.setGroupByResult(groupKeyArray[i], groupByResultHolder, avgPair.getSum(), avgPair.getCount());
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (blockValSet.getValueType() != FieldSpec.DataType.BYTES) {
            double[] doubleValues = blockValSet.getDoubleValuesSV();
            for (int i = 0; i < length; ++i) {
                double value = doubleValues[i];
                for (int groupKey : groupKeysArray[i]) {
                    this.setGroupByResult(groupKey, groupByResultHolder, value, 1L);
                }
            }
        } else {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            for (int i = 0; i < length; ++i) {
                AvgPair avgPair = ObjectSerDeUtils.AVG_PAIR_SER_DE.deserialize(bytesValues[i]);
                double sum = avgPair.getSum();
                long count = avgPair.getCount();
                for (int groupKey : groupKeysArray[i]) {
                    this.setGroupByResult(groupKey, groupByResultHolder, sum, count);
                }
            }
        }
    }

    protected void setGroupByResult(int groupKey, GroupByResultHolder groupByResultHolder, double sum, long count) {
        AvgPair avgPair = (AvgPair)groupByResultHolder.getResult(groupKey);
        if (avgPair == null) {
            groupByResultHolder.setValueForKey(groupKey, new AvgPair(sum, count));
        } else {
            avgPair.apply(sum, count);
        }
    }

    @Override
    public AvgPair extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        AvgPair avgPair = (AvgPair)aggregationResultHolder.getResult();
        if (avgPair == null) {
            return new AvgPair(0.0, 0L);
        }
        return avgPair;
    }

    @Override
    public AvgPair extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        AvgPair avgPair = (AvgPair)groupByResultHolder.getResult(groupKey);
        if (avgPair == null) {
            return new AvgPair(0.0, 0L);
        }
        return avgPair;
    }

    @Override
    public AvgPair merge(AvgPair intermediateResult1, AvgPair intermediateResult2) {
        intermediateResult1.apply(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public Double extractFinalResult(AvgPair intermediateResult) {
        long count = intermediateResult.getCount();
        if (count == 0L) {
            return Double.NEGATIVE_INFINITY;
        }
        return intermediateResult.getSum() / (double)count;
    }
}

