/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.DoubleAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.DoubleGroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class CountAggregationFunction
implements AggregationFunction<Long, Long> {
    private static final String COLUMN_NAME = "count_star";
    private static final String RESULT_COLUMN_NAME = "count(*)";
    private static final double DEFAULT_INITIAL_VALUE = 0.0;
    private static final ExpressionContext STAR_TREE_COUNT_STAR_EXPRESSION = ExpressionContext.forIdentifier((String)"*");

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.COUNT;
    }

    @Override
    public String getColumnName() {
        return COLUMN_NAME;
    }

    @Override
    public String getResultColumnName() {
        return RESULT_COLUMN_NAME;
    }

    @Override
    public List<ExpressionContext> getInputExpressions() {
        return Collections.emptyList();
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new DoubleAggregationResultHolder(0.0);
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new DoubleGroupByResultHolder(initialCapacity, maxCapacity, 0.0);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        if (blockValSetMap.isEmpty()) {
            aggregationResultHolder.setValue(aggregationResultHolder.getDoubleResult() + (double)length);
        } else {
            long[] valueArray = blockValSetMap.get(STAR_TREE_COUNT_STAR_EXPRESSION).getLongValuesSV();
            long count = 0L;
            for (int i = 0; i < length; ++i) {
                count += valueArray[i];
            }
            aggregationResultHolder.setValue(aggregationResultHolder.getDoubleResult() + (double)count);
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        if (blockValSetMap.isEmpty()) {
            for (int i = 0; i < length; ++i) {
                int groupKey = groupKeyArray[i];
                groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + 1.0);
            }
        } else {
            long[] valueArray = blockValSetMap.get(STAR_TREE_COUNT_STAR_EXPRESSION).getLongValuesSV();
            for (int i = 0; i < length; ++i) {
                int groupKey = groupKeyArray[i];
                groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + (double)valueArray[i]);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        if (blockValSetMap.isEmpty()) {
            for (int i = 0; i < length; ++i) {
                for (int groupKey : groupKeysArray[i]) {
                    groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + 1.0);
                }
            }
        } else {
            long[] valueArray = blockValSetMap.get(STAR_TREE_COUNT_STAR_EXPRESSION).getLongValuesSV();
            for (int i = 0; i < length; ++i) {
                long value = valueArray[i];
                for (int groupKey : groupKeysArray[i]) {
                    groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + (double)value);
                }
            }
        }
    }

    @Override
    public Long extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        return (long)aggregationResultHolder.getDoubleResult();
    }

    @Override
    public Long extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return (long)groupByResultHolder.getDoubleResult(groupKey);
    }

    @Override
    public Long merge(Long intermediateResult1, Long intermediateResult2) {
        return intermediateResult1 + intermediateResult2;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.LONG;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.LONG;
    }

    @Override
    public Long extractFinalResult(Long intermediateResult) {
        return intermediateResult;
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(this.getType().getName()).append('(');
        int numArguments = this.getInputExpressions().size();
        if (numArguments > 0) {
            stringBuilder.append(this.getInputExpressions().get(0).toString());
            for (int i = 1; i < numArguments; ++i) {
                stringBuilder.append(", ").append(this.getInputExpressions().get(i).toString());
            }
        } else {
            stringBuilder.append("*");
        }
        return stringBuilder.append(')').toString();
    }
}

