/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.tdunning.math.stats.TDigest;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileTDigestAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.local.customobject.SerializedTDigest;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class PercentileRawTDigestAggregationFunction
extends BaseSingleInputAggregationFunction<TDigest, SerializedTDigest> {
    private final PercentileTDigestAggregationFunction _percentileTDigestAggregationFunction;

    public PercentileRawTDigestAggregationFunction(ExpressionContext expressionContext, int percentile) {
        this(expressionContext, new PercentileTDigestAggregationFunction(expressionContext, percentile));
    }

    public PercentileRawTDigestAggregationFunction(ExpressionContext expressionContext, double percentile) {
        this(expressionContext, new PercentileTDigestAggregationFunction(expressionContext, percentile));
    }

    protected PercentileRawTDigestAggregationFunction(ExpressionContext expression, PercentileTDigestAggregationFunction percentileTDigestAggregationFunction) {
        super(expression);
        this._percentileTDigestAggregationFunction = percentileTDigestAggregationFunction;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.PERCENTILERAWTDIGEST;
    }

    @Override
    public String getColumnName() {
        double percentile = this._percentileTDigestAggregationFunction._percentile;
        int version = this._percentileTDigestAggregationFunction._version;
        String type = this.getType().getName();
        return version == 0 ? type + (int)percentile + "_" + this._expression : type + percentile + "_" + this._expression;
    }

    @Override
    public String getResultColumnName() {
        double percentile = this._percentileTDigestAggregationFunction._percentile;
        int version = this._percentileTDigestAggregationFunction._version;
        String type = this.getType().getName().toLowerCase();
        return version == 0 ? type + (int)percentile + "(" + this._expression + ")" : type + "(" + this._expression + ", " + percentile + ")";
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return this._percentileTDigestAggregationFunction.createAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return this._percentileTDigestAggregationFunction.createGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        this._percentileTDigestAggregationFunction.aggregate(length, aggregationResultHolder, blockValSetMap);
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        this._percentileTDigestAggregationFunction.aggregateGroupBySV(length, groupKeyArray, groupByResultHolder, blockValSetMap);
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        this._percentileTDigestAggregationFunction.aggregateGroupByMV(length, groupKeysArray, groupByResultHolder, blockValSetMap);
    }

    @Override
    public TDigest extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        return this._percentileTDigestAggregationFunction.extractAggregationResult(aggregationResultHolder);
    }

    @Override
    public TDigest extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return this._percentileTDigestAggregationFunction.extractGroupByResult(groupByResultHolder, groupKey);
    }

    @Override
    public TDigest merge(TDigest intermediateResult1, TDigest intermediateResult2) {
        return this._percentileTDigestAggregationFunction.merge(intermediateResult1, intermediateResult2);
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return this._percentileTDigestAggregationFunction.getIntermediateResultColumnType();
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.STRING;
    }

    @Override
    public SerializedTDigest extractFinalResult(TDigest intermediateResult) {
        return new SerializedTDigest(intermediateResult, this._percentileTDigestAggregationFunction._percentile);
    }
}

