/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.groupby;

import it.unimi.dsi.fastutil.doubles.Double2IntMap;
import it.unimi.dsi.fastutil.doubles.Double2IntOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2IntMap;
import it.unimi.dsi.fastutil.floats.Float2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Iterator;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.query.aggregation.groupby.GroupKeyGenerator;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;

public class NoDictionarySingleColumnGroupKeyGenerator
implements GroupKeyGenerator {
    private final ExpressionContext _groupByExpression;
    private final FieldSpec.DataType _storedType;
    private final Map _groupKeyMap;
    private final int _globalGroupIdUpperBound;
    private int _numGroups = 0;

    public NoDictionarySingleColumnGroupKeyGenerator(TransformOperator transformOperator, ExpressionContext groupByExpression, int numGroupsLimit) {
        this._groupByExpression = groupByExpression;
        this._storedType = transformOperator.getResultMetadata(this._groupByExpression).getDataType().getStoredType();
        this._groupKeyMap = this.createGroupKeyMap(this._storedType);
        this._globalGroupIdUpperBound = numGroupsLimit;
    }

    @Override
    public int getGlobalGroupKeyUpperBound() {
        return this._globalGroupIdUpperBound;
    }

    @Override
    public void generateKeysForBlock(TransformBlock transformBlock, int[] groupKeys) {
        BlockValSet blockValSet = transformBlock.getBlockValueSet(this._groupByExpression);
        int numDocs = transformBlock.getNumDocs();
        switch (this._storedType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                for (int i = 0; i < numDocs; ++i) {
                    groupKeys[i] = this.getKeyForValue(intValues[i]);
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < numDocs; ++i) {
                    groupKeys[i] = this.getKeyForValue(longValues[i]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < numDocs; ++i) {
                    groupKeys[i] = this.getKeyForValue(floatValues[i]);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < numDocs; ++i) {
                    groupKeys[i] = this.getKeyForValue(doubleValues[i]);
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSet.getStringValuesSV();
                for (int i = 0; i < numDocs; ++i) {
                    groupKeys[i] = this.getKeyForValue(stringValues[i]);
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSet.getBytesValuesSV();
                for (int i = 0; i < numDocs; ++i) {
                    groupKeys[i] = this.getKeyForValue(new ByteArray(bytesValues[i]));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal data type for no-dictionary key generator: " + this._storedType);
            }
        }
    }

    private Map createGroupKeyMap(FieldSpec.DataType keyType) {
        switch (keyType) {
            case INT: {
                Int2IntOpenHashMap intMap = new Int2IntOpenHashMap();
                intMap.defaultReturnValue(-1);
                return intMap;
            }
            case LONG: {
                Long2IntOpenHashMap longMap = new Long2IntOpenHashMap();
                longMap.defaultReturnValue(-1);
                return longMap;
            }
            case FLOAT: {
                Float2IntOpenHashMap floatMap = new Float2IntOpenHashMap();
                floatMap.defaultReturnValue(-1);
                return floatMap;
            }
            case DOUBLE: {
                Double2IntOpenHashMap doubleMap = new Double2IntOpenHashMap();
                doubleMap.defaultReturnValue(-1);
                return doubleMap;
            }
            case STRING: {
                Object2IntOpenHashMap stringMap = new Object2IntOpenHashMap();
                stringMap.defaultReturnValue(-1);
                return stringMap;
            }
            case BYTES: {
                Object2IntOpenHashMap bytesMap = new Object2IntOpenHashMap();
                bytesMap.defaultReturnValue(-1);
                return bytesMap;
            }
        }
        throw new IllegalStateException("Illegal data type for no-dictionary key generator: " + keyType);
    }

    @Override
    public void generateKeysForBlock(TransformBlock transformBlock, int[][] groupKeys) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public int getCurrentGroupKeyUpperBound() {
        return this._groupKeyMap.size();
    }

    @Override
    public Iterator<GroupKeyGenerator.GroupKey> getGroupKeys() {
        switch (this._storedType) {
            case INT: {
                return new IntGroupKeyIterator((Int2IntOpenHashMap)this._groupKeyMap);
            }
            case LONG: {
                return new LongGroupKeyIterator((Long2IntOpenHashMap)this._groupKeyMap);
            }
            case FLOAT: {
                return new FloatGroupKeyIterator((Float2IntOpenHashMap)this._groupKeyMap);
            }
            case DOUBLE: {
                return new DoubleGroupKeyIterator((Double2IntOpenHashMap)this._groupKeyMap);
            }
            case STRING: 
            case BYTES: {
                return new ObjectGroupKeyIterator((Object2IntOpenHashMap)this._groupKeyMap);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Iterator<GroupKeyGenerator.StringGroupKey> getStringGroupKeys() {
        switch (this._storedType) {
            case INT: {
                return new IntStringGroupKeyIterator((Int2IntOpenHashMap)this._groupKeyMap);
            }
            case LONG: {
                return new LongStringGroupKeyIterator((Long2IntOpenHashMap)this._groupKeyMap);
            }
            case FLOAT: {
                return new FloatStringGroupKeyIterator((Float2IntOpenHashMap)this._groupKeyMap);
            }
            case DOUBLE: {
                return new DoubleStringGroupKeyIterator((Double2IntOpenHashMap)this._groupKeyMap);
            }
            case STRING: 
            case BYTES: {
                return new ObjectStringGroupKeyIterator((Object2IntOpenHashMap)this._groupKeyMap);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int getNumKeys() {
        return this._groupKeyMap.size();
    }

    private int getKeyForValue(int value) {
        Int2IntMap map = (Int2IntMap)this._groupKeyMap;
        int groupId = map.get(value);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups++;
            map.put(value, groupId);
        }
        return groupId;
    }

    private int getKeyForValue(long value) {
        Long2IntMap map = (Long2IntMap)this._groupKeyMap;
        int groupId = map.get(value);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups++;
            map.put(value, groupId);
        }
        return groupId;
    }

    private int getKeyForValue(float value) {
        Float2IntMap map = (Float2IntMap)this._groupKeyMap;
        int groupId = map.get(value);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups++;
            map.put(value, groupId);
        }
        return groupId;
    }

    private int getKeyForValue(double value) {
        Double2IntMap map = (Double2IntMap)this._groupKeyMap;
        int groupId = map.get(value);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups++;
            map.put(value, groupId);
        }
        return groupId;
    }

    private int getKeyForValue(String value) {
        Object2IntMap map = (Object2IntMap)this._groupKeyMap;
        int groupId = map.getInt((Object)value);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups++;
            map.put((Object)value, groupId);
        }
        return groupId;
    }

    private int getKeyForValue(ByteArray value) {
        Object2IntMap map = (Object2IntMap)this._groupKeyMap;
        int groupId = map.getInt((Object)value);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups++;
            map.put((Object)value, groupId);
        }
        return groupId;
    }

    private static class ObjectStringGroupKeyIterator
    implements Iterator<GroupKeyGenerator.StringGroupKey> {
        final ObjectIterator<Object2IntMap.Entry> _iterator;
        final GroupKeyGenerator.StringGroupKey _groupKey;

        ObjectStringGroupKeyIterator(Object2IntOpenHashMap objectMap) {
            this._iterator = objectMap.object2IntEntrySet().fastIterator();
            this._groupKey = new GroupKeyGenerator.StringGroupKey();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public GroupKeyGenerator.StringGroupKey next() {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)this._iterator.next();
            this._groupKey._groupId = entry.getIntValue();
            this._groupKey._stringKey = entry.getKey().toString();
            return this._groupKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class DoubleStringGroupKeyIterator
    implements Iterator<GroupKeyGenerator.StringGroupKey> {
        final Iterator<Double2IntMap.Entry> _iterator;
        final GroupKeyGenerator.StringGroupKey _groupKey;

        DoubleStringGroupKeyIterator(Double2IntOpenHashMap doubleMap) {
            this._iterator = doubleMap.double2IntEntrySet().fastIterator();
            this._groupKey = new GroupKeyGenerator.StringGroupKey();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public GroupKeyGenerator.StringGroupKey next() {
            Double2IntMap.Entry entry = this._iterator.next();
            this._groupKey._groupId = entry.getIntValue();
            this._groupKey._stringKey = Double.toString(entry.getDoubleKey());
            return this._groupKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FloatStringGroupKeyIterator
    implements Iterator<GroupKeyGenerator.StringGroupKey> {
        final Iterator<Float2IntMap.Entry> _iterator;
        final GroupKeyGenerator.StringGroupKey _groupKey;

        FloatStringGroupKeyIterator(Float2IntOpenHashMap floatMap) {
            this._iterator = floatMap.float2IntEntrySet().fastIterator();
            this._groupKey = new GroupKeyGenerator.StringGroupKey();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public GroupKeyGenerator.StringGroupKey next() {
            Float2IntMap.Entry entry = this._iterator.next();
            this._groupKey._groupId = entry.getIntValue();
            this._groupKey._stringKey = Float.toString(entry.getFloatKey());
            return this._groupKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class LongStringGroupKeyIterator
    implements Iterator<GroupKeyGenerator.StringGroupKey> {
        final Iterator<Long2IntMap.Entry> _iterator;
        final GroupKeyGenerator.StringGroupKey _groupKey;

        LongStringGroupKeyIterator(Long2IntOpenHashMap longMap) {
            this._iterator = longMap.long2IntEntrySet().fastIterator();
            this._groupKey = new GroupKeyGenerator.StringGroupKey();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public GroupKeyGenerator.StringGroupKey next() {
            Long2IntMap.Entry entry = this._iterator.next();
            this._groupKey._groupId = entry.getIntValue();
            this._groupKey._stringKey = Long.toString(entry.getLongKey());
            return this._groupKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class IntStringGroupKeyIterator
    implements Iterator<GroupKeyGenerator.StringGroupKey> {
        final Iterator<Int2IntMap.Entry> _iterator;
        final GroupKeyGenerator.StringGroupKey _groupKey;

        IntStringGroupKeyIterator(Int2IntOpenHashMap intMap) {
            this._iterator = intMap.int2IntEntrySet().fastIterator();
            this._groupKey = new GroupKeyGenerator.StringGroupKey();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public GroupKeyGenerator.StringGroupKey next() {
            Int2IntMap.Entry entry = this._iterator.next();
            this._groupKey._groupId = entry.getIntValue();
            this._groupKey._stringKey = Integer.toString(entry.getIntKey());
            return this._groupKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ObjectGroupKeyIterator
    implements Iterator<GroupKeyGenerator.GroupKey> {
        final ObjectIterator<Object2IntMap.Entry> _iterator;
        final GroupKeyGenerator.GroupKey _groupKey;

        ObjectGroupKeyIterator(Object2IntOpenHashMap objectMap) {
            this._iterator = objectMap.object2IntEntrySet().fastIterator();
            this._groupKey = new GroupKeyGenerator.GroupKey();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public GroupKeyGenerator.GroupKey next() {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)this._iterator.next();
            this._groupKey._groupId = entry.getIntValue();
            this._groupKey._keys = new Object[]{entry.getKey()};
            return this._groupKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class DoubleGroupKeyIterator
    implements Iterator<GroupKeyGenerator.GroupKey> {
        final Iterator<Double2IntMap.Entry> _iterator;
        final GroupKeyGenerator.GroupKey _groupKey;

        DoubleGroupKeyIterator(Double2IntOpenHashMap doubleMap) {
            this._iterator = doubleMap.double2IntEntrySet().fastIterator();
            this._groupKey = new GroupKeyGenerator.GroupKey();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public GroupKeyGenerator.GroupKey next() {
            Double2IntMap.Entry entry = this._iterator.next();
            this._groupKey._groupId = entry.getIntValue();
            this._groupKey._keys = new Object[]{entry.getDoubleKey()};
            return this._groupKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FloatGroupKeyIterator
    implements Iterator<GroupKeyGenerator.GroupKey> {
        final Iterator<Float2IntMap.Entry> _iterator;
        final GroupKeyGenerator.GroupKey _groupKey;

        FloatGroupKeyIterator(Float2IntOpenHashMap floatMap) {
            this._iterator = floatMap.float2IntEntrySet().fastIterator();
            this._groupKey = new GroupKeyGenerator.GroupKey();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public GroupKeyGenerator.GroupKey next() {
            Float2IntMap.Entry entry = this._iterator.next();
            this._groupKey._groupId = entry.getIntValue();
            this._groupKey._keys = new Object[]{Float.valueOf(entry.getFloatKey())};
            return this._groupKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class LongGroupKeyIterator
    implements Iterator<GroupKeyGenerator.GroupKey> {
        final Iterator<Long2IntMap.Entry> _iterator;
        final GroupKeyGenerator.GroupKey _groupKey;

        LongGroupKeyIterator(Long2IntOpenHashMap longMap) {
            this._iterator = longMap.long2IntEntrySet().fastIterator();
            this._groupKey = new GroupKeyGenerator.GroupKey();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public GroupKeyGenerator.GroupKey next() {
            Long2IntMap.Entry entry = this._iterator.next();
            this._groupKey._groupId = entry.getIntValue();
            this._groupKey._keys = new Object[]{entry.getLongKey()};
            return this._groupKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class IntGroupKeyIterator
    implements Iterator<GroupKeyGenerator.GroupKey> {
        final Iterator<Int2IntMap.Entry> _iterator;
        final GroupKeyGenerator.GroupKey _groupKey;

        IntGroupKeyIterator(Int2IntOpenHashMap intMap) {
            this._iterator = intMap.int2IntEntrySet().fastIterator();
            this._groupKey = new GroupKeyGenerator.GroupKey();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public GroupKeyGenerator.GroupKey next() {
            Int2IntMap.Entry entry = this._iterator.next();
            this._groupKey._groupId = entry.getIntValue();
            this._groupKey._keys = new Object[]{entry.getIntKey()};
            return this._groupKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

