/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.dictionary;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.query.distinct.DistinctExecutor;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

abstract class BaseDictionaryBasedSingleColumnDistinctExecutor
implements DistinctExecutor {
    final ExpressionContext _expression;
    final Dictionary _dictionary;
    final FieldSpec.DataType _dataType;
    final int _limit;
    final IntSet _dictIdSet;

    BaseDictionaryBasedSingleColumnDistinctExecutor(ExpressionContext expression, Dictionary dictionary, FieldSpec.DataType dataType, int limit) {
        this._expression = expression;
        this._dictionary = dictionary;
        this._dataType = dataType;
        this._limit = limit;
        this._dictIdSet = new IntOpenHashSet(Math.min(limit, 10000));
    }

    @Override
    public DistinctTable getResult() {
        DataSchema dataSchema = new DataSchema(new String[]{this._expression.toString()}, new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)this._dataType)});
        ArrayList<Record> records = new ArrayList<Record>(this._dictIdSet.size());
        IntIterator dictIdIterator = this._dictIdSet.iterator();
        while (dictIdIterator.hasNext()) {
            records.add(new Record(new Object[]{this._dictionary.getInternal(dictIdIterator.nextInt())}));
        }
        return new DistinctTable(dataSchema, records);
    }
}

