/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.query.distinct.DistinctExecutor;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.spi.data.FieldSpec;

abstract class BaseRawStringSingleColumnDistinctExecutor
implements DistinctExecutor {
    final ExpressionContext _expression;
    final FieldSpec.DataType _dataType;
    final int _limit;
    final ObjectSet<String> _valueSet;

    BaseRawStringSingleColumnDistinctExecutor(ExpressionContext expression, FieldSpec.DataType dataType, int limit) {
        this._expression = expression;
        this._dataType = dataType;
        this._limit = limit;
        this._valueSet = new ObjectOpenHashSet(Math.min(limit, 10000));
    }

    @Override
    public DistinctTable getResult() {
        DataSchema dataSchema = new DataSchema(new String[]{this._expression.toString()}, new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)this._dataType)});
        ArrayList<Record> records = new ArrayList<Record>(this._valueSet.size());
        for (String value : this._valueSet) {
            records.add(new Record(new Object[]{value}));
        }
        return new DistinctTable(dataSchema, records);
    }
}

