/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import it.unimi.dsi.fastutil.floats.FloatHeapPriorityQueue;
import it.unimi.dsi.fastutil.floats.FloatPriorityQueue;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.query.distinct.raw.BaseRawFloatSingleColumnDistinctExecutor;
import org.apache.pinot.spi.data.FieldSpec;

public class RawFloatSingleColumnDistinctOrderByExecutor
extends BaseRawFloatSingleColumnDistinctExecutor {
    private final FloatPriorityQueue _priorityQueue;

    public RawFloatSingleColumnDistinctOrderByExecutor(ExpressionContext expression, FieldSpec.DataType dataType, OrderByExpressionContext orderByExpression, int limit) {
        super(expression, dataType, limit);
        assert (orderByExpression.getExpression().equals((Object)expression));
        int comparisonFactor = orderByExpression.isAsc() ? -1 : 1;
        this._priorityQueue = new FloatHeapPriorityQueue(Math.min(limit, 10000), (f1, f2) -> Float.compare(f1, f2) * comparisonFactor);
    }

    @Override
    public boolean process(TransformBlock transformBlock) {
        BlockValSet blockValueSet = transformBlock.getBlockValueSet(this._expression);
        float[] values = blockValueSet.getFloatValuesSV();
        int numDocs = transformBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            float value = values[i];
            if (this._valueSet.contains(value)) continue;
            if (this._valueSet.size() < this._limit) {
                this._valueSet.add(value);
                this._priorityQueue.enqueue(value);
                continue;
            }
            float firstValue = this._priorityQueue.firstFloat();
            if (this._priorityQueue.comparator().compare(value, firstValue) <= 0) continue;
            this._valueSet.remove(firstValue);
            this._valueSet.add(value);
            this._priorityQueue.dequeueFloat();
            this._priorityQueue.enqueue(value);
        }
        return false;
    }
}

