/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import it.unimi.dsi.fastutil.longs.LongHeapPriorityQueue;
import it.unimi.dsi.fastutil.longs.LongPriorityQueue;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.query.distinct.raw.BaseRawLongSingleColumnDistinctExecutor;
import org.apache.pinot.spi.data.FieldSpec;

public class RawLongSingleColumnDistinctOrderByExecutor
extends BaseRawLongSingleColumnDistinctExecutor {
    private final LongPriorityQueue _priorityQueue;

    public RawLongSingleColumnDistinctOrderByExecutor(ExpressionContext expression, FieldSpec.DataType dataType, OrderByExpressionContext orderByExpression, int limit) {
        super(expression, dataType, limit);
        assert (orderByExpression.getExpression().equals((Object)expression));
        int comparisonFactor = orderByExpression.isAsc() ? -1 : 1;
        this._priorityQueue = new LongHeapPriorityQueue(Math.min(limit, 10000), (l1, l2) -> Long.compare(l1, l2) * comparisonFactor);
    }

    @Override
    public boolean process(TransformBlock transformBlock) {
        BlockValSet blockValueSet = transformBlock.getBlockValueSet(this._expression);
        long[] values = blockValueSet.getLongValuesSV();
        int numDocs = transformBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            long value = values[i];
            if (this._valueSet.contains(value)) continue;
            if (this._valueSet.size() < this._limit) {
                this._valueSet.add(value);
                this._priorityQueue.enqueue(value);
                continue;
            }
            long firstValue = this._priorityQueue.firstLong();
            if (this._priorityQueue.comparator().compare(value, firstValue) <= 0) continue;
            this._valueSet.remove(firstValue);
            this._valueSet.add(value);
            this._priorityQueue.dequeueLong();
            this._priorityQueue.enqueue(value);
        }
        return false;
    }
}

