/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.query.distinct.raw.BaseRawStringSingleColumnDistinctExecutor;
import org.apache.pinot.spi.data.FieldSpec;

public class RawStringSingleColumnDistinctOrderByExecutor
extends BaseRawStringSingleColumnDistinctExecutor {
    private final PriorityQueue<String> _priorityQueue;

    public RawStringSingleColumnDistinctOrderByExecutor(ExpressionContext expression, FieldSpec.DataType dataType, OrderByExpressionContext orderByExpression, int limit) {
        super(expression, dataType, limit);
        assert (orderByExpression.getExpression().equals((Object)expression));
        int comparisonFactor = orderByExpression.isAsc() ? -1 : 1;
        this._priorityQueue = new ObjectHeapPriorityQueue(Math.min(limit, 10000), (s1, s2) -> s1.compareTo((String)s2) * comparisonFactor);
    }

    @Override
    public boolean process(TransformBlock transformBlock) {
        BlockValSet blockValueSet = transformBlock.getBlockValueSet(this._expression);
        String[] values = blockValueSet.getStringValuesSV();
        int numDocs = transformBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            String value = values[i];
            if (this._valueSet.contains((Object)value)) continue;
            if (this._valueSet.size() < this._limit) {
                this._valueSet.add((Object)value);
                this._priorityQueue.enqueue((Object)value);
                continue;
            }
            String firstValue = (String)this._priorityQueue.first();
            if (this._priorityQueue.comparator().compare(value, firstValue) <= 0) continue;
            this._valueSet.remove((Object)firstValue);
            this._valueSet.add((Object)value);
            this._priorityQueue.dequeue();
            this._priorityQueue.enqueue((Object)value);
        }
        return false;
    }
}

