/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.optimizer.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.core.query.optimizer.filter.FilterOptimizer;
import org.apache.pinot.core.query.optimizer.filter.Range;
import org.apache.pinot.pql.parsers.pql2.ast.FilterKind;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public class MergeRangeFilterOptimizer
implements FilterOptimizer {
    @Override
    public FilterQueryTree optimize(FilterQueryTree filterQueryTree, @Nullable Schema schema) {
        if (schema == null) {
            return filterQueryTree;
        }
        FilterOperator operator = filterQueryTree.getOperator();
        if (operator == FilterOperator.AND) {
            List children = filterQueryTree.getChildren();
            HashMap<String, Range> rangeMap = new HashMap<String, Range>();
            ArrayList<FilterQueryTree> newChildren = new ArrayList<FilterQueryTree>();
            boolean recreateFilter = false;
            for (FilterQueryTree filterQueryTree2 : children) {
                FilterOperator childOperator = filterQueryTree2.getOperator();
                assert (childOperator != FilterOperator.AND);
                if (childOperator == FilterOperator.OR) {
                    filterQueryTree2.getChildren().replaceAll(c -> this.optimize((FilterQueryTree)c, schema));
                    newChildren.add(filterQueryTree2);
                    continue;
                }
                if (childOperator == FilterOperator.RANGE) {
                    String column = filterQueryTree2.getColumn();
                    FieldSpec fieldSpec = schema.getFieldSpecFor(column);
                    if (fieldSpec == null || !fieldSpec.isSingleValueField()) {
                        newChildren.add(filterQueryTree2);
                        continue;
                    }
                    Range range = Range.getRange((String)filterQueryTree2.getValue().get(0), fieldSpec.getDataType());
                    Range currentRange = (Range)rangeMap.get(column);
                    if (currentRange == null) {
                        rangeMap.put(column, range);
                        continue;
                    }
                    currentRange.intersect(range);
                    recreateFilter = true;
                    continue;
                }
                newChildren.add(filterQueryTree2);
            }
            if (recreateFilter) {
                if (newChildren.isEmpty() && rangeMap.size() == 1) {
                    Map.Entry entry = rangeMap.entrySet().iterator().next();
                    return MergeRangeFilterOptimizer.getRangeFilterQueryTree((String)entry.getKey(), (Range)entry.getValue());
                }
                for (Map.Entry entry : rangeMap.entrySet()) {
                    newChildren.add(MergeRangeFilterOptimizer.getRangeFilterQueryTree((String)entry.getKey(), (Range)entry.getValue()));
                }
                return new FilterQueryTree(null, null, FilterOperator.AND, newChildren);
            }
            return filterQueryTree;
        }
        if (operator == FilterOperator.OR) {
            filterQueryTree.getChildren().replaceAll(c -> this.optimize((FilterQueryTree)c, schema));
            return filterQueryTree;
        }
        return filterQueryTree;
    }

    private static FilterQueryTree getRangeFilterQueryTree(String column, Range range) {
        return new FilterQueryTree(column, Collections.singletonList(range.getRangeString()), FilterOperator.RANGE, null);
    }

    @Override
    public Expression optimize(Expression filterExpression, @Nullable Schema schema) {
        if (schema == null || filterExpression.getType() != ExpressionType.FUNCTION) {
            return filterExpression;
        }
        Function function = filterExpression.getFunctionCall();
        String operator = function.getOperator();
        if (operator.equals(FilterKind.AND.name())) {
            List children = function.getOperands();
            HashMap<String, Range> rangeMap = new HashMap<String, Range>();
            ArrayList<Expression> newChildren = new ArrayList<Expression>();
            boolean recreateFilter = false;
            for (Expression expression : children) {
                Function childFunction = expression.getFunctionCall();
                FilterKind filterKind = FilterKind.valueOf((String)childFunction.getOperator());
                assert (filterKind != FilterKind.AND);
                if (filterKind == FilterKind.OR) {
                    childFunction.getOperands().replaceAll(o -> this.optimize((Expression)o, schema));
                    newChildren.add(expression);
                    continue;
                }
                if (filterKind.isRange()) {
                    List operands = childFunction.getOperands();
                    Expression lhs = (Expression)operands.get(0);
                    if (lhs.getType() != ExpressionType.IDENTIFIER) {
                        newChildren.add(expression);
                        continue;
                    }
                    String column = lhs.getIdentifier().getName();
                    FieldSpec fieldSpec = schema.getFieldSpecFor(column);
                    if (fieldSpec == null || !fieldSpec.isSingleValueField()) {
                        newChildren.add(expression);
                        continue;
                    }
                    FieldSpec.DataType dataType = fieldSpec.getDataType();
                    Range range = MergeRangeFilterOptimizer.getRange(filterKind, operands, dataType);
                    Range currentRange = (Range)rangeMap.get(column);
                    if (currentRange == null) {
                        rangeMap.put(column, range);
                        continue;
                    }
                    currentRange.intersect(range);
                    recreateFilter = true;
                    continue;
                }
                newChildren.add(expression);
            }
            if (recreateFilter) {
                if (newChildren.isEmpty() && rangeMap.size() == 1) {
                    Map.Entry entry = rangeMap.entrySet().iterator().next();
                    return MergeRangeFilterOptimizer.getRangeFilterExpression((String)entry.getKey(), (Range)entry.getValue());
                }
                for (Map.Entry entry : rangeMap.entrySet()) {
                    newChildren.add(MergeRangeFilterOptimizer.getRangeFilterExpression((String)entry.getKey(), (Range)entry.getValue()));
                }
                function.setOperands(newChildren);
                return filterExpression;
            }
            return filterExpression;
        }
        if (operator.equals(FilterKind.OR.name())) {
            function.getOperands().replaceAll(c -> this.optimize((Expression)c, schema));
            return filterExpression;
        }
        return filterExpression;
    }

    private static Range getRange(FilterKind filterKind, List<Expression> operands, FieldSpec.DataType dataType) {
        switch (filterKind) {
            case GREATER_THAN: {
                return new Range(MergeRangeFilterOptimizer.getComparable(operands.get(1), dataType), false, null, false);
            }
            case GREATER_THAN_OR_EQUAL: {
                return new Range(MergeRangeFilterOptimizer.getComparable(operands.get(1), dataType), true, null, false);
            }
            case LESS_THAN: {
                return new Range(null, false, MergeRangeFilterOptimizer.getComparable(operands.get(1), dataType), false);
            }
            case LESS_THAN_OR_EQUAL: {
                return new Range(null, false, MergeRangeFilterOptimizer.getComparable(operands.get(1), dataType), true);
            }
            case BETWEEN: {
                return new Range(MergeRangeFilterOptimizer.getComparable(operands.get(1), dataType), true, MergeRangeFilterOptimizer.getComparable(operands.get(2), dataType), true);
            }
            case RANGE: {
                return Range.getRange(operands.get(1).getLiteral().getStringValue(), dataType);
            }
        }
        throw new IllegalStateException("Unsupported filter kind: " + filterKind);
    }

    private static Comparable getComparable(Expression literalExpression, FieldSpec.DataType dataType) {
        return dataType.convertInternal(literalExpression.getLiteral().getFieldValue().toString());
    }

    private static Expression getRangeFilterExpression(String column, Range range) {
        Expression rangeFilter = RequestUtils.getFunctionExpression((String)FilterKind.RANGE.name());
        rangeFilter.getFunctionCall().setOperands(Arrays.asList(RequestUtils.createIdentifierExpression((String)column), RequestUtils.getLiteralExpression((String)range.getRangeString())));
        return rangeFilter;
    }
}

