/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.optimizer.filter;

import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.data.FieldSpec;

public class Range {
    private Comparable _lowerBound;
    private boolean _lowerInclusive;
    private Comparable _upperBound;
    private boolean _upperInclusive;

    public Range(@Nullable Comparable lowerBound, boolean lowerInclusive, @Nullable Comparable upperBound, boolean upperInclusive) {
        this._lowerBound = lowerBound;
        this._lowerInclusive = lowerInclusive;
        this._upperBound = upperBound;
        this._upperInclusive = upperInclusive;
    }

    public void intersect(Range range) {
        int result;
        if (range._lowerBound != null) {
            if (this._lowerBound == null) {
                this._lowerInclusive = range._lowerInclusive;
                this._lowerBound = range._lowerBound;
            } else {
                result = this._lowerBound.compareTo(range._lowerBound);
                if (result < 0) {
                    this._lowerBound = range._lowerBound;
                    this._lowerInclusive = range._lowerInclusive;
                } else if (result == 0) {
                    this._lowerInclusive &= range._lowerInclusive;
                }
            }
        }
        if (range._upperBound != null) {
            if (this._upperBound == null) {
                this._upperInclusive = range._upperInclusive;
                this._upperBound = range._upperBound;
            } else {
                result = this._upperBound.compareTo(range._upperBound);
                if (result > 0) {
                    this._upperBound = range._upperBound;
                    this._upperInclusive = range._upperInclusive;
                } else if (result == 0) {
                    this._upperInclusive &= range._upperInclusive;
                }
            }
        }
    }

    public String getRangeString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this._lowerBound == null) {
            stringBuilder.append('(').append("*");
        } else {
            stringBuilder.append(this._lowerInclusive ? (char)'[' : '(');
            stringBuilder.append(this._lowerBound);
        }
        stringBuilder.append('\u0000');
        if (this._upperBound == null) {
            stringBuilder.append("*").append(')');
        } else {
            stringBuilder.append(this._upperBound);
            stringBuilder.append(this._upperInclusive ? (char)']' : ')');
        }
        return stringBuilder.toString();
    }

    public static Range getRange(String rangeString, FieldSpec.DataType dataType) {
        String[] split = StringUtils.split((String)rangeString, (char)'\u0000');
        String lower = split[0];
        boolean lowerInclusive = lower.charAt(0) == '[';
        String stringLowerBound = lower.substring(1);
        Comparable lowerBound = stringLowerBound.equals("*") ? null : dataType.convertInternal(stringLowerBound);
        String upper = split[1];
        int upperLength = upper.length();
        boolean upperInclusive = upper.charAt(upperLength - 1) == ']';
        String stringUpperBound = upper.substring(0, upperLength - 1);
        Comparable upperBound = stringUpperBound.equals("*") ? null : dataType.convertInternal(stringUpperBound);
        return new Range(lowerBound, lowerInclusive, upperBound, upperInclusive);
    }
}

