/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.optimizer.statement;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.common.function.scalar.StringFunctions;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.core.query.optimizer.statement.StatementOptimizer;
import org.apache.pinot.pql.parsers.pql2.ast.FilterKind;
import org.apache.pinot.spi.annotations.ScalarFunction;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public class StringPredicateFilterOptimizer
implements StatementOptimizer {
    private static final String MINUS_OPERATOR_NAME = "MINUS";
    private static final String STRCMP_OPERATOR_NAME = "STRCMP";
    private static final Set<String> STRING_OUTPUT_FUNCTIONS = StringPredicateFilterOptimizer.getStringOutputFunctionList();

    @Override
    public void optimize(PinotQuery query, @Nullable TableConfig tableConfig, @Nullable Schema schema) {
        Expression expression;
        if (schema == null) {
            return;
        }
        Expression filter = query.getFilterExpression();
        if (filter != null) {
            StringPredicateFilterOptimizer.optimizeExpression(filter, schema);
        }
        if ((expression = query.getHavingExpression()) != null) {
            StringPredicateFilterOptimizer.optimizeExpression(expression, schema);
        }
    }

    private static void optimizeExpression(Expression expression, Schema schema) {
        ExpressionType type = expression.getType();
        if (type != ExpressionType.FUNCTION) {
            return;
        }
        Function function = expression.getFunctionCall();
        String operator = function.getOperator();
        List operands = function.getOperands();
        FilterKind kind = FilterKind.valueOf((String)operator);
        switch (kind) {
            case AND: 
            case OR: {
                for (Expression operand : operands) {
                    StringPredicateFilterOptimizer.optimizeExpression(operand, schema);
                }
                break;
            }
            default: {
                StringPredicateFilterOptimizer.replaceMinusWithCompareForStrings((Expression)operands.get(0), schema);
            }
        }
    }

    private static void replaceMinusWithCompareForStrings(Expression expression, Schema schema) {
        if (expression.getType() != ExpressionType.FUNCTION) {
            return;
        }
        Function function = expression.getFunctionCall();
        String operator = function.getOperator();
        List operands = function.getOperands();
        if (operator.equals(MINUS_OPERATOR_NAME) && operands.size() == 2 && StringPredicateFilterOptimizer.isString((Expression)operands.get(0), schema) && StringPredicateFilterOptimizer.isString((Expression)operands.get(1), schema)) {
            function.setOperator(STRCMP_OPERATOR_NAME);
        }
    }

    private static boolean isString(Expression expression, Schema schema) {
        ExpressionType expressionType = expression.getType();
        if (expressionType == ExpressionType.IDENTIFIER) {
            String column = expression.getIdentifier().getName();
            FieldSpec fieldSpec = schema.getFieldSpecFor(column);
            return fieldSpec != null && fieldSpec.getDataType() == FieldSpec.DataType.STRING;
        }
        return expressionType == ExpressionType.FUNCTION && STRING_OUTPUT_FUNCTIONS.contains(expression.getFunctionCall().getOperator().toUpperCase());
    }

    private static Set<String> getStringOutputFunctionList() {
        Method[] methods;
        HashSet<String> set = new HashSet<String>();
        for (Method method : methods = StringFunctions.class.getDeclaredMethods()) {
            if (method.getReturnType() != String.class) continue;
            if (method.isAnnotationPresent(ScalarFunction.class)) {
                ScalarFunction annotation = method.getAnnotation(ScalarFunction.class);
                for (String name : annotation.names()) {
                    set.add(name.toUpperCase());
                }
            }
            set.add(method.getName().toUpperCase());
        }
        return set;
    }
}

