/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.pruner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.predicate.EqPredicate;
import org.apache.pinot.common.request.context.predicate.InPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.request.context.predicate.RangePredicate;
import org.apache.pinot.core.query.pruner.SegmentPruner;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.FetchContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.index.reader.BloomFilterReader;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.exception.BadQueryRequestException;

public class ColumnValueSegmentPruner
implements SegmentPruner {
    public static final String IN_PREDICATE_THRESHOLD = "inpredicate.threshold";
    private int _inPredicateThreshold;

    @Override
    public void init(PinotConfiguration config) {
        this._inPredicateThreshold = config.getProperty(IN_PREDICATE_THRESHOLD, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IndexSegment> prune(List<IndexSegment> segments, QueryContext query) {
        if (segments.isEmpty()) {
            return segments;
        }
        FilterContext filter = query.getFilter();
        if (filter == null) {
            return segments;
        }
        HashSet<String> eqInColumns = new HashSet<String>();
        HashSet<String> rangeColumns = new HashSet<String>();
        this.extractPredicateColumns(filter, eqInColumns, rangeColumns);
        if (eqInColumns.isEmpty() && rangeColumns.isEmpty()) {
            return segments;
        }
        int numSegments = segments.size();
        ArrayList<IndexSegment> selectedSegments = new ArrayList<IndexSegment>(numSegments);
        if (!eqInColumns.isEmpty() && query.isEnablePrefetch()) {
            int i;
            Map[] dataSourceCaches = new Map[numSegments];
            FetchContext[] fetchContexts = new FetchContext[numSegments];
            try {
                IndexSegment segment;
                for (i = 0; i < numSegments; ++i) {
                    segment = segments.get(i);
                    HashMap<String, DataSource> dataSourceCache = new HashMap<String, DataSource>();
                    HashMap<String, List<ColumnIndexType>> columnToIndexList = new HashMap<String, List<ColumnIndexType>>();
                    for (String column : eqInColumns) {
                        DataSource dataSource = segment.getDataSource(column);
                        assert (dataSource != null);
                        dataSourceCache.put(column, dataSource);
                        if (dataSource.getBloomFilter() == null) continue;
                        columnToIndexList.put(column, Collections.singletonList(ColumnIndexType.BLOOM_FILTER));
                    }
                    dataSourceCaches[i] = dataSourceCache;
                    if (columnToIndexList.isEmpty()) continue;
                    FetchContext fetchContext = new FetchContext(UUID.randomUUID(), segment.getSegmentName(), columnToIndexList);
                    segment.prefetch(fetchContext);
                    fetchContexts[i] = fetchContext;
                }
                for (i = 0; i < numSegments; ++i) {
                    segment = segments.get(i);
                    FetchContext fetchContext = fetchContexts[i];
                    if (fetchContext != null) {
                        segment.acquire(fetchContext);
                        try {
                            if (this.pruneSegment(segment, filter, dataSourceCaches[i])) continue;
                            selectedSegments.add(segment);
                            continue;
                        }
                        finally {
                            segment.release(fetchContext);
                        }
                    }
                    if (this.pruneSegment(segment, filter, dataSourceCaches[i])) continue;
                    selectedSegments.add(segment);
                }
            }
            finally {
                for (i = 0; i < numSegments; ++i) {
                    FetchContext fetchContext = fetchContexts[i];
                    if (fetchContext == null) continue;
                    segments.get(i).release(fetchContext);
                }
            }
        } else {
            for (IndexSegment segment : segments) {
                HashMap<String, DataSource> dataSourceCache;
                if (this.pruneSegment(segment, filter, dataSourceCache = new HashMap<String, DataSource>())) continue;
                selectedSegments.add(segment);
            }
        }
        return selectedSegments;
    }

    private void extractPredicateColumns(FilterContext filter, Set<String> eqInColumns, Set<String> rangeColumns) {
        switch (filter.getType()) {
            case AND: 
            case OR: {
                for (FilterContext child : filter.getChildren()) {
                    this.extractPredicateColumns(child, eqInColumns, rangeColumns);
                }
                break;
            }
            case PREDICATE: {
                Predicate predicate = filter.getPredicate();
                ExpressionContext lhs = predicate.getLhs();
                if (lhs.getType() != ExpressionContext.Type.IDENTIFIER) break;
                String column = lhs.getIdentifier();
                Predicate.Type predicateType = predicate.getType();
                if (predicateType == Predicate.Type.EQ || predicateType == Predicate.Type.IN && ((InPredicate)predicate).getValues().size() <= this._inPredicateThreshold) {
                    eqInColumns.add(column);
                    break;
                }
                if (predicateType != Predicate.Type.RANGE) break;
                rangeColumns.add(column);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private boolean pruneSegment(IndexSegment segment, FilterContext filter, Map<String, DataSource> dataSourceCache) {
        switch (filter.getType()) {
            case AND: {
                for (FilterContext child : filter.getChildren()) {
                    if (!this.pruneSegment(segment, child, dataSourceCache)) continue;
                    return true;
                }
                return false;
            }
            case OR: {
                for (FilterContext child : filter.getChildren()) {
                    if (this.pruneSegment(segment, child, dataSourceCache)) continue;
                    return false;
                }
                return true;
            }
            case PREDICATE: {
                Predicate predicate = filter.getPredicate();
                if (predicate.getLhs().getType() != ExpressionContext.Type.IDENTIFIER) {
                    return false;
                }
                Predicate.Type predicateType = predicate.getType();
                if (predicateType == Predicate.Type.EQ) {
                    return this.pruneEqPredicate(segment, (EqPredicate)predicate, dataSourceCache);
                }
                if (predicateType == Predicate.Type.IN) {
                    return this.pruneInPredicate(segment, (InPredicate)predicate, dataSourceCache);
                }
                if (predicateType == Predicate.Type.RANGE) {
                    return this.pruneRangePredicate(segment, (RangePredicate)predicate, dataSourceCache);
                }
                return false;
            }
        }
        throw new IllegalStateException();
    }

    private boolean pruneEqPredicate(IndexSegment segment, EqPredicate eqPredicate, Map<String, DataSource> dataSourceCache) {
        BloomFilterReader bloomFilter;
        Comparable value;
        String column = eqPredicate.getLhs().getIdentifier();
        DataSource dataSource = dataSourceCache.computeIfAbsent(column, arg_0 -> ((IndexSegment)segment).getDataSource(arg_0));
        assert (dataSource != null);
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        if (!this.checkMinMaxRange(dataSourceMetadata, value = ColumnValueSegmentPruner.convertValue(eqPredicate.getValue(), dataSourceMetadata.getDataType()))) {
            return true;
        }
        PartitionFunction partitionFunction = dataSourceMetadata.getPartitionFunction();
        if (partitionFunction != null) {
            Set partitions = dataSourceMetadata.getPartitions();
            assert (partitions != null);
            if (!partitions.contains(partitionFunction.getPartition((Object)value))) {
                return true;
            }
        }
        return (bloomFilter = dataSource.getBloomFilter()) != null && !bloomFilter.mightContain(value.toString());
    }

    private boolean pruneInPredicate(IndexSegment segment, InPredicate inPredicate, Map<String, DataSource> dataSourceCache) {
        String column = inPredicate.getLhs().getIdentifier();
        DataSource dataSource = dataSourceCache.computeIfAbsent(column, arg_0 -> ((IndexSegment)segment).getDataSource(arg_0));
        assert (dataSource != null);
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        List values = inPredicate.getValues();
        if (values.size() > this._inPredicateThreshold) {
            return false;
        }
        for (String value : values) {
            Comparable inValue = ColumnValueSegmentPruner.convertValue(value, dataSourceMetadata.getDataType());
            if (!this.checkMinMaxRange(dataSourceMetadata, inValue)) continue;
            return false;
        }
        BloomFilterReader bloomFilter = dataSource.getBloomFilter();
        if (bloomFilter != null) {
            for (String value : values) {
                if (!bloomFilter.mightContain(value)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkMinMaxRange(DataSourceMetadata dataSourceMetadata, Comparable value) {
        Comparable minValue = dataSourceMetadata.getMinValue();
        if (minValue != null && value.compareTo(minValue) < 0) {
            return false;
        }
        Comparable maxValue = dataSourceMetadata.getMaxValue();
        return maxValue == null || value.compareTo(maxValue) <= 0;
    }

    private boolean pruneRangePredicate(IndexSegment segment, RangePredicate rangePredicate, Map<String, DataSource> dataSourceCache) {
        String column = rangePredicate.getLhs().getIdentifier();
        DataSource dataSource = dataSourceCache.computeIfAbsent(column, arg_0 -> ((IndexSegment)segment).getDataSource(arg_0));
        assert (dataSource != null);
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        FieldSpec.DataType dataType = dataSourceMetadata.getDataType();
        String lowerBound = rangePredicate.getLowerBound();
        Comparable lowerBoundValue = null;
        if (!lowerBound.equals("*")) {
            lowerBoundValue = ColumnValueSegmentPruner.convertValue(lowerBound, dataType);
        }
        boolean lowerInclusive = rangePredicate.isLowerInclusive();
        String upperBound = rangePredicate.getUpperBound();
        Comparable upperBoundValue = null;
        if (!upperBound.equals("*")) {
            upperBoundValue = ColumnValueSegmentPruner.convertValue(upperBound, dataType);
        }
        boolean upperInclusive = rangePredicate.isUpperInclusive();
        if (lowerBoundValue != null && upperBoundValue != null && (lowerInclusive && upperInclusive ? lowerBoundValue.compareTo(upperBoundValue) > 0 : lowerBoundValue.compareTo(upperBoundValue) >= 0)) {
            return true;
        }
        Comparable minValue = dataSourceMetadata.getMinValue();
        if (minValue != null && upperBoundValue != null && (upperInclusive ? upperBoundValue.compareTo(minValue) < 0 : upperBoundValue.compareTo(minValue) <= 0)) {
            return true;
        }
        Comparable maxValue = dataSourceMetadata.getMaxValue();
        return maxValue != null && lowerBoundValue != null && (lowerInclusive ? lowerBoundValue.compareTo(maxValue) > 0 : lowerBoundValue.compareTo(maxValue) >= 0);
    }

    private static Comparable convertValue(String stringValue, FieldSpec.DataType dataType) {
        try {
            return dataType.convertInternal(stringValue);
        }
        catch (Exception e) {
            throw new BadQueryRequestException((Throwable)e);
        }
    }
}

