/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.response.broker.SelectionResults;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.query.aggregation.function.DistinctAggregationFunction;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.core.util.QueryOptionsUtils;

public class DistinctDataTableReducer
implements DataTableReducer {
    private final DistinctAggregationFunction _distinctAggregationFunction;
    private final boolean _responseFormatSql;

    DistinctDataTableReducer(QueryContext queryContext, DistinctAggregationFunction distinctAggregationFunction) {
        this._distinctAggregationFunction = distinctAggregationFunction;
        this._responseFormatSql = QueryOptionsUtils.isResponseFormatSQL(queryContext.getQueryOptions());
    }

    @Override
    public void reduceAndSetResults(String tableName, DataSchema dataSchema, Map<ServerRoutingInstance, DataTable> dataTableMap, BrokerResponseNative brokerResponseNative, DataTableReducerContext reducerContext, BrokerMetrics brokerMetrics) {
        ArrayList<DistinctTable> nonEmptyDistinctTables = new ArrayList<DistinctTable>(dataTableMap.size());
        for (DataTable dataTable : dataTableMap.values()) {
            DistinctTable distinctTable = (DistinctTable)dataTable.getObject(0, 0);
            if (distinctTable.isEmpty()) continue;
            nonEmptyDistinctTables.add(distinctTable);
        }
        if (nonEmptyDistinctTables.isEmpty()) {
            String[] columns = this._distinctAggregationFunction.getColumns();
            if (this._responseFormatSql) {
                int numColumns = columns.length;
                Object[] columnDataTypes = new DataSchema.ColumnDataType[numColumns];
                Arrays.fill(columnDataTypes, DataSchema.ColumnDataType.STRING);
                brokerResponseNative.setResultTable(new ResultTable(new DataSchema(columns, (DataSchema.ColumnDataType[])columnDataTypes), Collections.emptyList()));
            } else {
                brokerResponseNative.setSelectionResults(new SelectionResults(Arrays.asList(columns), Collections.emptyList()));
            }
        } else {
            DistinctTable mainDistinctTable = new DistinctTable(((DistinctTable)nonEmptyDistinctTables.get(0)).getDataSchema(), this._distinctAggregationFunction.getOrderByExpressions(), this._distinctAggregationFunction.getLimit());
            for (DistinctTable distinctTable : nonEmptyDistinctTables) {
                mainDistinctTable.mergeTable(distinctTable);
            }
            if (this._responseFormatSql) {
                brokerResponseNative.setResultTable(this.reduceToResultTable(mainDistinctTable));
            } else {
                brokerResponseNative.setSelectionResults(this.reduceToSelectionResult(mainDistinctTable));
            }
        }
    }

    private SelectionResults reduceToSelectionResult(DistinctTable distinctTable) {
        ArrayList<Serializable[]> rows = new ArrayList<Serializable[]>(distinctTable.size());
        DataSchema dataSchema = distinctTable.getDataSchema();
        DataSchema.ColumnDataType[] columnDataTypes = dataSchema.getColumnDataTypes();
        int numColumns = columnDataTypes.length;
        Iterator<Record> iterator = distinctTable.getFinalResult();
        while (iterator.hasNext()) {
            Object[] values = iterator.next().getValues();
            Serializable[] row = new Serializable[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                row[i] = columnDataTypes[i].convertAndFormat(values[i]);
            }
            rows.add(row);
        }
        return new SelectionResults(Arrays.asList(dataSchema.getColumnNames()), rows);
    }

    private ResultTable reduceToResultTable(DistinctTable distinctTable) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(distinctTable.size());
        DataSchema dataSchema = distinctTable.getDataSchema();
        DataSchema.ColumnDataType[] columnDataTypes = dataSchema.getColumnDataTypes();
        int numColumns = columnDataTypes.length;
        Iterator<Record> iterator = distinctTable.getFinalResult();
        while (iterator.hasNext()) {
            Object[] values = iterator.next().getValues();
            Object[] row = new Object[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                row[i] = columnDataTypes[i].convertAndFormat(values[i]);
            }
            rows.add(row);
        }
        return new ResultTable(dataSchema, rows);
    }
}

