/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextUtils;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplainPlanDataTableReducer
implements DataTableReducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplainPlanDataTableReducer.class);
    private final QueryContext _queryContext;

    ExplainPlanDataTableReducer(QueryContext queryContext) {
        this._queryContext = queryContext;
    }

    @Override
    public void reduceAndSetResults(String tableName, DataSchema dataSchema, Map<ServerRoutingInstance, DataTable> dataTableMap, BrokerResponseNative brokerResponseNative, DataTableReducerContext reducerContext, BrokerMetrics brokerMetrics) {
        Map.Entry<ServerRoutingInstance, DataTable> entry = dataTableMap.entrySet().iterator().next();
        DataTable dataTable = entry.getValue();
        ArrayList<Object[]> reducedRows = new ArrayList<Object[]>();
        this.addBrokerReduceOperation(reducedRows);
        int numRows = dataTable.getNumberOfRows();
        for (int rowId = 0; rowId < numRows; ++rowId) {
            reducedRows.add(SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId));
        }
        ResultTable resultTable = new ResultTable(dataSchema, reducedRows);
        brokerResponseNative.setResultTable(resultTable);
    }

    private void addBrokerReduceOperation(List<Object[]> resultRows) {
        HashSet<String> postAggregations = new HashSet<String>();
        HashSet regularTransforms = new HashSet();
        QueryContextUtils.collectPostAggregations(this._queryContext, postAggregations);
        StringBuilder stringBuilder = new StringBuilder("BROKER_REDUCE").append('(');
        if (this._queryContext.getHavingFilter() != null) {
            stringBuilder.append("havingFilter").append(':').append(this._queryContext.getHavingFilter().toString()).append(',');
        }
        if (this._queryContext.getOrderByExpressions() != null) {
            stringBuilder.append("sort").append(':').append(this._queryContext.getOrderByExpressions().toString()).append(',');
        }
        stringBuilder.append("limit:").append(this._queryContext.getLimit());
        if (!postAggregations.isEmpty()) {
            stringBuilder.append(",postAggregations:");
            int count = 0;
            for (String func : postAggregations) {
                if (count == postAggregations.size() - 1) {
                    stringBuilder.append(func);
                } else {
                    stringBuilder.append(func).append(", ");
                }
                ++count;
            }
        }
        String brokerReduceNode = stringBuilder.append(')').toString();
        Object[] brokerReduceRow = new Object[]{brokerReduceNode, 0, -1};
        resultRows.add(brokerReduceRow);
    }
}

