/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.BrokerGauge;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.QueryProcessingException;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.data.table.ConcurrentIndexedTable;
import org.apache.pinot.core.data.table.IndexedTable;
import org.apache.pinot.core.data.table.Key;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.data.table.SimpleIndexedTable;
import org.apache.pinot.core.data.table.UnboundedConcurrentIndexedTable;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.reduce.HavingFilterHandler;
import org.apache.pinot.core.query.reduce.PostAggregationHandler;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.core.util.GapfillUtils;
import org.apache.pinot.core.util.GroupByUtils;
import org.apache.pinot.core.util.trace.TraceCallable;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.DateTimeGranularitySpec;

public class GapFillGroupByDataTableReducer
implements DataTableReducer {
    private static final int MIN_DATA_TABLES_FOR_CONCURRENT_REDUCE = 2;
    private final QueryContext _queryContext;
    private final AggregationFunction[] _aggregationFunctions;
    private final int _numAggregationFunctions;
    private final List<ExpressionContext> _groupByExpressions;
    private final int _numGroupByExpressions;
    private final int _numColumns;
    private final DateTimeGranularitySpec _dateTimeGranularity;
    private final DateTimeFormatSpec _dateTimeFormatter;
    private final long _startMs;
    private final long _endMs;
    private final Set<Key> _groupByKeys;
    private final Map<Key, Object[]> _previousByGroupKey;
    private final int _numOfGroupByKeys;
    private final List<Integer> _groupByKeyIndexes;
    private final boolean[] _isGroupBySelections;
    private int _timeBucketIndex = -1;

    GapFillGroupByDataTableReducer(QueryContext queryContext) {
        List args;
        Preconditions.checkArgument((queryContext.getBrokerRequest().getPinotQuery() != null ? 1 : 0) != 0, (Object)"GapFill can only be applied to sql query");
        this._queryContext = queryContext;
        this._aggregationFunctions = queryContext.getAggregationFunctions();
        assert (this._aggregationFunctions != null);
        this._numAggregationFunctions = this._aggregationFunctions.length;
        this._groupByExpressions = queryContext.getGroupByExpressions();
        assert (this._groupByExpressions != null);
        this._numGroupByExpressions = this._groupByExpressions.size();
        this._numColumns = this._numAggregationFunctions + this._numGroupByExpressions;
        ExpressionContext gapFillSelection = null;
        for (ExpressionContext expressionContext : this._queryContext.getSelectExpressions()) {
            if (!GapfillUtils.isPostAggregateGapfill(expressionContext)) continue;
            gapFillSelection = expressionContext;
            break;
        }
        Preconditions.checkArgument(((args = gapFillSelection.getFunction().getArguments()).size() == 5 ? 1 : 0) != 0, (Object)"PostAggregateGapFill does not have correct number of arguments.");
        Preconditions.checkArgument((((ExpressionContext)args.get(1)).getLiteral() != null ? 1 : 0) != 0, (Object)"The second argument of PostAggregateGapFill should be TimeFormatter.");
        Preconditions.checkArgument((((ExpressionContext)args.get(2)).getLiteral() != null ? 1 : 0) != 0, (Object)"The third argument of PostAggregateGapFill should be start time.");
        Preconditions.checkArgument((((ExpressionContext)args.get(3)).getLiteral() != null ? 1 : 0) != 0, (Object)"The fourth argument of PostAggregateGapFill should be end time.");
        Preconditions.checkArgument((((ExpressionContext)args.get(4)).getLiteral() != null ? 1 : 0) != 0, (Object)"The fifth argument of PostAggregateGapFill should be time bucket size.");
        boolean orderByTimeBucket = false;
        if (this._queryContext.getOrderByExpressions() != null && !this._queryContext.getOrderByExpressions().isEmpty()) {
            OrderByExpressionContext firstOrderByExpression = this._queryContext.getOrderByExpressions().get(0);
            orderByTimeBucket = firstOrderByExpression.isAsc() && firstOrderByExpression.getExpression().equals((Object)gapFillSelection);
        }
        Preconditions.checkArgument((boolean)orderByTimeBucket, (Object)"PostAggregateGapFill does not work if the time bucket is not ordered.");
        this._dateTimeFormatter = new DateTimeFormatSpec(((ExpressionContext)args.get(1)).getLiteral());
        this._dateTimeGranularity = new DateTimeGranularitySpec(((ExpressionContext)args.get(4)).getLiteral());
        String start = ((ExpressionContext)args.get(2)).getLiteral();
        String end = ((ExpressionContext)args.get(3)).getLiteral();
        this._startMs = this.truncate(this._dateTimeFormatter.fromFormatToMillis(start));
        this._endMs = this.truncate(this._dateTimeFormatter.fromFormatToMillis(end));
        this._groupByKeys = new HashSet<Key>();
        this._previousByGroupKey = new HashMap<Key, Object[]>();
        this._numOfGroupByKeys = this._queryContext.getGroupByExpressions().size() - 1;
        this._groupByKeyIndexes = new ArrayList<Integer>();
        this._isGroupBySelections = new boolean[this._queryContext.getSelectExpressions().size()];
        block1: for (ExpressionContext expressionContext : this._groupByExpressions) {
            int i;
            if (GapfillUtils.isPostAggregateGapfill(expressionContext)) {
                for (i = 0; i < this._queryContext.getSelectExpressions().size(); ++i) {
                    if (!expressionContext.equals((Object)this._queryContext.getSelectExpressions().get(i))) continue;
                    this._timeBucketIndex = i;
                    this._isGroupBySelections[i] = true;
                    continue block1;
                }
                continue;
            }
            for (i = 0; i < this._queryContext.getSelectExpressions().size(); ++i) {
                if (!expressionContext.equals((Object)this._queryContext.getSelectExpressions().get(i))) continue;
                this._groupByKeyIndexes.add(i);
                this._isGroupBySelections[i] = true;
                continue block1;
            }
        }
        Preconditions.checkArgument((this._timeBucketIndex >= 0 ? 1 : 0) != 0, (Object)"There is no time bucket.");
    }

    private long truncate(long epoch) {
        int sz = this._dateTimeGranularity.getSize();
        return epoch / (long)sz * (long)sz;
    }

    @Override
    public void reduceAndSetResults(String tableName, DataSchema dataSchema, Map<ServerRoutingInstance, DataTable> dataTableMap, BrokerResponseNative brokerResponseNative, DataTableReducerContext reducerContext, BrokerMetrics brokerMetrics) {
        assert (dataSchema != null);
        Collection<DataTable> dataTables = dataTableMap.values();
        try {
            this.setSQLGroupByInResultTable(brokerResponseNative, dataSchema, dataTables, reducerContext, tableName, brokerMetrics);
        }
        catch (TimeoutException e) {
            brokerResponseNative.getProcessingExceptions().add(new QueryProcessingException(400, e.getMessage()));
        }
        int resultSize = brokerResponseNative.getResultTable().getRows().size();
        if (brokerMetrics != null && resultSize > 0) {
            brokerMetrics.addMeteredTableValue(tableName, (AbstractMetrics.Meter)BrokerMeter.GROUP_BY_SIZE, (long)resultSize);
        }
    }

    private Key constructGroupKeys(Object[] row) {
        Object[] groupKeys = new Object[this._numOfGroupByKeys];
        for (int i = 0; i < this._numOfGroupByKeys; ++i) {
            groupKeys[i] = row[this._groupByKeyIndexes.get(i)];
        }
        return new Key(groupKeys);
    }

    private void setSQLGroupByInResultTable(BrokerResponseNative brokerResponseNative, DataSchema dataSchema, Collection<DataTable> dataTables, DataTableReducerContext reducerContext, String rawTableName, BrokerMetrics brokerMetrics) throws TimeoutException {
        IndexedTable indexedTable = this.getIndexedTable(dataSchema, dataTables, reducerContext);
        if (brokerMetrics != null) {
            brokerMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)BrokerMeter.NUM_RESIZES, (long)indexedTable.getNumResizes());
            brokerMetrics.addValueToTableGauge(rawTableName, (AbstractMetrics.Gauge)BrokerGauge.RESIZE_TIME_MS, indexedTable.getResizeTimeMs());
        }
        DataSchema prePostAggregationDataSchema = this.getPrePostAggregationDataSchema(dataSchema);
        DataSchema.ColumnDataType[] columnDataTypes = prePostAggregationDataSchema.getColumnDataTypes();
        PostAggregationHandler postAggregationHandler = new PostAggregationHandler(this._queryContext, prePostAggregationDataSchema);
        DataSchema resultDataSchema = postAggregationHandler.getResultDataSchema();
        DataSchema.ColumnDataType[] resultColumnDataTypes = resultDataSchema.getColumnDataTypes();
        Iterator<Record> sortedIterator = indexedTable.iterator();
        while (sortedIterator.hasNext()) {
            Object[] row = sortedIterator.next().getValues();
            this.extractFinalAggregationResults(row);
            for (int i = 0; i < columnDataTypes.length; ++i) {
                row[i] = columnDataTypes[i].convert(row[i]);
            }
            Object[] resultRow = postAggregationHandler.getResult(row);
            for (int i = 0; i < resultColumnDataTypes.length; ++i) {
                resultRow[i] = resultColumnDataTypes[i].format(resultRow[i]);
            }
            this._groupByKeys.add(this.constructGroupKeys(resultRow));
        }
        List<Object[]> gapfillResultRows = this.gapFill(indexedTable.iterator(), postAggregationHandler);
        brokerResponseNative.setResultTable(new ResultTable(resultDataSchema, gapfillResultRows));
    }

    List<Object[]> gapFill(Iterator<Record> sortedIterator, PostAggregationHandler postAggregationHandler) {
        DataSchema resultDataSchema = postAggregationHandler.getResultDataSchema();
        DataSchema.ColumnDataType[] resultColumnDataTypes = resultDataSchema.getColumnDataTypes();
        int limit = this._queryContext.getLimit();
        int numResultColumns = resultColumnDataTypes.length;
        ArrayList<Object[]> gapfillResultRows = new ArrayList<Object[]>(limit);
        long step = this._dateTimeGranularity.granularityToMillis();
        FilterContext havingFilter = this._queryContext.getHavingFilter();
        HavingFilterHandler havingFilterHandler = null;
        if (havingFilter != null) {
            havingFilterHandler = new HavingFilterHandler(havingFilter, postAggregationHandler);
        }
        Record record = null;
        long time = this._startMs;
        while (time + 2L * step <= this._endMs) {
            HashSet<Key> keys = new HashSet<Key>(this._groupByKeys);
            if (record == null && sortedIterator.hasNext()) {
                record = sortedIterator.next();
            }
            while (record != null) {
                Object[] row = record.getValues();
                Object[] resultRow = postAggregationHandler.getResult(row);
                for (int i = 0; i < resultColumnDataTypes.length; ++i) {
                    resultRow[i] = resultColumnDataTypes[i].format(resultRow[i]);
                }
                long timeCol = this._dateTimeFormatter.fromFormatToMillis(String.valueOf(resultRow[this._timeBucketIndex]));
                if (timeCol > time) break;
                if (timeCol == time) {
                    if (havingFilterHandler == null || havingFilterHandler.isMatch(row)) {
                        gapfillResultRows.add(resultRow);
                        if (gapfillResultRows.size() == limit) {
                            return gapfillResultRows;
                        }
                    }
                    Key key = this.constructGroupKeys(resultRow);
                    keys.remove(key);
                    this._previousByGroupKey.put(key, resultRow);
                }
                if (sortedIterator.hasNext()) {
                    record = sortedIterator.next();
                    continue;
                }
                record = null;
            }
            for (Key key : keys) {
                Object[] gapfillRow = new Object[numResultColumns];
                int keyIndex = 0;
                for (int i = 0; i < this._isGroupBySelections.length; ++i) {
                    if (this._isGroupBySelections[i]) {
                        if (i == this._timeBucketIndex) {
                            if (resultColumnDataTypes[i] == DataSchema.ColumnDataType.LONG) {
                                gapfillRow[this._timeBucketIndex] = Long.valueOf(this._dateTimeFormatter.fromMillisToFormat(time));
                                continue;
                            }
                            gapfillRow[this._timeBucketIndex] = this._dateTimeFormatter.fromMillisToFormat(time);
                            continue;
                        }
                        gapfillRow[i] = key.getValues()[keyIndex++];
                        continue;
                    }
                    gapfillRow[i] = this.getFillValue(i, key, resultColumnDataTypes[i]);
                }
                if (havingFilterHandler != null && !havingFilterHandler.isMatch(gapfillRow)) continue;
                gapfillResultRows.add(gapfillRow);
                if (gapfillResultRows.size() != limit) continue;
                return gapfillResultRows;
            }
            time += step;
        }
        return gapfillResultRows;
    }

    Object getFillValue(int columIndex, Object key, DataSchema.ColumnDataType dataType) {
        ExpressionContext expressionContext = this._queryContext.getSelectExpressions().get(columIndex);
        if (expressionContext.getFunction() != null && GapfillUtils.isFill(expressionContext)) {
            List args = expressionContext.getFunction().getArguments();
            if (((ExpressionContext)args.get(1)).getLiteral() == null) {
                throw new UnsupportedOperationException("Wrong Sql.");
            }
            GapfillUtils.FillType fillType = GapfillUtils.FillType.valueOf(((ExpressionContext)args.get(1)).getLiteral());
            if (fillType == GapfillUtils.FillType.FILL_DEFAULT_VALUE) {
                return GapfillUtils.getDefaultValue(dataType);
            }
            if (fillType == GapfillUtils.FillType.FILL_PREVIOUS_VALUE) {
                Object[] row = this._previousByGroupKey.get(key);
                if (row != null) {
                    return row[columIndex];
                }
                return GapfillUtils.getDefaultValue(dataType);
            }
            throw new UnsupportedOperationException("unsupported fill type.");
        }
        return GapfillUtils.getDefaultValue(dataType);
    }

    private void extractFinalAggregationResults(Object[] row) {
        for (int i = 0; i < this._numAggregationFunctions; ++i) {
            int valueIndex = i + this._numGroupByExpressions;
            row[valueIndex] = this._aggregationFunctions[i].extractFinalResult(row[valueIndex]);
        }
    }

    private DataSchema getPrePostAggregationDataSchema(DataSchema dataSchema) {
        String[] columnNames = dataSchema.getColumnNames();
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[this._numColumns];
        System.arraycopy(dataSchema.getColumnDataTypes(), 0, columnDataTypes, 0, this._numGroupByExpressions);
        for (int i = 0; i < this._numAggregationFunctions; ++i) {
            columnDataTypes[i + this._numGroupByExpressions] = this._aggregationFunctions[i].getFinalResultColumnType();
        }
        return new DataSchema(columnNames, columnDataTypes);
    }

    private IndexedTable getIndexedTable(DataSchema dataSchema, Collection<DataTable> dataTablesToReduce, DataTableReducerContext reducerContext) throws TimeoutException {
        int i;
        long start = System.currentTimeMillis();
        int numDataTables = dataTablesToReduce.size();
        int numReduceThreadsToUse = this.getNumReduceThreadsToUse(numDataTables, reducerContext.getMaxReduceThreadsPerQuery());
        int limit = this._queryContext.getLimit();
        int trimSize = GroupByUtils.getTableCapacity(limit);
        int resultSize = this._queryContext.getHavingFilter() != null ? trimSize : limit;
        int trimThreshold = reducerContext.getGroupByTrimThreshold();
        final IndexedTable indexedTable = numReduceThreadsToUse <= 1 ? new SimpleIndexedTable(dataSchema, this._queryContext, resultSize, trimSize, trimThreshold) : (trimThreshold >= 1000000000 ? new UnboundedConcurrentIndexedTable(dataSchema, this._queryContext, resultSize) : new ConcurrentIndexedTable(dataSchema, this._queryContext, resultSize, trimSize, trimThreshold));
        ArrayList<DataTable> dataTables = new ArrayList<DataTable>(dataTablesToReduce);
        ArrayList reduceGroups = new ArrayList(numReduceThreadsToUse);
        for (i = 0; i < numReduceThreadsToUse; ++i) {
            reduceGroups.add(new ArrayList());
        }
        for (i = 0; i < numDataTables; ++i) {
            ((List)reduceGroups.get(i % numReduceThreadsToUse)).add(dataTables.get(i));
        }
        final DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        long timeOutMs = reducerContext.getReduceTimeOutMs() - (System.currentTimeMillis() - start);
        try {
            reducerContext.getExecutorService().invokeAll(reduceGroups.stream().map(reduceGroup -> new TraceCallable<Void>(){

                @Override
                public Void callJob() throws Exception {
                    for (DataTable dataTable : reduceGroup) {
                        int numRows = dataTable.getNumberOfRows();
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            Object[] values = new Object[GapFillGroupByDataTableReducer.this._numColumns];
                            block11: for (int colId = 0; colId < GapFillGroupByDataTableReducer.this._numColumns; ++colId) {
                                switch (storedColumnDataTypes[colId]) {
                                    case INT: {
                                        values[colId] = dataTable.getInt(rowId, colId);
                                        continue block11;
                                    }
                                    case LONG: {
                                        values[colId] = dataTable.getLong(rowId, colId);
                                        continue block11;
                                    }
                                    case FLOAT: {
                                        values[colId] = Float.valueOf(dataTable.getFloat(rowId, colId));
                                        continue block11;
                                    }
                                    case DOUBLE: {
                                        values[colId] = dataTable.getDouble(rowId, colId);
                                        continue block11;
                                    }
                                    case STRING: {
                                        values[colId] = dataTable.getString(rowId, colId);
                                        continue block11;
                                    }
                                    case BYTES: {
                                        values[colId] = dataTable.getBytes(rowId, colId);
                                        continue block11;
                                    }
                                    case OBJECT: {
                                        values[colId] = dataTable.getObject(rowId, colId);
                                        continue block11;
                                    }
                                    default: {
                                        throw new IllegalStateException();
                                    }
                                }
                            }
                            indexedTable.upsert(new Record(values));
                        }
                    }
                    return null;
                }
            }).collect(Collectors.toList()), timeOutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new TimeoutException("Timed out in broker reduce phase.");
        }
        indexedTable.finish(true);
        return indexedTable;
    }

    private int getNumReduceThreadsToUse(int numDataTables, int maxReduceThreadsPerQuery) {
        if (numDataTables < 2) {
            return Math.min(1, numDataTables);
        }
        return Math.min(maxReduceThreadsPerQuery, numDataTables);
    }
}

