/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.BrokerGauge;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.response.broker.AggregationResult;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.GroupByResult;
import org.apache.pinot.common.response.broker.QueryProcessingException;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.data.table.ConcurrentIndexedTable;
import org.apache.pinot.core.data.table.IndexedTable;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.data.table.SimpleIndexedTable;
import org.apache.pinot.core.data.table.UnboundedConcurrentIndexedTable;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByTrimmingService;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.reduce.HavingFilterHandler;
import org.apache.pinot.core.query.reduce.PostAggregationHandler;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.core.util.GroupByUtils;
import org.apache.pinot.core.util.QueryOptionsUtils;
import org.apache.pinot.core.util.trace.TraceRunnable;

public class GroupByDataTableReducer
implements DataTableReducer {
    private static final int MIN_DATA_TABLES_FOR_CONCURRENT_REDUCE = 2;
    private final QueryContext _queryContext;
    private final AggregationFunction[] _aggregationFunctions;
    private final int _numAggregationFunctions;
    private final List<ExpressionContext> _groupByExpressions;
    private final int _numGroupByExpressions;
    private final int _numColumns;
    private final boolean _preserveType;
    private final boolean _groupByModeSql;
    private final boolean _responseFormatSql;
    private final boolean _sqlQuery;

    GroupByDataTableReducer(QueryContext queryContext) {
        this._queryContext = queryContext;
        this._aggregationFunctions = queryContext.getAggregationFunctions();
        assert (this._aggregationFunctions != null);
        this._numAggregationFunctions = this._aggregationFunctions.length;
        this._groupByExpressions = queryContext.getGroupByExpressions();
        assert (this._groupByExpressions != null);
        this._numGroupByExpressions = this._groupByExpressions.size();
        this._numColumns = this._numAggregationFunctions + this._numGroupByExpressions;
        Map<String, String> queryOptions = queryContext.getQueryOptions();
        this._preserveType = QueryOptionsUtils.isPreserveType(queryOptions);
        this._groupByModeSql = QueryOptionsUtils.isGroupByModeSQL(queryOptions);
        this._responseFormatSql = QueryOptionsUtils.isResponseFormatSQL(queryOptions);
        this._sqlQuery = queryContext.getBrokerRequest().getPinotQuery() != null;
    }

    @Override
    public void reduceAndSetResults(String tableName, DataSchema dataSchema, Map<ServerRoutingInstance, DataTable> dataTableMap, BrokerResponseNative brokerResponseNative, DataTableReducerContext reducerContext, BrokerMetrics brokerMetrics) {
        assert (dataSchema != null);
        int resultSize = 0;
        Collection<DataTable> dataTables = dataTableMap.values();
        if (this._groupByModeSql) {
            if (this._responseFormatSql) {
                try {
                    this.setSQLGroupByInResultTable(brokerResponseNative, dataSchema, dataTables, reducerContext, tableName, brokerMetrics);
                }
                catch (TimeoutException e) {
                    brokerResponseNative.getProcessingExceptions().add(new QueryProcessingException(400, e.getMessage()));
                }
                resultSize = brokerResponseNative.getResultTable().getRows().size();
            } else {
                try {
                    this.setSQLGroupByInAggregationResults(brokerResponseNative, dataSchema, dataTables, reducerContext);
                }
                catch (TimeoutException e) {
                    brokerResponseNative.getProcessingExceptions().add(new QueryProcessingException(400, e.getMessage()));
                }
                if (!brokerResponseNative.getAggregationResults().isEmpty()) {
                    resultSize = ((AggregationResult)brokerResponseNative.getAggregationResults().get(0)).getGroupByResult().size();
                }
            }
        } else {
            this.setGroupByResults(brokerResponseNative, dataTables);
            if (this._responseFormatSql) {
                resultSize = brokerResponseNative.getResultTable().getRows().size();
            } else if (!brokerResponseNative.getAggregationResults().isEmpty()) {
                resultSize = ((AggregationResult)brokerResponseNative.getAggregationResults().get(0)).getGroupByResult().size();
            }
        }
        if (brokerMetrics != null && resultSize > 0) {
            brokerMetrics.addMeteredTableValue(tableName, (AbstractMetrics.Meter)BrokerMeter.GROUP_BY_SIZE, (long)resultSize);
        }
    }

    private void setSQLGroupByInResultTable(BrokerResponseNative brokerResponseNative, DataSchema dataSchema, Collection<DataTable> dataTables, DataTableReducerContext reducerContext, String rawTableName, BrokerMetrics brokerMetrics) throws TimeoutException {
        IndexedTable indexedTable = this.getIndexedTable(dataSchema, dataTables, reducerContext);
        if (brokerMetrics != null) {
            brokerMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)BrokerMeter.NUM_RESIZES, (long)indexedTable.getNumResizes());
            brokerMetrics.addValueToTableGauge(rawTableName, (AbstractMetrics.Gauge)BrokerGauge.RESIZE_TIME_MS, indexedTable.getResizeTimeMs());
        }
        Iterator<Record> sortedIterator = indexedTable.iterator();
        DataSchema prePostAggregationDataSchema = this.getPrePostAggregationDataSchema(dataSchema);
        DataSchema.ColumnDataType[] columnDataTypes = prePostAggregationDataSchema.getColumnDataTypes();
        int numColumns = columnDataTypes.length;
        int limit = this._queryContext.getLimit();
        ArrayList<Object[]> rows = new ArrayList<Object[]>(limit);
        if (this._sqlQuery) {
            Object[] row;
            PostAggregationHandler postAggregationHandler = new PostAggregationHandler(this._queryContext, prePostAggregationDataSchema);
            FilterContext havingFilter = this._queryContext.getHavingFilter();
            if (havingFilter != null) {
                HavingFilterHandler havingFilterHandler = new HavingFilterHandler(havingFilter, postAggregationHandler);
                while (rows.size() < limit && sortedIterator.hasNext()) {
                    row = sortedIterator.next().getValues();
                    this.extractFinalAggregationResults(row);
                    for (int i = 0; i < numColumns; ++i) {
                        row[i] = columnDataTypes[i].convert(row[i]);
                    }
                    if (!havingFilterHandler.isMatch(row)) continue;
                    rows.add(row);
                }
            } else {
                for (int i = 0; i < limit && sortedIterator.hasNext(); ++i) {
                    row = sortedIterator.next().getValues();
                    this.extractFinalAggregationResults(row);
                    for (int j = 0; j < numColumns; ++j) {
                        row[j] = columnDataTypes[j].convert(row[j]);
                    }
                    rows.add(row);
                }
            }
            DataSchema resultDataSchema = postAggregationHandler.getResultDataSchema();
            DataSchema.ColumnDataType[] resultColumnDataTypes = resultDataSchema.getColumnDataTypes();
            int numResultColumns = resultColumnDataTypes.length;
            int numResultRows = rows.size();
            ArrayList<Object[]> resultRows = new ArrayList<Object[]>(numResultRows);
            for (Object[] row2 : rows) {
                Object[] resultRow = postAggregationHandler.getResult(row2);
                for (int i = 0; i < numResultColumns; ++i) {
                    resultRow[i] = resultColumnDataTypes[i].format(resultRow[i]);
                }
                resultRows.add(resultRow);
            }
            brokerResponseNative.setResultTable(new ResultTable(resultDataSchema, resultRows));
        } else {
            for (int i = 0; i < limit && sortedIterator.hasNext(); ++i) {
                Object[] row = sortedIterator.next().getValues();
                this.extractFinalAggregationResults(row);
                for (int j = 0; j < numColumns; ++j) {
                    row[j] = columnDataTypes[j].convertAndFormat(row[j]);
                }
                rows.add(row);
            }
            brokerResponseNative.setResultTable(new ResultTable(prePostAggregationDataSchema, rows));
        }
    }

    private void extractFinalAggregationResults(Object[] row) {
        for (int i = 0; i < this._numAggregationFunctions; ++i) {
            int valueIndex = i + this._numGroupByExpressions;
            row[valueIndex] = this._aggregationFunctions[i].extractFinalResult(row[valueIndex]);
        }
    }

    private DataSchema getPrePostAggregationDataSchema(DataSchema dataSchema) {
        String[] columnNames = dataSchema.getColumnNames();
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[this._numColumns];
        System.arraycopy(dataSchema.getColumnDataTypes(), 0, columnDataTypes, 0, this._numGroupByExpressions);
        for (int i = 0; i < this._numAggregationFunctions; ++i) {
            columnDataTypes[i + this._numGroupByExpressions] = this._aggregationFunctions[i].getFinalResultColumnType();
        }
        return new DataSchema(columnNames, columnDataTypes);
    }

    private IndexedTable getIndexedTable(DataSchema dataSchema, Collection<DataTable> dataTablesToReduce, DataTableReducerContext reducerContext) throws TimeoutException {
        int i;
        long start = System.currentTimeMillis();
        int numDataTables = dataTablesToReduce.size();
        int numReduceThreadsToUse = this.getNumReduceThreadsToUse(numDataTables, reducerContext.getMaxReduceThreadsPerQuery());
        int limit = this._queryContext.getLimit();
        int trimSize = GroupByUtils.getTableCapacity(limit);
        int resultSize = this._queryContext.getHavingFilter() != null ? trimSize : limit;
        int trimThreshold = reducerContext.getGroupByTrimThreshold();
        final IndexedTable indexedTable = numReduceThreadsToUse <= 1 ? new SimpleIndexedTable(dataSchema, this._queryContext, resultSize, trimSize, trimThreshold) : (trimThreshold >= 1000000000 ? new UnboundedConcurrentIndexedTable(dataSchema, this._queryContext, resultSize) : new ConcurrentIndexedTable(dataSchema, this._queryContext, resultSize, trimSize, trimThreshold));
        Future[] futures = new Future[numDataTables];
        final CountDownLatch countDownLatch = new CountDownLatch(numDataTables);
        ArrayList<DataTable> dataTables = new ArrayList<DataTable>(dataTablesToReduce);
        ArrayList reduceGroups = new ArrayList(numReduceThreadsToUse);
        for (i = 0; i < numReduceThreadsToUse; ++i) {
            reduceGroups.add(new ArrayList());
        }
        for (i = 0; i < numDataTables; ++i) {
            ((List)reduceGroups.get(i % numReduceThreadsToUse)).add(dataTables.get(i));
        }
        int cnt = 0;
        final DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        for (final List list : reduceGroups) {
            futures[cnt++] = reducerContext.getExecutorService().submit(new TraceRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runJob() {
                    for (DataTable dataTable : list) {
                        int numRows = dataTable.getNumberOfRows();
                        try {
                            for (int rowId = 0; rowId < numRows; ++rowId) {
                                Object[] values = new Object[GroupByDataTableReducer.this._numColumns];
                                block14: for (int colId = 0; colId < GroupByDataTableReducer.this._numColumns; ++colId) {
                                    switch (storedColumnDataTypes[colId]) {
                                        case INT: {
                                            values[colId] = dataTable.getInt(rowId, colId);
                                            continue block14;
                                        }
                                        case LONG: {
                                            values[colId] = dataTable.getLong(rowId, colId);
                                            continue block14;
                                        }
                                        case FLOAT: {
                                            values[colId] = Float.valueOf(dataTable.getFloat(rowId, colId));
                                            continue block14;
                                        }
                                        case DOUBLE: {
                                            values[colId] = dataTable.getDouble(rowId, colId);
                                            continue block14;
                                        }
                                        case STRING: {
                                            values[colId] = dataTable.getString(rowId, colId);
                                            continue block14;
                                        }
                                        case BYTES: {
                                            values[colId] = dataTable.getBytes(rowId, colId);
                                            continue block14;
                                        }
                                        case OBJECT: {
                                            values[colId] = dataTable.getObject(rowId, colId);
                                            continue block14;
                                        }
                                        default: {
                                            throw new IllegalStateException();
                                        }
                                    }
                                }
                                indexedTable.upsert(new Record(values));
                            }
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    }
                }
            });
        }
        try {
            long timeOutMs = reducerContext.getReduceTimeOutMs() - (System.currentTimeMillis() - start);
            countDownLatch.await(timeOutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
            throw new TimeoutException("Timed out in broker reduce phase.");
        }
        indexedTable.finish(true);
        return indexedTable;
    }

    private int getNumReduceThreadsToUse(int numDataTables, int maxReduceThreadsPerQuery) {
        if (numDataTables < 2) {
            return Math.min(1, numDataTables);
        }
        return Math.min(maxReduceThreadsPerQuery, numDataTables);
    }

    private void setSQLGroupByInAggregationResults(BrokerResponseNative brokerResponseNative, DataSchema dataSchema, Collection<DataTable> dataTables, DataTableReducerContext reducerContext) throws TimeoutException {
        int idx;
        ArrayList<String> groupByColumns = new ArrayList<String>(this._numGroupByExpressions);
        for (idx = 0; idx < this._numGroupByExpressions; ++idx) {
            groupByColumns.add(dataSchema.getColumnName(idx));
        }
        ArrayList<String> aggregationColumns = new ArrayList<String>(this._numAggregationFunctions);
        ArrayList groupByResults = new ArrayList(this._numAggregationFunctions);
        while (idx < this._numColumns) {
            aggregationColumns.add(dataSchema.getColumnName(idx));
            groupByResults.add(new ArrayList());
            ++idx;
        }
        if (!dataTables.isEmpty()) {
            IndexedTable indexedTable = this.getIndexedTable(dataSchema, dataTables, reducerContext);
            int limit = this._queryContext.getLimit();
            Iterator<Record> sortedIterator = indexedTable.iterator();
            for (int numRows = 0; numRows < limit && sortedIterator.hasNext(); ++numRows) {
                int index;
                Record nextRecord = sortedIterator.next();
                Object[] values = nextRecord.getValues();
                ArrayList<String> group = new ArrayList<String>(this._numGroupByExpressions);
                for (index = 0; index < this._numGroupByExpressions; ++index) {
                    group.add(values[index].toString());
                }
                int aggNum = 0;
                while (index < this._numColumns) {
                    Object serializableValue = this.getSerializableValue(this._aggregationFunctions[aggNum].extractFinalResult(values[index]));
                    if (!this._preserveType) {
                        serializableValue = AggregationFunctionUtils.formatValue(serializableValue);
                    }
                    GroupByResult groupByResult = new GroupByResult();
                    groupByResult.setGroup(group);
                    groupByResult.setValue((Serializable)serializableValue);
                    ((List)groupByResults.get(aggNum)).add(groupByResult);
                    ++index;
                    ++aggNum;
                }
            }
        }
        ArrayList<AggregationResult> aggregationResults = new ArrayList<AggregationResult>(this._numAggregationFunctions);
        for (int i = 0; i < this._numAggregationFunctions; ++i) {
            AggregationResult aggregationResult = new AggregationResult((List)groupByResults.get(i), groupByColumns, (String)aggregationColumns.get(i));
            aggregationResults.add(aggregationResult);
        }
        brokerResponseNative.setAggregationResults(aggregationResults);
    }

    private Serializable getSerializableValue(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        return value.toString();
    }

    private DataSchema getPQLResultTableSchema(AggregationFunction aggregationFunction) {
        String[] columnNames = new String[this._numColumns];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[this._numColumns];
        for (int i = 0; i < this._numGroupByExpressions; ++i) {
            columnNames[i] = this._groupByExpressions.get(i).toString();
            columnDataTypes[i] = DataSchema.ColumnDataType.STRING;
        }
        columnNames[this._numGroupByExpressions] = aggregationFunction.getResultColumnName();
        columnDataTypes[this._numGroupByExpressions] = aggregationFunction.getFinalResultColumnType();
        return new DataSchema(columnNames, columnDataTypes);
    }

    private void setGroupByResults(BrokerResponseNative brokerResponseNative, Collection<DataTable> dataTables) {
        String[] columnNames = new String[this._numAggregationFunctions];
        Map[] intermediateResultMaps = new Map[this._numAggregationFunctions];
        for (DataTable dataTable : dataTables) {
            for (int i = 0; i < this._numAggregationFunctions; ++i) {
                if (columnNames[i] == null) {
                    columnNames[i] = dataTable.getString(i, 0);
                    intermediateResultMaps[i] = (Map)dataTable.getObject(i, 1);
                    continue;
                }
                this.mergeResultMap(intermediateResultMaps[i], (Map)dataTable.getObject(i, 1), this._aggregationFunctions[i]);
            }
        }
        Map[] finalResultMaps = new Map[this._numAggregationFunctions];
        for (int i = 0; i < this._numAggregationFunctions; ++i) {
            Map intermediateResultMap = intermediateResultMaps[i];
            HashMap finalResultMap = new HashMap();
            for (Object groupKey : intermediateResultMap.keySet()) {
                Object intermediateResult = intermediateResultMap.get(groupKey);
                finalResultMap.put((String)groupKey, this._aggregationFunctions[i].extractFinalResult(intermediateResult));
            }
            finalResultMaps[i] = finalResultMap;
        }
        AggregationGroupByTrimmingService aggregationGroupByTrimmingService = new AggregationGroupByTrimmingService(this._queryContext);
        List<GroupByResult>[] groupByResultLists = aggregationGroupByTrimmingService.trimFinalResults(finalResultMaps);
        if (this._responseFormatSql) {
            Object groupKey;
            assert (this._numAggregationFunctions == 1);
            List<GroupByResult> groupByResultList = groupByResultLists[0];
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            groupKey = groupByResultList.iterator();
            while (groupKey.hasNext()) {
                GroupByResult groupByResult = (GroupByResult)groupKey.next();
                Object[] row = new Object[this._numColumns];
                int i = 0;
                for (String column : groupByResult.getGroup()) {
                    row[i++] = column;
                }
                row[i] = groupByResult.getValue();
                rows.add(row);
            }
            DataSchema finalDataSchema = this.getPQLResultTableSchema(this._aggregationFunctions[0]);
            brokerResponseNative.setResultTable(new ResultTable(finalDataSchema, rows));
        } else {
            if (!this._preserveType) {
                for (List<GroupByResult> groupByResultList : groupByResultLists) {
                    Iterator iterator = groupByResultList.iterator();
                    while (iterator.hasNext()) {
                        GroupByResult groupByResult = (GroupByResult)iterator.next();
                        groupByResult.setValue((Serializable)((Object)AggregationFunctionUtils.formatValue(groupByResult.getValue())));
                    }
                }
            }
            ArrayList<String> groupByColumns = new ArrayList<String>(this._numGroupByExpressions);
            for (ExpressionContext groupByExpression : this._groupByExpressions) {
                groupByColumns.add(groupByExpression.toString());
            }
            ArrayList<AggregationResult> aggregationResults = new ArrayList<AggregationResult>(this._numAggregationFunctions);
            for (int i = 0; i < this._numAggregationFunctions; ++i) {
                aggregationResults.add(new AggregationResult(groupByResultLists[i], groupByColumns, columnNames[i]));
            }
            brokerResponseNative.setAggregationResults(aggregationResults);
        }
    }

    private void mergeResultMap(Map<String, Object> mergedResultMap, Map<String, Object> resultMapToMerge, AggregationFunction aggregationFunction) {
        for (Map.Entry<String, Object> entry : resultMapToMerge.entrySet()) {
            String groupKey = entry.getKey();
            Object resultToMerge = entry.getValue();
            mergedResultMap.compute(groupKey, (k, v) -> {
                if (v == null) {
                    return resultToMerge;
                }
                return aggregationFunction.merge(v, resultToMerge);
            });
        }
    }
}

