/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.RequestContextUtils;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.postaggregation.PostAggregationFunction;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.util.GapfillUtils;

public class PostAggregationHandler {
    private final Map<Pair<FunctionContext, FilterContext>, Integer> _filteredAggregationsIndexMap;
    private final int _numGroupByExpressions;
    private final Map<ExpressionContext, Integer> _groupByExpressionIndexMap;
    private final DataSchema _dataSchema;
    private final ValueExtractor[] _valueExtractors;
    private final DataSchema _resultDataSchema;

    public PostAggregationHandler(QueryContext queryContext, DataSchema dataSchema) {
        this._filteredAggregationsIndexMap = queryContext.getFilteredAggregationsIndexMap();
        assert (this._filteredAggregationsIndexMap != null);
        List<ExpressionContext> groupByExpressions = queryContext.getGroupByExpressions();
        if (groupByExpressions != null) {
            this._numGroupByExpressions = groupByExpressions.size();
            this._groupByExpressionIndexMap = new HashMap<ExpressionContext, Integer>();
            for (int i = 0; i < this._numGroupByExpressions; ++i) {
                this._groupByExpressionIndexMap.put(GapfillUtils.stripGapfill(groupByExpressions.get(i)), i);
            }
        } else {
            this._numGroupByExpressions = 0;
            this._groupByExpressionIndexMap = null;
        }
        this._dataSchema = dataSchema;
        List<ExpressionContext> selectExpressions = queryContext.getSelectExpressions();
        int numSelectExpressions = selectExpressions.size();
        this._valueExtractors = new ValueExtractor[numSelectExpressions];
        String[] columnNames = new String[numSelectExpressions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numSelectExpressions];
        for (int i = 0; i < numSelectExpressions; ++i) {
            ValueExtractor valueExtractor;
            this._valueExtractors[i] = valueExtractor = this.getValueExtractor(selectExpressions.get(i));
            columnNames[i] = valueExtractor.getColumnName();
            columnDataTypes[i] = valueExtractor.getColumnDataType();
        }
        this._resultDataSchema = new DataSchema(columnNames, columnDataTypes);
    }

    public DataSchema getResultDataSchema() {
        return this._resultDataSchema;
    }

    public Object[] getResult(Object[] row) {
        int numValues = this._valueExtractors.length;
        Object[] result = new Object[numValues];
        for (int i = 0; i < numValues; ++i) {
            result[i] = this._valueExtractors[i].extract(row);
        }
        return result;
    }

    public ValueExtractor getValueExtractor(ExpressionContext expression) {
        Integer groupByExpressionIndex;
        if ((expression = GapfillUtils.stripGapfill(expression)).getType() == ExpressionContext.Type.LITERAL) {
            return new LiteralValueExtractor(expression.getLiteral());
        }
        if (this._numGroupByExpressions > 0 && (groupByExpressionIndex = this._groupByExpressionIndexMap.get(expression)) != null) {
            return new ColumnValueExtractor(groupByExpressionIndex);
        }
        FunctionContext function = expression.getFunction();
        Preconditions.checkState((function != null ? 1 : 0) != 0, (String)"Failed to find SELECT expression: %s in the GROUP-BY clause", (Object)expression);
        if (function.getType() == FunctionContext.Type.AGGREGATION) {
            return new ColumnValueExtractor(this._filteredAggregationsIndexMap.get(Pair.of((Object)function, null)) + this._numGroupByExpressions);
        }
        if (function.getType() == FunctionContext.Type.TRANSFORM && function.getFunctionName().equalsIgnoreCase("filter")) {
            FunctionContext aggregation = ((ExpressionContext)function.getArguments().get(0)).getFunction();
            ExpressionContext filterExpression = (ExpressionContext)function.getArguments().get(1);
            FilterContext filter = RequestContextUtils.getFilter((ExpressionContext)filterExpression);
            return new ColumnValueExtractor(this._filteredAggregationsIndexMap.get(Pair.of((Object)aggregation, (Object)filter)) + this._numGroupByExpressions);
        }
        return new PostAggregationValueExtractor(function);
    }

    private class PostAggregationValueExtractor
    implements ValueExtractor {
        final FunctionContext _function;
        final Object[] _arguments;
        final ValueExtractor[] _argumentExtractors;
        final PostAggregationFunction _postAggregationFunction;

        PostAggregationValueExtractor(FunctionContext function) {
            assert (function.getType() == FunctionContext.Type.TRANSFORM);
            this._function = function;
            List arguments = function.getArguments();
            int numArguments = arguments.size();
            this._arguments = new Object[numArguments];
            this._argumentExtractors = new ValueExtractor[numArguments];
            DataSchema.ColumnDataType[] argumentTypes = new DataSchema.ColumnDataType[numArguments];
            for (int i = 0; i < numArguments; ++i) {
                ValueExtractor argumentExtractor;
                ExpressionContext argument = (ExpressionContext)arguments.get(i);
                this._argumentExtractors[i] = argumentExtractor = PostAggregationHandler.this.getValueExtractor(argument);
                argumentTypes[i] = argumentExtractor.getColumnDataType();
            }
            this._postAggregationFunction = new PostAggregationFunction(function.getFunctionName(), argumentTypes);
        }

        @Override
        public String getColumnName() {
            return this._function.toString();
        }

        @Override
        public DataSchema.ColumnDataType getColumnDataType() {
            return this._postAggregationFunction.getResultType();
        }

        @Override
        public Object extract(Object[] row) {
            int numArguments = this._arguments.length;
            for (int i = 0; i < numArguments; ++i) {
                this._arguments[i] = this._argumentExtractors[i].extract(row);
            }
            return this._postAggregationFunction.invoke(this._arguments);
        }
    }

    private class ColumnValueExtractor
    implements ValueExtractor {
        final int _index;

        ColumnValueExtractor(int index) {
            this._index = index;
        }

        @Override
        public String getColumnName() {
            return PostAggregationHandler.this._dataSchema.getColumnName(this._index);
        }

        @Override
        public DataSchema.ColumnDataType getColumnDataType() {
            return PostAggregationHandler.this._dataSchema.getColumnDataType(this._index);
        }

        @Override
        public Object extract(Object[] row) {
            return row[this._index];
        }
    }

    private static class LiteralValueExtractor
    implements ValueExtractor {
        final String _literal;

        LiteralValueExtractor(String literal) {
            this._literal = literal;
        }

        @Override
        public String getColumnName() {
            return '\'' + this._literal + '\'';
        }

        @Override
        public DataSchema.ColumnDataType getColumnDataType() {
            return DataSchema.ColumnDataType.STRING;
        }

        @Override
        public Object extract(Object[] row) {
            return this._literal;
        }
    }

    public static interface ValueExtractor {
        public String getColumnName();

        public DataSchema.ColumnDataType getColumnDataType();

        public Object extract(Object[] var1);
    }
}

