/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.reduce.StreamingReducer;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.core.util.QueryOptionsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionOnlyStreamingReducer
implements StreamingReducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectionOnlyStreamingReducer.class);
    private final QueryContext _queryContext;
    private final boolean _preserveType;
    private final int _limit;
    private DataSchema _dataSchema;
    private DataTableReducerContext _dataTableReducerContext;
    private List<Object[]> _rows;

    public SelectionOnlyStreamingReducer(QueryContext queryContext) {
        this._queryContext = queryContext;
        this._limit = this._queryContext.getLimit();
        Map<String, String> queryOptions = queryContext.getQueryOptions();
        Preconditions.checkState((boolean)QueryOptionsUtils.isResponseFormatSQL(queryOptions), (Object)"only SQL response is supported");
        this._preserveType = QueryOptionsUtils.isPreserveType(queryOptions);
        this._dataSchema = null;
    }

    @Override
    public void init(DataTableReducerContext dataTableReducerContext) {
        this._dataTableReducerContext = dataTableReducerContext;
        this._rows = new ArrayList<Object[]>(Math.min(this._limit, 10000));
    }

    @Override
    public synchronized void reduce(ServerRoutingInstance key, DataTable dataTable) {
        this._dataSchema = this._dataSchema == null ? dataTable.getDataSchema() : this._dataSchema;
        this.reduceWithoutOrdering(dataTable, this._limit);
    }

    private void reduceWithoutOrdering(DataTable dataTable, int limit) {
        int numRows = dataTable.getNumberOfRows();
        for (int rowId = 0; rowId < numRows && this._rows.size() < limit; ++rowId) {
            this._rows.add(SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId));
        }
    }

    @Override
    public BrokerResponseNative seal() {
        BrokerResponseNative brokerResponseNative = new BrokerResponseNative();
        List<String> selectionColumns = SelectionOperatorUtils.getSelectionColumns(this._queryContext, this._dataSchema);
        if (this._dataSchema != null && this._rows.size() > 0) {
            brokerResponseNative.setResultTable(SelectionOperatorUtils.renderResultTableWithoutOrdering(this._rows, this._dataSchema, selectionColumns));
        } else {
            DataSchema selectionDataSchema = SelectionOperatorUtils.getResultTableDataSchema(this._dataSchema, selectionColumns);
            brokerResponseNative.setResultTable(new ResultTable(selectionDataSchema, Collections.emptyList()));
        }
        return brokerResponseNative;
    }
}

