/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.common.datatable.DataTableFactory;
import org.apache.pinot.core.query.reduce.BaseReduceService;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.reduce.ResultReducerFactory;
import org.apache.pinot.core.query.reduce.StreamingReducer;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.BrokerRequestToQueryContextConverter;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class StreamingReduceService
extends BaseReduceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingReduceService.class);

    public StreamingReduceService(PinotConfiguration config) {
        super(config);
    }

    public BrokerResponseNative reduceOnStreamResponse(BrokerRequest brokerRequest, Map<ServerRoutingInstance, Iterator<Server.ServerResponse>> serverResponseMap, long reduceTimeOutMs, @Nullable BrokerMetrics brokerMetrics) throws IOException {
        if (serverResponseMap.isEmpty()) {
            return BrokerResponseNative.empty();
        }
        PinotQuery pinotQuery = brokerRequest.getPinotQuery();
        Map queryOptions = pinotQuery != null ? pinotQuery.getQueryOptions() : brokerRequest.getQueryOptions();
        boolean enableTrace = queryOptions != null && Boolean.parseBoolean((String)queryOptions.get("trace"));
        QueryContext queryContext = BrokerRequestToQueryContextConverter.convert(brokerRequest);
        String tableName = brokerRequest.getQuerySource().getTableName();
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
        BaseReduceService.ExecutionStatsAggregator aggregator = new BaseReduceService.ExecutionStatsAggregator(enableTrace);
        DataTableReducerContext dataTableReducerContext = new DataTableReducerContext(this._reduceExecutorService, this._maxReduceThreadsPerQuery, reduceTimeOutMs, this._groupByTrimThreshold);
        StreamingReducer streamingReducer = ResultReducerFactory.getStreamingReducer(queryContext);
        streamingReducer.init(dataTableReducerContext);
        try {
            StreamingReduceService.processIterativeServerResponse(streamingReducer, this._reduceExecutorService, serverResponseMap, reduceTimeOutMs, aggregator);
        }
        catch (Exception e) {
            LOGGER.error("Unable to process streaming query response!", (Throwable)e);
            throw new IOException("Unable to process streaming query response!", e);
        }
        BrokerResponseNative brokerResponseNative = streamingReducer.seal();
        aggregator.setStats(rawTableName, brokerResponseNative, brokerMetrics);
        StreamingReduceService.updateAlias(queryContext, brokerResponseNative);
        return brokerResponseNative;
    }

    private static void processIterativeServerResponse(StreamingReducer reducer, ExecutorService executorService, Map<ServerRoutingInstance, Iterator<Server.ServerResponse>> serverResponseMap, long reduceTimeOutMs, BaseReduceService.ExecutionStatsAggregator aggregator) throws Exception {
        int cnt = 0;
        Future[] futures = new Future[serverResponseMap.size()];
        CountDownLatch countDownLatch = new CountDownLatch(serverResponseMap.size());
        for (Map.Entry<ServerRoutingInstance, Iterator<Server.ServerResponse>> entry : serverResponseMap.entrySet()) {
            futures[cnt++] = executorService.submit(() -> {
                Iterator streamingResponses = (Iterator)entry.getValue();
                try {
                    while (streamingResponses.hasNext()) {
                        Server.ServerResponse streamingResponse = (Server.ServerResponse)streamingResponses.next();
                        DataTable dataTable = DataTableFactory.getDataTable(streamingResponse.getPayload().asReadOnlyByteBuffer());
                        if (dataTable.getDataSchema() != null) {
                            reducer.reduce((ServerRoutingInstance)entry.getKey(), dataTable);
                            continue;
                        }
                        aggregator.aggregate((ServerRoutingInstance)entry.getKey(), dataTable);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to process streaming response. Failure occurred!", e);
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        try {
            countDownLatch.await(reduceTimeOutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
            throw new TimeoutException("Timed out in broker reduce phase.");
        }
    }

    @Override
    public void shutDown() {
        this._reduceExecutorService.shutdownNow();
    }
}

