/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.request;

import java.util.List;
import java.util.Map;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.InstanceRequest;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.TimerContext;
import org.apache.pinot.core.query.request.context.utils.BrokerRequestToQueryContextConverter;
import org.apache.pinot.sql.parsers.CalciteSqlCompiler;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class ServerQueryRequest {
    private static final CalciteSqlCompiler SQL_COMPILER = new CalciteSqlCompiler();
    private final long _requestId;
    private final String _brokerId;
    private final boolean _enableTrace;
    private final boolean _enableStreaming;
    private final List<String> _segmentsToQuery;
    private final QueryContext _queryContext;
    private final boolean _explain;
    private final TimerContext _timerContext;

    public ServerQueryRequest(InstanceRequest instanceRequest, ServerMetrics serverMetrics, long queryArrivalTimeMs) {
        this._requestId = instanceRequest.getRequestId();
        this._brokerId = instanceRequest.getBrokerId() != null ? instanceRequest.getBrokerId() : "unknown";
        this._enableTrace = instanceRequest.isEnableTrace();
        this._enableStreaming = false;
        this._segmentsToQuery = instanceRequest.getSearchSegments();
        BrokerRequest brokerRequest = instanceRequest.getQuery();
        this._queryContext = BrokerRequestToQueryContextConverter.convert(brokerRequest);
        this._explain = brokerRequest != null && brokerRequest.getPinotQuery() != null ? brokerRequest.getPinotQuery().isExplain() : false;
        this._timerContext = new TimerContext(this._queryContext.getTableName(), serverMetrics, queryArrivalTimeMs);
    }

    public ServerQueryRequest(Server.ServerRequest serverRequest, ServerMetrics serverMetrics) throws Exception {
        BrokerRequest brokerRequest;
        long queryArrivalTimeMs = System.currentTimeMillis();
        Map metadata = serverRequest.getMetadataMap();
        this._requestId = Long.parseLong(metadata.getOrDefault("requestId", "0"));
        this._brokerId = metadata.getOrDefault("brokerId", "unknown");
        this._enableTrace = Boolean.parseBoolean((String)metadata.get("enableTrace"));
        this._enableStreaming = Boolean.parseBoolean((String)metadata.get("enableStreaming"));
        this._segmentsToQuery = serverRequest.getSegmentsList();
        String payloadType = metadata.getOrDefault("payloadType", "sql");
        if (payloadType.equalsIgnoreCase("sql")) {
            brokerRequest = SQL_COMPILER.compileToBrokerRequest(serverRequest.getSql());
        } else if (payloadType.equalsIgnoreCase("brokerRequest")) {
            brokerRequest = new BrokerRequest();
            new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory()).deserialize((TBase)brokerRequest, serverRequest.getPayload().toByteArray());
        } else {
            throw new UnsupportedOperationException("Unsupported payloadType: " + payloadType);
        }
        this._queryContext = BrokerRequestToQueryContextConverter.convert(brokerRequest);
        this._timerContext = new TimerContext(this._queryContext.getTableName(), serverMetrics, queryArrivalTimeMs);
        this._explain = Boolean.parseBoolean((String)metadata.get("explain"));
    }

    public long getRequestId() {
        return this._requestId;
    }

    public String getBrokerId() {
        return this._brokerId;
    }

    public boolean isEnableTrace() {
        return this._enableTrace;
    }

    public boolean isEnableStreaming() {
        return this._enableStreaming;
    }

    public String getTableNameWithType() {
        return this._queryContext.getTableName();
    }

    public List<String> getSegmentsToQuery() {
        return this._segmentsToQuery;
    }

    public QueryContext getQueryContext() {
        return this._queryContext;
    }

    public TimerContext getTimerContext() {
        return this._timerContext;
    }

    public boolean isExplain() {
        return this._explain;
    }
}

