/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.request.context;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadTimer {
    private static final ThreadMXBean MX_BEAN = ManagementFactory.getThreadMXBean();
    private static final boolean IS_CURRENT_THREAD_CPU_TIME_SUPPORTED = MX_BEAN.isCurrentThreadCpuTimeSupported();
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadTimer.class);
    private static boolean _isThreadCpuTimeMeasurementEnabled = false;
    private final long _startTimeNs = _isThreadCpuTimeMeasurementEnabled ? MX_BEAN.getCurrentThreadCpuTime() : -1L;

    public static void setThreadCpuTimeMeasurementEnabled(boolean enable) {
        _isThreadCpuTimeMeasurementEnabled = enable && IS_CURRENT_THREAD_CPU_TIME_SUPPORTED;
    }

    public static boolean isThreadCpuTimeMeasurementEnabled() {
        return _isThreadCpuTimeMeasurementEnabled;
    }

    public long getThreadTimeNs() {
        return _isThreadCpuTimeMeasurementEnabled ? MX_BEAN.getCurrentThreadCpuTime() - this._startTimeNs : 0L;
    }

    static {
        LOGGER.info("Current thread cpu time measurement supported: {}", (Object)IS_CURRENT_THREAD_CPU_TIME_SUPPORTED);
    }
}

