/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.request.context.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.request.AggregationInfo;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.GroupBy;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.request.Selection;
import org.apache.pinot.common.request.SelectionSort;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.request.context.RequestContextUtils;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class BrokerRequestToQueryContextConverter {
    private BrokerRequestToQueryContextConverter() {
    }

    public static QueryContext convert(BrokerRequest brokerRequest) {
        return brokerRequest.getPinotQuery() != null ? BrokerRequestToQueryContextConverter.convertSQL(brokerRequest) : BrokerRequestToQueryContextConverter.convertPQL(brokerRequest);
    }

    private static QueryContext convertSQL(BrokerRequest brokerRequest) {
        PinotQuery pinotQuery = brokerRequest.getPinotQuery();
        List selectList = pinotQuery.getSelectList();
        ArrayList<String> aliasList = new ArrayList<String>(selectList.size());
        ArrayList<ExpressionContext> selectExpressions = new ArrayList<ExpressionContext>(selectList.size());
        Iterator iterator = selectList.iterator();
        while (iterator.hasNext()) {
            Expression expressionWithoutAlias;
            block18: {
                block17: {
                    Expression thriftExpression;
                    expressionWithoutAlias = thriftExpression = (Expression)iterator.next();
                    if (thriftExpression.getType() != ExpressionType.FUNCTION) break block17;
                    Function function = thriftExpression.getFunctionCall();
                    List operands = function.getOperands();
                    switch (function.getOperator().toUpperCase()) {
                        case "AS": {
                            expressionWithoutAlias = (Expression)operands.get(0);
                            aliasList.add(((Expression)operands.get(1)).getIdentifier().getName());
                            break;
                        }
                        case "DISTINCT": {
                            int numOperands = operands.size();
                            for (int i = 0; i < numOperands; ++i) {
                                Expression operand = (Expression)operands.get(i);
                                Function operandFunction = operand.getFunctionCall();
                                if (operandFunction != null && operandFunction.getOperator().equalsIgnoreCase("AS")) {
                                    operands.set(i, (Expression)operandFunction.getOperands().get(0));
                                    aliasList.add(((Expression)operandFunction.getOperands().get(1)).getIdentifier().getName());
                                    continue;
                                }
                                aliasList.add(null);
                            }
                            break block18;
                        }
                        default: {
                            aliasList.add(null);
                        }
                    }
                    break block18;
                }
                aliasList.add(null);
            }
            selectExpressions.add(RequestContextUtils.getExpression((Expression)expressionWithoutAlias));
        }
        FilterContext filter = null;
        Expression filterExpression = pinotQuery.getFilterExpression();
        if (filterExpression != null) {
            filter = RequestContextUtils.getFilter((Expression)filterExpression);
        }
        ArrayList<ExpressionContext> groupByExpressions = null;
        List groupByList = pinotQuery.getGroupByList();
        if (CollectionUtils.isNotEmpty((Collection)groupByList)) {
            groupByExpressions = new ArrayList<ExpressionContext>(groupByList.size());
            for (Expression thriftExpression : groupByList) {
                groupByExpressions.add(RequestContextUtils.getExpression((Expression)thriftExpression));
            }
        }
        ArrayList<OrderByExpressionContext> orderByExpressions = null;
        List orderByList = pinotQuery.getOrderByList();
        if (CollectionUtils.isNotEmpty((Collection)orderByList)) {
            orderByExpressions = new ArrayList<OrderByExpressionContext>(orderByList.size());
            HashSet<ExpressionContext> expressionSet = new HashSet<ExpressionContext>();
            for (Expression orderBy : orderByList) {
                Function thriftFunction = orderBy.getFunctionCall();
                ExpressionContext expression = RequestContextUtils.getExpression((Expression)((Expression)thriftFunction.getOperands().get(0)));
                if (!expressionSet.add(expression)) continue;
                boolean isAsc = thriftFunction.getOperator().equalsIgnoreCase("ASC");
                orderByExpressions.add(new OrderByExpressionContext(expression, isAsc));
            }
        }
        FilterContext havingFilter = null;
        Expression havingExpression = pinotQuery.getHavingExpression();
        if (havingExpression != null) {
            havingFilter = RequestContextUtils.getFilter((Expression)havingExpression);
        }
        return new QueryContext.Builder().setTableName(pinotQuery.getDataSource().getTableName()).setSelectExpressions(selectExpressions).setAliasList(aliasList).setFilter(filter).setGroupByExpressions(groupByExpressions).setOrderByExpressions(orderByExpressions).setHavingFilter(havingFilter).setLimit(pinotQuery.getLimit()).setOffset(pinotQuery.getOffset()).setQueryOptions(pinotQuery.getQueryOptions()).setDebugOptions(pinotQuery.getDebugOptions()).setBrokerRequest(brokerRequest).build();
    }

    private static QueryContext convertPQL(BrokerRequest brokerRequest) {
        ArrayList<ExpressionContext> selectExpressions;
        ArrayList<ExpressionContext> groupByExpressions = null;
        int limit = brokerRequest.getLimit();
        int offset = 0;
        Selection selections = brokerRequest.getSelections();
        if (selections != null) {
            List selectionColumns = selections.getSelectionColumns();
            selectExpressions = new ArrayList<ExpressionContext>(selectionColumns.size());
            for (String expression : selectionColumns) {
                selectExpressions.add(RequestContextUtils.getExpressionFromPQL((String)expression));
            }
            if (limit == 0) {
                limit = selections.getSize();
            }
            offset = selections.getOffset();
        } else {
            List aggregationsInfo = brokerRequest.getAggregationsInfo();
            selectExpressions = new ArrayList(aggregationsInfo.size());
            for (AggregationInfo aggregationInfo : aggregationsInfo) {
                String functionName = StringUtils.remove((String)aggregationInfo.getAggregationType(), (char)'_');
                List stringExpressions = aggregationInfo.getExpressions();
                int numArguments = stringExpressions.size();
                ArrayList<ExpressionContext> arguments = new ArrayList<ExpressionContext>(numArguments);
                if (functionName.equalsIgnoreCase(AggregationFunctionType.DISTINCT.getName())) {
                    for (String expression : stringExpressions) {
                        arguments.add(RequestContextUtils.getExpressionFromPQL((String)expression));
                    }
                } else if (functionName.equalsIgnoreCase(AggregationFunctionType.LASTWITHTIME.getName())) {
                    arguments.add(RequestContextUtils.getExpressionFromPQL((String)((String)stringExpressions.get(0))));
                    arguments.add(RequestContextUtils.getExpressionFromPQL((String)((String)stringExpressions.get(1))));
                    for (int i = 2; i < numArguments; ++i) {
                        arguments.add(ExpressionContext.forLiteral((String)((String)stringExpressions.get(i))));
                    }
                } else {
                    arguments.add(RequestContextUtils.getExpressionFromPQL((String)((String)stringExpressions.get(0))));
                    for (int i = 1; i < numArguments; ++i) {
                        arguments.add(ExpressionContext.forLiteral((String)((String)stringExpressions.get(i))));
                    }
                }
                FunctionContext function = new FunctionContext(FunctionContext.Type.AGGREGATION, functionName, arguments);
                selectExpressions.add(ExpressionContext.forFunction((FunctionContext)function));
            }
            GroupBy groupBy = brokerRequest.getGroupBy();
            if (groupBy != null) {
                List stringExpressions = groupBy.getExpressions();
                groupByExpressions = new ArrayList<ExpressionContext>(stringExpressions.size());
                for (String stringExpression : stringExpressions) {
                    groupByExpressions.add(RequestContextUtils.getExpressionFromPQL((String)stringExpression));
                }
                limit = (int)groupBy.getTopN();
            }
        }
        FilterContext filter = null;
        FilterQueryTree rootFilterQueryTree = RequestUtils.generateFilterQueryTree((BrokerRequest)brokerRequest);
        if (rootFilterQueryTree != null) {
            filter = RequestContextUtils.getFilter((FilterQueryTree)rootFilterQueryTree);
        }
        ArrayList<OrderByExpressionContext> orderByExpressions = null;
        List orderBy = brokerRequest.getOrderBy();
        if (CollectionUtils.isNotEmpty((Collection)orderBy)) {
            orderByExpressions = new ArrayList<OrderByExpressionContext>(orderBy.size());
            HashSet<ExpressionContext> expressionSet = new HashSet<ExpressionContext>();
            for (SelectionSort selectionSort : orderBy) {
                ExpressionContext expression = RequestContextUtils.getExpressionFromPQL((String)selectionSort.getColumn());
                if (!expressionSet.add(expression)) continue;
                orderByExpressions.add(new OrderByExpressionContext(expression, selectionSort.isIsAsc()));
            }
        }
        return new QueryContext.Builder().setTableName(brokerRequest.getQuerySource().getTableName()).setSelectExpressions(selectExpressions).setAliasList(Collections.emptyList()).setFilter(filter).setGroupByExpressions(groupByExpressions).setOrderByExpressions(orderByExpressions).setLimit(limit).setOffset(offset).setQueryOptions(brokerRequest.getQueryOptions()).setDebugOptions(brokerRequest.getDebugOptions()).setBrokerRequest(brokerRequest).build();
    }
}

