/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.scheduler.resources;

import com.google.common.base.Preconditions;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import org.apache.pinot.core.query.scheduler.SchedulerGroupAccountant;
import org.apache.pinot.core.query.scheduler.resources.QueryExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundedAccountingExecutor
extends QueryExecutorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoundedAccountingExecutor.class);
    private final Executor _delegateExecutor;
    private final int _bounds;
    private final Semaphore _semaphore;
    private final SchedulerGroupAccountant _accountant;

    public BoundedAccountingExecutor(Executor s, int bounds, SchedulerGroupAccountant accountant) {
        Preconditions.checkNotNull((Object)s);
        Preconditions.checkNotNull((Object)accountant);
        Preconditions.checkArgument((bounds > 0 ? 1 : 0) != 0);
        this._delegateExecutor = s;
        this._bounds = bounds;
        this._semaphore = new Semaphore(bounds);
        this._accountant = accountant;
    }

    @Override
    public void execute(Runnable command) {
        this._delegateExecutor.execute(this.toAccountingRunnable(command));
    }

    @Override
    public void releaseWorkers() {
        this._accountant.releasedReservedThreads(this._bounds);
    }

    private QueryAccountingRunnable toAccountingRunnable(Runnable runnable) {
        this.acquirePermits(1);
        return new QueryAccountingRunnable(runnable, this._semaphore, this._accountant);
    }

    private void acquirePermits(int permits) {
        try {
            this._semaphore.acquire(permits);
        }
        catch (InterruptedException e) {
            LOGGER.error("Thread interrupted while waiting for semaphore", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private class QueryAccountingRunnable
    implements Runnable {
        private final Runnable _runnable;
        private final Semaphore _semaphore;
        private final SchedulerGroupAccountant _accountant;

        QueryAccountingRunnable(Runnable r, Semaphore semaphore, SchedulerGroupAccountant accountant) {
            this._runnable = r;
            this._semaphore = semaphore;
            this._accountant = accountant;
        }

        @Override
        public void run() {
            try {
                if (this._accountant != null) {
                    this._accountant.incrementThreads();
                }
                this._runnable.run();
            }
            finally {
                if (this._accountant != null) {
                    this._accountant.decrementThreads();
                }
                this._semaphore.release();
            }
        }
    }
}

