/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.scheduler.resources;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.core.query.scheduler.SchedulerGroupAccountant;
import org.apache.pinot.core.query.scheduler.resources.QueryExecutorService;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceManager {
    private static final Logger LOGGER;
    public static final String QUERY_RUNNER_CONFIG_KEY = "query_runner_threads";
    public static final String QUERY_WORKER_CONFIG_KEY = "query_worker_threads";
    public static final int DEFAULT_QUERY_RUNNER_THREADS;
    public static final int DEFAULT_QUERY_WORKER_THREADS;
    protected static final int QUERY_RUNNER_THREAD_PRIORITY = 7;
    protected final ListeningExecutorService _queryRunners;
    protected final ListeningExecutorService _queryWorkers;
    protected final int _numQueryRunnerThreads;
    protected final int _numQueryWorkerThreads;

    public ResourceManager(PinotConfiguration config) {
        this._numQueryRunnerThreads = config.getProperty(QUERY_RUNNER_CONFIG_KEY, DEFAULT_QUERY_RUNNER_THREADS);
        this._numQueryWorkerThreads = config.getProperty(QUERY_WORKER_CONFIG_KEY, DEFAULT_QUERY_WORKER_THREADS);
        LOGGER.info("Initializing with {} query runner threads and {} worker threads", (Object)this._numQueryRunnerThreads, (Object)this._numQueryWorkerThreads);
        ThreadFactory queryRunnerFactory = new ThreadFactoryBuilder().setDaemon(false).setPriority(7).setNameFormat("pqr-%d").build();
        this._queryRunners = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this._numQueryRunnerThreads, queryRunnerFactory));
        ThreadFactory queryWorkersFactory = new ThreadFactoryBuilder().setDaemon(false).setPriority(5).setNameFormat("pqw-%d").build();
        this._queryWorkers = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this._numQueryWorkerThreads, queryWorkersFactory));
    }

    public void stop() {
        this._queryWorkers.shutdownNow();
        this._queryRunners.shutdownNow();
    }

    public final int getNumQueryRunnerThreads() {
        return this._numQueryRunnerThreads;
    }

    public final int getNumQueryWorkerThreads() {
        return this._numQueryWorkerThreads;
    }

    public final ListeningExecutorService getQueryRunners() {
        return this._queryRunners;
    }

    @VisibleForTesting
    public final ExecutorService getQueryWorkers() {
        return this._queryWorkers;
    }

    public abstract QueryExecutorService getExecutorService(ServerQueryRequest var1, SchedulerGroupAccountant var2);

    public abstract int getTableThreadsHardLimit();

    public abstract int getTableThreadsSoftLimit();

    public boolean canSchedule(SchedulerGroupAccountant accountant) {
        return accountant.totalReservedThreads() < this.getTableThreadsHardLimit();
    }

    static {
        int numCores;
        LOGGER = LoggerFactory.getLogger(ResourceManager.class);
        DEFAULT_QUERY_RUNNER_THREADS = numCores = Runtime.getRuntime().availableProcessors();
        DEFAULT_QUERY_WORKER_THREADS = 2 * numCores;
    }
}

