/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.selection;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.response.broker.SelectionResults;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.utils.ArrayCopyUtils;
import org.apache.pinot.spi.utils.ByteArray;

public class SelectionOperatorUtils {
    public static final ExpressionContext IDENTIFIER_STAR = ExpressionContext.forIdentifier((String)"*");
    public static final int MAX_ROW_HOLDER_INITIAL_CAPACITY = 10000;
    private static final String INT_PATTERN = "##########";
    private static final String LONG_PATTERN = "####################";
    private static final String FLOAT_PATTERN = "#########0.0####";
    private static final String DOUBLE_PATTERN = "###################0.0#########";
    private static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = DecimalFormatSymbols.getInstance(Locale.US);
    private static final ThreadLocal<DecimalFormat> THREAD_LOCAL_INT_FORMAT = ThreadLocal.withInitial(() -> new DecimalFormat(INT_PATTERN, DECIMAL_FORMAT_SYMBOLS));
    private static final ThreadLocal<DecimalFormat> THREAD_LOCAL_LONG_FORMAT = ThreadLocal.withInitial(() -> new DecimalFormat(LONG_PATTERN, DECIMAL_FORMAT_SYMBOLS));
    private static final ThreadLocal<DecimalFormat> THREAD_LOCAL_FLOAT_FORMAT = ThreadLocal.withInitial(() -> new DecimalFormat(FLOAT_PATTERN, DECIMAL_FORMAT_SYMBOLS));
    private static final ThreadLocal<DecimalFormat> THREAD_LOCAL_DOUBLE_FORMAT = ThreadLocal.withInitial(() -> new DecimalFormat(DOUBLE_PATTERN, DECIMAL_FORMAT_SYMBOLS));

    private SelectionOperatorUtils() {
    }

    public static List<ExpressionContext> extractExpressions(QueryContext queryContext, IndexSegment indexSegment) {
        List<ExpressionContext> selectExpressions;
        HashSet<ExpressionContext> expressionSet = new HashSet<ExpressionContext>();
        ArrayList<ExpressionContext> expressions = new ArrayList<ExpressionContext>();
        List<OrderByExpressionContext> orderByExpressions = queryContext.getOrderByExpressions();
        if (orderByExpressions != null && queryContext.getLimit() > 0) {
            for (OrderByExpressionContext orderByExpression : orderByExpressions) {
                ExpressionContext expression = orderByExpression.getExpression();
                expressionSet.add(expression);
                expressions.add(expression);
            }
        }
        if ((selectExpressions = queryContext.getSelectExpressions()).size() == 1 && selectExpressions.get(0).equals((Object)IDENTIFIER_STAR)) {
            Set allColumns = indexSegment.getColumnNames();
            ArrayList<String> selectColumns = new ArrayList<String>(allColumns.size());
            for (String column : allColumns) {
                if (column.charAt(0) == '$') continue;
                selectColumns.add(column);
            }
            selectColumns.sort(null);
            for (String column : selectColumns) {
                ExpressionContext expression = ExpressionContext.forIdentifier((String)column);
                if (expressionSet.contains(expression)) continue;
                expressions.add(expression);
            }
        } else {
            for (ExpressionContext selectExpression : selectExpressions) {
                if (!expressionSet.add(selectExpression)) continue;
                expressions.add(selectExpression);
            }
        }
        return expressions;
    }

    public static List<String> getSelectionColumns(QueryContext queryContext, DataSchema dataSchema) {
        List<ExpressionContext> selectExpressions = queryContext.getSelectExpressions();
        int numSelectExpressions = selectExpressions.size();
        if (numSelectExpressions == 1 && selectExpressions.get(0).equals((Object)IDENTIFIER_STAR)) {
            String[] columnNames = dataSchema.getColumnNames();
            int numColumns = columnNames.length;
            if (numColumns == 1 && columnNames[0].equals("*")) {
                return Collections.singletonList("*");
            }
            List<OrderByExpressionContext> orderByExpressions = queryContext.getOrderByExpressions();
            if (orderByExpressions == null || queryContext.getLimit() == 0) {
                return Arrays.asList(columnNames);
            }
            ArrayList<String> allColumns = new ArrayList<String>(numColumns);
            for (String column : columnNames) {
                if (column.indexOf(40) != -1) continue;
                allColumns.add(column);
            }
            allColumns.sort(null);
            return allColumns;
        }
        ArrayList<String> columns = new ArrayList<String>(numSelectExpressions);
        for (ExpressionContext selectExpression : selectExpressions) {
            columns.add(selectExpression.toString());
        }
        return columns;
    }

    public static DataSchema getResultTableDataSchema(DataSchema dataSchema, List<String> selectionColumns) {
        HashMap<String, DataSchema.ColumnDataType> columnNameToDataType = new HashMap<String, DataSchema.ColumnDataType>();
        String[] columnNames = dataSchema.getColumnNames();
        DataSchema.ColumnDataType[] columnDataTypes = dataSchema.getColumnDataTypes();
        int numColumns = columnNames.length;
        for (int i = 0; i < numColumns; ++i) {
            columnNameToDataType.put(columnNames[i], columnDataTypes[i]);
        }
        int numResultColumns = selectionColumns.size();
        DataSchema.ColumnDataType[] finalColumnDataTypes = new DataSchema.ColumnDataType[numResultColumns];
        for (int i = 0; i < numResultColumns; ++i) {
            finalColumnDataTypes[i] = (DataSchema.ColumnDataType)columnNameToDataType.get(selectionColumns.get(i));
        }
        return new DataSchema(selectionColumns.toArray(new String[0]), finalColumnDataTypes);
    }

    public static void mergeWithoutOrdering(Collection<Object[]> mergedRows, Collection<Object[]> rowsToMerge, int selectionSize) {
        Iterator<Object[]> iterator = rowsToMerge.iterator();
        while (mergedRows.size() < selectionSize && iterator.hasNext()) {
            mergedRows.add(iterator.next());
        }
    }

    public static void mergeWithOrdering(PriorityQueue<Object[]> mergedRows, Collection<Object[]> rowsToMerge, int maxNumRows) {
        for (Object[] row : rowsToMerge) {
            SelectionOperatorUtils.addToPriorityQueue(row, mergedRows, maxNumRows);
        }
    }

    public static DataTable getDataTableFromRows(Collection<Object[]> rows, DataSchema dataSchema) throws Exception {
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        int numColumns = storedColumnDataTypes.length;
        DataTableBuilder dataTableBuilder = new DataTableBuilder(dataSchema);
        for (Object[] row : rows) {
            dataTableBuilder.startRow();
            block14: for (int i = 0; i < numColumns; ++i) {
                Object columnValue = row[i];
                switch (storedColumnDataTypes[i]) {
                    case INT: {
                        dataTableBuilder.setColumn(i, ((Number)columnValue).intValue());
                        continue block14;
                    }
                    case LONG: {
                        dataTableBuilder.setColumn(i, ((Number)columnValue).longValue());
                        continue block14;
                    }
                    case FLOAT: {
                        dataTableBuilder.setColumn(i, ((Number)columnValue).floatValue());
                        continue block14;
                    }
                    case DOUBLE: {
                        dataTableBuilder.setColumn(i, ((Number)columnValue).doubleValue());
                        continue block14;
                    }
                    case STRING: {
                        dataTableBuilder.setColumn(i, (String)columnValue);
                        continue block14;
                    }
                    case BYTES: {
                        dataTableBuilder.setColumn(i, (ByteArray)columnValue);
                        continue block14;
                    }
                    case INT_ARRAY: {
                        dataTableBuilder.setColumn(i, (int[])columnValue);
                        continue block14;
                    }
                    case LONG_ARRAY: {
                        int length;
                        int[] ints;
                        if (columnValue instanceof int[]) {
                            ints = (int[])columnValue;
                            length = ints.length;
                            long[] longs = new long[length];
                            ArrayCopyUtils.copy((int[])ints, (long[])longs, (int)length);
                            dataTableBuilder.setColumn(i, longs);
                            continue block14;
                        }
                        dataTableBuilder.setColumn(i, (long[])columnValue);
                        continue block14;
                    }
                    case FLOAT_ARRAY: {
                        dataTableBuilder.setColumn(i, (float[])columnValue);
                        continue block14;
                    }
                    case DOUBLE_ARRAY: {
                        double[] doubles;
                        int length;
                        int[] ints;
                        if (columnValue instanceof int[]) {
                            ints = (int[])columnValue;
                            length = ints.length;
                            doubles = new double[length];
                            ArrayCopyUtils.copy((int[])ints, (double[])doubles, (int)length);
                            dataTableBuilder.setColumn(i, doubles);
                            continue block14;
                        }
                        if (columnValue instanceof long[]) {
                            long[] longs = (long[])columnValue;
                            length = longs.length;
                            doubles = new double[length];
                            ArrayCopyUtils.copy((long[])longs, (double[])doubles, (int)length);
                            dataTableBuilder.setColumn(i, doubles);
                            continue block14;
                        }
                        if (columnValue instanceof float[]) {
                            float[] floats = (float[])columnValue;
                            length = floats.length;
                            doubles = new double[length];
                            ArrayCopyUtils.copy((float[])floats, (double[])doubles, (int)length);
                            dataTableBuilder.setColumn(i, doubles);
                            continue block14;
                        }
                        dataTableBuilder.setColumn(i, (double[])columnValue);
                        continue block14;
                    }
                    case STRING_ARRAY: {
                        dataTableBuilder.setColumn(i, (String[])columnValue);
                        continue block14;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unsupported data type: %s for column: %s", storedColumnDataTypes[i], dataSchema.getColumnName(i)));
                    }
                }
            }
            dataTableBuilder.finishRow();
        }
        return dataTableBuilder.build();
    }

    public static Object[] extractRowFromDataTable(DataTable dataTable, int rowId) {
        DataSchema dataSchema = dataTable.getDataSchema();
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        int numColumns = storedColumnDataTypes.length;
        Object[] row = new Object[numColumns];
        block13: for (int i = 0; i < numColumns; ++i) {
            switch (storedColumnDataTypes[i]) {
                case INT: {
                    row[i] = dataTable.getInt(rowId, i);
                    continue block13;
                }
                case LONG: {
                    row[i] = dataTable.getLong(rowId, i);
                    continue block13;
                }
                case FLOAT: {
                    row[i] = Float.valueOf(dataTable.getFloat(rowId, i));
                    continue block13;
                }
                case DOUBLE: {
                    row[i] = dataTable.getDouble(rowId, i);
                    continue block13;
                }
                case STRING: {
                    row[i] = dataTable.getString(rowId, i);
                    continue block13;
                }
                case BYTES: {
                    row[i] = dataTable.getBytes(rowId, i);
                    continue block13;
                }
                case INT_ARRAY: {
                    row[i] = dataTable.getIntArray(rowId, i);
                    continue block13;
                }
                case LONG_ARRAY: {
                    row[i] = dataTable.getLongArray(rowId, i);
                    continue block13;
                }
                case FLOAT_ARRAY: {
                    row[i] = dataTable.getFloatArray(rowId, i);
                    continue block13;
                }
                case DOUBLE_ARRAY: {
                    row[i] = dataTable.getDoubleArray(rowId, i);
                    continue block13;
                }
                case STRING_ARRAY: {
                    row[i] = dataTable.getStringArray(rowId, i);
                    continue block13;
                }
                default: {
                    throw new IllegalStateException(String.format("Unsupported data type: %s for column: %s", storedColumnDataTypes[i], dataSchema.getColumnName(i)));
                }
            }
        }
        return row;
    }

    public static List<Object[]> reduceWithoutOrdering(Collection<DataTable> dataTables, int limit) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(Math.min(limit, 10000));
        for (DataTable dataTable : dataTables) {
            int numRows = dataTable.getNumberOfRows();
            for (int rowId = 0; rowId < numRows; ++rowId) {
                if (rows.size() >= limit) {
                    return rows;
                }
                rows.add(SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId));
            }
        }
        return rows;
    }

    public static SelectionResults renderSelectionResultsWithoutOrdering(List<Object[]> rows, DataSchema dataSchema, List<String> selectionColumns, boolean preserveType) {
        int numRows = rows.size();
        ArrayList<Serializable[]> resultRows = new ArrayList<Serializable[]>(numRows);
        DataSchema.ColumnDataType[] columnDataTypes = dataSchema.getColumnDataTypes();
        int numColumns = columnDataTypes.length;
        if (preserveType) {
            for (Object[] row : rows) {
                Serializable[] resultRow = new Serializable[numColumns];
                for (int i = 0; i < numColumns; ++i) {
                    resultRow[i] = columnDataTypes[i].convertAndFormat(row[i]);
                }
                resultRows.add(resultRow);
            }
        } else {
            for (Object[] row : rows) {
                Serializable[] resultRow = new Serializable[numColumns];
                for (int i = 0; i < numColumns; ++i) {
                    resultRow[i] = SelectionOperatorUtils.getFormattedValue(row[i], columnDataTypes[i]);
                }
                resultRows.add(resultRow);
            }
        }
        return new SelectionResults(selectionColumns, resultRows);
    }

    public static ResultTable renderResultTableWithoutOrdering(List<Object[]> rows, DataSchema dataSchema, List<String> selectionColumns) {
        int numRows = rows.size();
        ArrayList<Object[]> resultRows = new ArrayList<Object[]>(numRows);
        DataSchema resultDataSchema = dataSchema;
        HashMap<String, Integer> columnNameToIndexMap = null;
        if (dataSchema.getColumnNames().length != selectionColumns.size()) {
            columnNameToIndexMap = new HashMap<String, Integer>(dataSchema.getColumnNames().length);
            String[] columnNames = dataSchema.getColumnNames();
            DataSchema.ColumnDataType[] columnDataTypes = dataSchema.getColumnDataTypes();
            for (int i = 0; i < columnNames.length; ++i) {
                columnNameToIndexMap.put(columnNames[i], i);
            }
            DataSchema.ColumnDataType[] newColumnDataTypes = new DataSchema.ColumnDataType[selectionColumns.size()];
            for (int i = 0; i < newColumnDataTypes.length; ++i) {
                int index = (Integer)columnNameToIndexMap.get(selectionColumns.get(i));
                newColumnDataTypes[i] = columnDataTypes[index];
            }
            resultDataSchema = new DataSchema(selectionColumns.toArray(new String[0]), newColumnDataTypes);
        }
        int numColumns = resultDataSchema.getColumnNames().length;
        DataSchema.ColumnDataType[] resultColumnDataTypes = resultDataSchema.getColumnDataTypes();
        for (Object[] row : rows) {
            Object[] resultRow = new Object[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                int index = columnNameToIndexMap != null ? (Integer)columnNameToIndexMap.get(selectionColumns.get(i)) : i;
                resultRow[i] = resultColumnDataTypes[i].convertAndFormat(row[index]);
            }
            resultRows.add(resultRow);
        }
        return new ResultTable(resultDataSchema, resultRows);
    }

    public static int[] getColumnIndices(List<String> selectionColumns, DataSchema dataSchema) {
        String[] columnNames = dataSchema.getColumnNames();
        Map<String, Integer> columnToIndexMap = SelectionOperatorUtils.getColumnToIndexMap(columnNames);
        int numSelectionColumns = selectionColumns.size();
        int[] columnIndices = new int[numSelectionColumns];
        for (int i = 0; i < numSelectionColumns; ++i) {
            columnIndices[i] = columnToIndexMap.get(selectionColumns.get(i));
        }
        return columnIndices;
    }

    public static Map<String, Integer> getColumnToIndexMap(String[] columns) {
        HashMap<String, Integer> columnToIndexMap = new HashMap<String, Integer>();
        int numColumns = columns.length;
        for (int i = 0; i < numColumns; ++i) {
            columnToIndexMap.put(columns[i], i);
        }
        return columnToIndexMap;
    }

    @Deprecated
    public static Serializable getFormattedValue(Object value, DataSchema.ColumnDataType dataType) {
        switch (dataType) {
            case INT: {
                return THREAD_LOCAL_INT_FORMAT.get().format(((Number)value).intValue());
            }
            case LONG: {
                return THREAD_LOCAL_LONG_FORMAT.get().format(((Number)value).longValue());
            }
            case FLOAT: {
                return THREAD_LOCAL_FLOAT_FORMAT.get().format(((Number)value).floatValue());
            }
            case DOUBLE: {
                return THREAD_LOCAL_DOUBLE_FORMAT.get().format(((Number)value).doubleValue());
            }
            case BOOLEAN: {
                return (Integer)value == 1 ? "true" : "false";
            }
            case TIMESTAMP: {
                return new Timestamp((Long)value).toString();
            }
            case BYTES: {
                return ((ByteArray)value).toHexString();
            }
            case INT_ARRAY: {
                DecimalFormat intFormat = THREAD_LOCAL_INT_FORMAT.get();
                int[] ints = (int[])value;
                int length = ints.length;
                String[] formattedValue = new String[length];
                for (int i = 0; i < length; ++i) {
                    formattedValue[i] = intFormat.format(ints[i]);
                }
                return formattedValue;
            }
            case LONG_ARRAY: {
                String[] formattedValue;
                DecimalFormat longFormat = THREAD_LOCAL_LONG_FORMAT.get();
                if (value instanceof int[]) {
                    int[] ints = (int[])value;
                    int length = ints.length;
                    formattedValue = new String[length];
                    for (int i = 0; i < length; ++i) {
                        formattedValue[i] = longFormat.format(ints[i]);
                    }
                } else {
                    long[] longs = (long[])value;
                    int length = longs.length;
                    formattedValue = new String[length];
                    for (int i = 0; i < length; ++i) {
                        formattedValue[i] = longFormat.format(longs[i]);
                    }
                }
                return formattedValue;
            }
            case FLOAT_ARRAY: {
                DecimalFormat floatFormat = THREAD_LOCAL_FLOAT_FORMAT.get();
                float[] floats = (float[])value;
                int length = floats.length;
                String[] formattedValue = new String[length];
                for (int i = 0; i < length; ++i) {
                    formattedValue[i] = floatFormat.format(floats[i]);
                }
                return formattedValue;
            }
            case DOUBLE_ARRAY: {
                DecimalFormat doubleFormat = THREAD_LOCAL_DOUBLE_FORMAT.get();
                if (value instanceof int[]) {
                    int[] ints = (int[])value;
                    int length = ints.length;
                    String[] formattedValue = new String[length];
                    for (int i = 0; i < length; ++i) {
                        formattedValue[i] = doubleFormat.format((double)ints[i]);
                    }
                    return formattedValue;
                }
                if (value instanceof long[]) {
                    long[] longs = (long[])value;
                    int length = longs.length;
                    String[] formattedValue = new String[length];
                    for (int i = 0; i < length; ++i) {
                        formattedValue[i] = doubleFormat.format((double)longs[i]);
                    }
                    return formattedValue;
                }
                if (value instanceof float[]) {
                    float[] floats = (float[])value;
                    int length = floats.length;
                    String[] formattedValue = new String[length];
                    for (int i = 0; i < length; ++i) {
                        formattedValue[i] = doubleFormat.format(floats[i]);
                    }
                    return formattedValue;
                }
                double[] doubles = (double[])value;
                int length = doubles.length;
                String[] formattedValue = new String[length];
                for (int i = 0; i < length; ++i) {
                    formattedValue[i] = doubleFormat.format(doubles[i]);
                }
                return formattedValue;
            }
        }
        return (Serializable)value;
    }

    public static <T> void addToPriorityQueue(T value, PriorityQueue<T> queue, int maxNumValues) {
        if (queue.size() < maxNumValues) {
            queue.add(value);
        } else if (queue.comparator().compare(queue.peek(), value) < 0) {
            queue.poll();
            queue.offer(value);
        }
    }
}

