/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.reducer;

import java.io.File;
import org.apache.pinot.core.segment.processing.framework.MergeType;
import org.apache.pinot.core.segment.processing.framework.SegmentProcessorConfig;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileManager;
import org.apache.pinot.core.segment.processing.reducer.ConcatReducer;
import org.apache.pinot.core.segment.processing.reducer.DedupReducer;
import org.apache.pinot.core.segment.processing.reducer.Reducer;
import org.apache.pinot.core.segment.processing.reducer.RollupReducer;

public class ReducerFactory {
    private ReducerFactory() {
    }

    public static Reducer getReducer(String partitionId, GenericRowFileManager fileManager, SegmentProcessorConfig processorConfig, File reducerOutputDir) {
        MergeType mergeType = processorConfig.getMergeType();
        switch (mergeType) {
            case CONCAT: {
                return new ConcatReducer(fileManager);
            }
            case ROLLUP: {
                return new RollupReducer(partitionId, fileManager, processorConfig.getAggregationTypes(), reducerOutputDir);
            }
            case DEDUP: {
                return new DedupReducer(partitionId, fileManager, reducerOutputDir);
            }
        }
        throw new IllegalStateException("Unsupported merge type: " + (Object)((Object)mergeType));
    }
}

